;Hugi coding competition #16
;Entry by Albe
;Assemble with: nasm -f bin -o entry.com entry.asm
;
;-albe-@libero.it
;albi81@supereva.it
;
;Status: 210 bytes (updated 29/2/2002)
;


	section	.text
	bits	16

	org	100h

;---------------------------------------------------------------

Start:
	mov	al,13h
	int	10h

	mov	al,byte [si-80h]	;skip spaces (read the number of
	add	al,97			;command line chars and add 128-31 = 97)
	xchg	si,ax

	push	word 0a028h		;start from 0xa028 (2 rows down)
	pop	es

.mainLoop:
	cwd				;AL contains the key pressed
	mov	bx,bp			;BP contains the number of the selected cell

	mov	di,bx
	xchg	ax,di

	aam	4			;AL = cell_x, AH = cell_y

	or	dh,byte [di+dummyIndex]	;DH = movement
	jz	short .badMove		;skip the invalid keys ('0', '4', '5', '6')

	shr	di,1
	jnc	short .goodMove		;if CF=0, the key pressed was
					;'2' or '8'. In this case, we don't care
					;about being in an odd or even row

	shr	ah,1			;CF = 0 if we are at an even row
					;CF = 1 if we are at an odd row
.goodMove:
	adc	bl,dh			;add the correct number to the selected cell position

	test	bl,32			;if the fifth bit is set, we've crossed the
	jnz	short .badMove		;vertical boundary of the grid

	mov	ah,bl			;horizontal boundary check:
	and	ah,3			;abs ( x_old - x_new ) < 2
	sub	al,ah			;here we have x_old = AL,
	inc	ax			;x_new = AH
	cmp	al,2
	ja	short .badMove

	cmp	byte [si+bx],0		;if the cell was already 0, it's a bad move
	jz	short .badMove
	dec	byte [si+bx]		;finally, decrement the cell value

	mov	bp,bx			;and store the cell number in BP

.badMove:
	xor	bx,bx

.again:
	call	drawCell

	inc	bx			;BX takes count of the cell to be drawn
	cmp	bl,32
	jne	short .again

	sub	si,bx
	cmp	dl,bl			;if DL = 32, then there were 32 zero cells
	je	short .done

	mov	ah,8
	int	21h

	cbw

	sub	al,30h
	jnc	short .mainLoop

.done:
	mov	al,3
	int	10h

;----------------------------------------------------

drawCell:

	mov	ax,bx
	aam	4			;calculate the screen memory position
	mov	cl,ah			;with the formula:
	imul	cx,80			;DI = (cell_y*80 + cell_x)*72
	add	cl,al
	imul	cx,72
	xchg	ax,cx
	shr	ch,1
	jnc	short .noShift

	add	al,36			;also shift odd rows 36 pixels right

.noShift:
	xchg	di,ax
	scasw				;DI=DI+2 (following rules' formula
					;DrawHexagon (address + 320*2 + 2, 16, 16, color)

	mov	ax,8			;AL contains the color of the first hexagon
	mov	cx,ax			;CX contains half the 'side' value
	mov	dh,11h			;DH contains the 'ofs' value

	cmp	byte [si],'4'		;cursor cell check
	jc	short .allRight

	mov	bp,bx

.allRight:
	and	byte [si],3		;only needed the first time
	jnz	short .drawCursor

	salc				;AL = 0
	inc	dx			;DL contains the number of zero cells

.drawCursor:
	cmp	bx,bp			;selected cell? if so, draw the border with color 15
	jnz	short .drawIt

	mov	al,15

.drawIt:
	call	drawHexagon

	salc				;draw a black inner hexagon

	call	drawHexagon

	lodsb				;draw a colored inner hexagon

	push	ax			;following rules' formula
	imul	ax,3+(2*320)
	add	di,ax
	pop	ax

	sub	cl,al

	sub	dh,al
	sub	dh,al

;----------------------------------------------------

drawHexagon:
;input	AL = color
;	DX = xoffset
;	CX = xwide
;	DI = screen offset
;

	dec	dh

	pusha

	mov	bl,dh

.drawtop:
	call	drawHalf

	inc	cx
	dec	bx
	jnz     short .drawtop

.drawbot:
	call	drawHalf

	inc	bx
	dec	cx

	cmp	dh,bl
	jnc	short .drawbot

	jmp	short eheh

;---------------------------------------

drawHalf:
;
;

	pusha

	add	di,bx
	mov	ah,al
	rep	stosw

eheh:
	popa

	adc	di,320
	ret

;---------------------------------------


dummyIndex:
	db	0,3,8,4,0,0,0,-5,-8,-4
