;*************************************************************************
; Program:       ENTRY.COM
; Created by:    Alexione
; Contact:       Aleksa Todorovic <alexione@eunet.yu>
; Started:       7-1-2002
; Last modified: 28-2-2002
; Description:   Hugi Compo #16 competition entry
; Compile with:  nasm -fbin -o entry.com entry.asm
; Assumtion:     INT 10h function 0 doesn't change PF; if it does, entry
;                is one byte larger
;*************************************************************************


;*************************************************************************
; Dedicated to:  AL register!
; Greetings:     Bonz & Ruud for motivation :)
;*************************************************************************

%define jmps    jmp short

        org     100h

entry_point:

;*************************************************************************
initialization:
        mov     ax, 0A013h
        mov     es, ax
        shr     si, 1

.loop:
        inc     si
        test    byte [si], al
        jz      .loop ; 13h and 20h = 00h, 13h and 3xh <> 0

        cbw 
        int     10h
;*************************************************************************



;*************************************************************************
; AH = 0

draw_screen:
        cwd
        mov     bp, 31

.loop_field:
        mov     cl, 8
        mov     bl, 16

.calculate_color:
        mov     al, [si + bp]

        test    al, 4
        jz      $ + 5
        push    bp ; save cursor position
        mov     ah, 15

        and     al, 3
        jz      $ + 4
        or      ah, cl ; CL = 8

..@draw_hexagon:
; BP = field
; BX = half height
; CX = half of starting width
; AH = color

        pusha

        mov     al, ah

        shld    si, bp, 14

        imul    di, si, byte 76
        add     bp, di

        shr     si, 1
        adc     bp, bp

        imul    bp, byte 36

.loop_lines:
        push    cx

        imul    di, bx, 320
        lea     di, [di + bp + 16 * 320 + 2 * 320 + 18 + 8 - 130h]
        sub     di, cx

        rep     stosw

        pop     cx

        neg     bx
        js      .loop_lines

        inc     cx
        dec     bx
        jns     .loop_lines

        popa

        cmp     ah, al
        cbw
        jne     again ; true if 1) field is empty and w/o cursor
                      ;      or 2) after filling field with color

        dec     bp
        jns     .loop_field

        pop     bx ; restore cursor position ; 5Bh
;*************************************************************************



;*************************************************************************
check_win:
        mov     cl, 3
        mov     ah, 8

        dec     dx
        jns     read_key
;*************************************************************************



;*************************************************************************
quit_program:
        xchg    ax, cx
        int     10h
;*************************************************************************



;*************************************************************************
read_key:
        int     21h

        sub     al, '0' - 2
        js      quit_program
;*************************************************************************



;*************************************************************************
do_move:
        aam     6
; here: AH = 0/1 -> down/up; AL = 3/4/5 -> left/center/right

        sub     al, 3 ; test if AL < 3 -> wrong key!
        js      .aad ; this will jump to draw_screen

; AL: left = 0, center = 1, right = 2

        ror     al, 1

; AL: left = 0, center = 128, right = 1
; note: center stands for vertical direction

        add     al, bl
        test    al, 128 + 7 ; masks column (7), 128 prevents jump if it's
                            ; vertical direction
        jz      do_move     ; true if (BL&7=0 + left) or (BL&7=7 + right)
                            ; will jump to draw_screen
        jns     .diagonal

.up_down:
        add     ah, ah
        db      02Dh, 0FCh ; SUB AX, 0FFCh ; CF <- 1

.diagonal:
        bt      bx, 2 ; 0F BA E3 02
;       MOV     DX, 02E3h ; BA E3 02

.do_move:
        adc     al, 3
.aad:
        aad     256 - 8 ; AL <- movement step, AH <- 0

        cmp     al, 32
        jae     draw_screen

        xchg    bp, ax
        test    [si + bp], cl
        jz      .up_down ; AX = -1, so calcs will give AX=008Eh >= 32

        and     [si + bx], cl ; remove cursor
        add     [si + bp], cl ; decrement color & puts cursor
        jmps    .up_down

; Note: These two tricky jumps are needed because, we have to jump to
; draw_screen with AH = 0, and AAD does that
;*************************************************************************



;*************************************************************************
again:
        dec     bx
        ja      ..@draw_hexagon

        inc     dx ; save if there are non-empty fields

        dec     bx

        inc     ah
        cmp     ah, al

        loop    again
;*************************************************************************



