;HEX GAME - Hugi Compo 16 entry
;by Aphex

;203 bytes 
;fixed -> 202 bytes 

p286
model tiny
codeseg
startupcode

start:
;	xor	ax, ax
;	mov	bx, ax
;	mov	cx, 0FFh
;	mov	di, -2
;	mov	si, 100h
;	mov	dx, cs
;	mov	bp, 924h
	
	mov	al, 13h			; video mode: 320x200x256
	int	10h                     

	push	0A000h
	pop	es			; es -> video segment

	rol	si, cl
	lodsb
	add	al, 61h
	xchg	si, ax			; si -> hex grid
	scasw				; di = position
hexgame:
	mov	cl, 16			; cx = variable hexagon width
	pusha
draw32:
	mov	dx, cx			; dx = variable hexagon offset
					
	mov	al, 7   		; ax = 7 first time, then ax = 807h
	and	ax, [si]		; ah = 0 because high byte of [si] 
					; will be either 00110xxxb or 0Dh 

	jz	outer_cursor
	cmp	al, 4
	mov	al, 8
	jb	outer_cursor
p386
	mov	fs, di			; fs -> cursor position
p286
	mov	al, 15
					; al = border color
outer_cursor:	

hex3:

	pusha

	mov	bl, 14	

	push	ax
	mov	ax, di
	imul	ax, 40
	xchg	di, ax			; di = pos*40
	test	al, 4
	jz	notoddrow               ; if odd row
	inc	di			; di ++
notoddrow:	
	and	al, 3
	imul	ax, 38
	sub	di, ax			; di -= (pos & 3)*38
	imul	di, 36			; di *= 36

	mov	al, 12h			; ah = 0
	sub	ax, dx
					; ax = 12h-dx
useit:                                  ; first time it uses the above ax
					; second time it uses ax = color*2
	imul	ax, 1+320
	add	di, ax   		; di += ax*321
	pop	ax
	
	cmp	dl, bl
	jne	nocolorhex
					; color hex
	add	di, ax    		; di += color
	push	ax
	add	ax, ax			
	sub	dx, ax                  ; dx -= color*2
	sub	cx, ax			; cx -= color*2
	dec	bx			; so that next time dl <> bl
	jmp	useit
nocolorhex:
					; di = screen pos
					; al = color
					; dx = width offset
					; cx = width
drawhex:
	pusha
        add     di, dx                  ; adjust di with offset
	pusha
        rep     stosb			; draw hex (above half)
	popa
	;fix by Aphex 6 March 2002
	;comment line below
	;dec	dx
 	;/fix
	imul	dx, 640
	add	di, dx 			; adjust di for below half
	rep	stosb			; draw hex (below half)
	popa
        add     di, 320			; point to next line
	inc	cx			
	inc	cx
	dec	dx
	;fix by Aphex 6 March 2002
	;change the jnz with a jns
        jns     short drawhex
	;/fix
	popa

	mov	al, [si]                ; al = color
	and	al, 3
	org	$-1
keysoff:				; note: the byte before keysoff and
					; the 3 dummy bytes (?) must be outside
					; [-32(=-31-1 for inc di), 31] range, 
					; so that the according key will be
					; rejected due to validation rule that 
					; enforces the position to be in
					; [0, 31] range
	db	3, 8, 4, ?, ?, ?, -5, -8, -4
	org	$-6
	and	al, dl			; first time al = al & 10h = 0 
					; second time al = al & 0Fh = al
	dec	dx
	org	$+3
	add	bx, ax                  ; bx = checksum
	cmp	cl, dl			
					; cl = 10h, dl = 0Fh, dif = 1, p = 0
					; cl = 10h, dl = 0Eh, dif = 2, p = 0
					; cl = 10h, dl = 0Dh, dif = 3, p = 1
	jnp	hex3

	cmpsb				; si ++, di ++
	cmp	[si], dl		; if [si] = 0Dh
        jne     draw32                  ; end draw

	dec	bx			; if no hex left (only cursor is drawn)
	popa

	mov	cl, 3			; cl = video mode
	js	exit			; exit

	mov	ah, 8
	int	21h			; fetch key
	cmp	al, 27			; if Esc
	je 	exit			; exit
	pusha
p386
	mov	bp, fs
p286

	test	al, 5	
	xchg	bp, ax
	mov	bx, ax
p386
	movsx	di, byte ptr [bp+offset keysoff-831h]
					; di = movement offset
p286        
	                                ; only 0 .. 9 keys are handled!

	jz	ok      		; if 0,2,8 then skip following
	test	al, 4
	jz	skip
	inc	di     			; if odd row then adjust movement offset
skip:
	dec	bp			; check key
	jp	skip2		
	inc	ax                      ; for 3,5,9 inc ax
skip2:
	test	al, 7			; check edges
	jz	beforejump	
ok:
	lea	bp, [bx+di]		; bp -> new position
	cmp	bp, 32			
	jnb	beforejump              ; if not in range then skip
					; cl = 3 here!
	test	byte ptr [bp+si], cl
	jz	beforejump		; if empty then skip

	and	byte ptr [bx+si], cl	; remove cursor from old pos
	add	byte ptr [bp+si], cl	; add cursor to new pos
					; and change color (decrease)
beforejump:
	popa
	jmp	hexgame

exit:
	xchg	cx, ax			; ax = 3
	int	10h			; set video mode to text mode 3
        ret				; exit to DOS

end start


