;----------------------------------------------------------------------------;
;									     ;
;		entry for hugi compo #16 - 178 (174+4) bytes total	     ;
;		 by Boiled Brain (pogonyshev@tut.by, Belarus)		     ;
;									     ;
;      compile: tasm /m2 entry.asm					     ;
;     and link: tlink /t entry.obj					     ;
;									     ;
; ripping note: i learned aam/aad n commands  from hugi compo mailing list.  ;
;		they are undocumented, but looking at D4 0A/D5 0A opcodes i  ;
;		should have understood that aam/aad are just short forms of  ;
;		aam/aad 10. i've never looked attentively though :)	     ;
; ripping note: this entry uses undocument instruction salc (setalc). i saw  ;
;		it for the first time in some entries for hugi compo #12.    ;
;  fixing note: entry includes 4 bytes fix needed to quit on empty starting  ;
;		field.	moving dh contents to cx could give single byte fix  ;
;		(actually, it could save 1 byte and give 2 bytes fix).	     ;
;									     ;
; thanks go to Adok for his nice compos and all the opponents for making it  ;
; interesting to particiate ;)						     ;
;----------------------------------------------------------------------------;

		ideal
		p186
		model	tiny
		codeseg
		org	100h
;----------------------------------------------------------------------------;
;		macro salc (setalc) - undocumented instruction (1 byte)      ;
;  copies cf flag to all bits of al (that is, cf=0 gives al=00h, cf=1 gives  ;
;  al=0FFh). all flags remain untouched.				     ;
;----------------------------------------------------------------------------;
		macro	salc
		db	0D6h
		endm	salc
;----------------------------------------------------------------------------;
;		main procedure (program entry point)			     ;
;  input: assumes that ah=00h, bh=00h, ch=00h, si=0100h 		     ;
; output: should follow all hugi compo #16 rules			     ;
;----------------------------------------------------------------------------;
		proc	Main
		;; setting up display - 8 bytes ;;
		mov	al,13h
		int	10h			; set 320x200x256 mode
		push	9CA9h			; offset will overflow when
						;  moving to the 8th row
		pop	es			; es=9CA9h -> VRAM
		;; command line processing - 22 bytes ;;
		shr	si,1			; si=80h
		lodsb				; ax=command line length
		add	si,ax			; si -> command line end;
						;  also, cf=0
		cwd				; dx=0
ScanningLoop:
		dec	si			; scan the command line
						;  (cf is untouched)
		jnc	NotCursorCell		; if not a cursor cell
		add	dx,si			; save cursor address in dl
NotCursorCell:
		xchg	al,[si] 		; get next character and
						;  save extracted color
		aam	4			; ah=character/4, al=color,
						;  also space gives ah=8
		add	dh,al			; color sum
		sahf				; cf="it is the cursor cell"
		jp	ScanningLoop		;  pf="it is not a space"
		sub	dx,si			; dl=cursor offset in field
		;; drawing the grid - 82 (78+4) bytes ;;
DrawGrid:
		salc				; cf=0, so al=0=cell index
		mov	di,320*18+3+16+3570h	; di=address of the lefmost
						;  pixel of the first line
						;  of the first hex+16*320
NextRow:
		test	al,100b 		; if row is even, then all's
		jz	EvenRow 		;  ok, else we'll correct di
SameRow:
		add	di,72			; next hexagon address
EvenRow:
		pusha				; save ax, dx and di
		cmp	al,dl			; are we at cursor?
		mov	cl,16			; width of the topmost line
		cwd				; dx=0=(halfheight-1)-
						;  -topmost line width
		cbw				; ax=cell index
		xchg	ax,bx			; move cell index to bx
		mov	al,15			; color of cursor border
		je	DrawHexagon
		cmp	ch,[si+bx]		; sets cf if cell isn't black
DrawBlackHex:
		salc				; al=8 if cf is set,
		and	al,8			;  al=0 otherwise
DrawHexagon:
		pusha				; save cx, dx & di
		add	dx,cx			; set dx to halfheight-1
NextLines:
		dec	di			; decrement x coordinate
NextLine:
		pusha				; save cx, dx & di once more
		imul	dx,320			; convert height to offset
		add	di,dx			; and apply it
		rep	stosb			; draw a line
		popa
		neg	dx			; flip top <--> bottom
		js	NextLine		; and draw top line
		inc	cx
		inc	cx			; increase width
		dec	dx			; go closer to the center line
		jns	NextLines
		popa
		dec	dx			; height decreases faster than
						;  topmost line width
		jp	DrawBlackHex		; jumps only if dx=-1 (only
						;  one hex has been drawn);
						;  cf is cleared by neg dx
		xor	al,[si+bx]		; if al=0 after xor then inner
						;  cell has already been drawn
						;  or it's black
		add	di,ax			; adjust hexagon position
		sub	cx,ax			;  and size
		sub	cx,ax			;  (also clears af & cf)
		daa				; check whether al=0
		jnz	DrawHexagon
		popa				; restore ax, dx and di
		inc	ax			; next cell
		test	al,11b			; end of row?
		jnz	SameRow
		add	di,320*18-3*72-36	; move to next row
		jnc	NextRow 		; won't go to the 8th row
						;  (di will be equal to 3)
		; >>> fix: quitting on empty starting grid - 4 bytes
		test	dh,dh			; is field empty?
		jz	Quit			; quit if so
		; <<< fix
		;; processing keyboard input - 34 (34+0) bytes ;;
GetKey:
		int	21h			; read a key (ah=8)
		cmp	al,27			; is it Esc?
		je	Quit
		mov	bl,-8			; bl=delta for moving up
		sub	al,'7'			; maps keys 7 - 9 -> 0 - 2
		jnc	MovingUp
		mov	bl,8			; bl=delta for moving down
		add	al,'7'-'1'		; maps keys 1 - 3 -> 0 - 2,
						;  0, 4 - 6 -> n, n>2
MovingUp:
		cmp	al,2			; distinguishes all cases
		; >>> fix: label changed to DrawGrid - 0 bytes
JaDrawGrid:
		ja	DrawGrid		; it was key 0, 4, 5 or 6;
						;  may jump to GetKey as well,
						;  but is used by later ja
		; <<< fix
		je	MovingRight		; key 3 or 9 - moving right
		jp	BorderOk		; key 2 or 8 - moving down/up
		dec	bx			; adjust delta for keys 1 & 7
MovingRight:
		sar	bl,1			; delta for moving diagonally
						;  is twice smaller
		mov	al,dl			; al=cursor position
		test	al,100b 		; is cursor in an odd row?
		jz	CursorInEvenRow
		inc	bx			; then we'll correct delta
CursorInEvenRow:
		;; validating move - 20 (20+0) bytes ;;
		test	bx,di			; only odd deltas (di=3)
		jz	BorderOk		;  break borders
		inc	ax			; and only if
		test	al,110b 		;  (cursor position) mod 8=
		jz	GetKey			;  =0 or 7
BorderOk:
		add	bl,dl			; bl=new cursor position
		cmp	bl,31			; out of field?
		; >>> fix label changed to GetKey - 0 bytes
		ja	GetKey
		; <<< fix
		cmp	[si+bx],ch		; can't step on black cells
		jz	GetKey
		;; doing the move - 8 bytes ;;
		dec	[byte si+bx]		; decrement the color
		mov	dl,bl			; save new cursor position
		dec	dh			; decrement color sum
		ja	JaDrawGrid		; cf is cleared by cmp
Quit:
		;; cleaning up - 4 bytes ;;
		xchg	ax,di			; di=3
		int	10h			; restore text mode
		ret				; return to DOS
		endp	Main
		end	Main			; that's all
