;***************************************************************
;///////////////////////////////////////////////////////////////|
;| Hexagon game for Hugi Coding Competition by Codel.		    |
;| entry.com is big but I wanted to participate anyways, and I  |
;| hope you do not laugh too much about the size. ;)		    |
;| compile with nasm -fbin -oentry.com entry.asm		    |
;| Enjoy it!!!							          |
;| Thanks to the test suite!!!!				          |
;///////////////////////////////////////////////////////////////|
;***************************************************************

section .bss

cursorcell	resw	1	;data
hexgrid		resb	32

	section .text
.386
	org 100h		; .com start

go:
	
	mov 	si, 80h		

spaces:

	inc     si		;take spaces
	cmp     byte [si], 20h
	je      spaces

initgrid:

	lodsb
	cmp	al,'4'		;initializes drawing of the grid
	jb	notstart
	mov	[cursorcell],bx

notstart:
	and	al,03h
	mov	[bx+hexgrid],al
	inc	bx
	cmp	bx, byte 32
	jnz	initgrid
	mov	al,13h		;vga mode 13h
	int	10h		;
	mov	ax,0A000h 	;
	mov	es,ax		;vram

mainloop:
	xor	bx,bx		
	
win_loop:	
	cmp	byte [bx+hexgrid],0
	jnz	short prosigue
	inc	bx
	cmp	bx,byte 32
	jnz	win_loop
prosigue:
	jz	quit
	xor	bp,bp ;cell=0
	@@again:
      mov	al,15 ;colour
	cmp	bp, [cursorcell]
	jz	short outer_cursor
	mov	al, [bp+hexgrid]
	cmp	al,0		;empty cells are colour 0
	jz	outer_cursor
	mov	al,8		;otherwise are 8
outer_cursor:
	call	ScreenPixel
	add	di,2+(2*320)
	mov	dl,16 ;	x+2 y+2
	mov	cl,dl  		;cx=16 dx=16
	push	cx
	push	dx
	call	DrawHexagon

	call	ScreenPixel
	add	di,3+(3*320)
	pop	dx
	dec	dx		;cx=16 dx=15
	pop	cx
	xor	al,al		;colour (0)
	call	DrawHexagon

	mov	al,[bp+hexgrid]
	and	ax,00FFh
	jz	continue

	call	ScreenPixel
	add	di, 4+(4*320)
	push	ax
	mov	dx,3+(2*320)
	mul	dx
	add	di,ax		;x+3n   y+2n
	pop	ax

	mov	dl,14
	sub	dx,ax
	sub	dx,ax		;14 - 2(n)
	mov	cl,16		;
	sub	cx,ax		;
	sub	cx,ax		;16 - 2(n)
	call	DrawHexagon

continue:
	inc	bp
	cmp	bp,byte 32
	jnz	@@again
	mov	ah,08h
	int	21h
	cmp	al,27
	jz	quit
	call	CheckKeys
	jmp	short mainloop
quit:
	mov	ax,0003h
	int	10h
	ret

CheckKeys:
        mov     bx, [cursorcell]
        push	bx
	push	bx
	pop	cx
	;mov     cx, bx
        and     cx, 0003h               ; xpos = cell MOD 4
       	pop	dx
	;mov     dx, bx
        shr     dx, 2                   ; ypos = cell DIV 4

        
	cmp	al,'0'
	jz	finish
	cmp     al, '8'
        jz      move_up
        cmp     al, '2'
        jz      move_down

        test    bl, 4
        jnz     odd_row_keys            ; is cursor on odd row ?

        cmp	al,'7'
	je	even_up_left
	jg 	even_up_right
	cmp	al,'3'
	je	even_down_right
	jb	even_down_left                  ; pos + 3
        
                        ; x < 1 ?
                        ; y >= 7 ?
        
        

odd_row_keys:
      cmp	al,'3'
	je	odd_down_right
	jb	odd_down_left
	cmp	al,'7'
	je	odd_up_left
	jg    odd_up_right                 ; pos - 3
        
                                            ; x >= 3 ?
        
                                        ; y < 1 ?
finish:     	
	ret

good_move:
        mov     al, [bx+hexgrid]        ; 0 --> 1
        cmp     al, 0
        jz      bad_move
        dec     byte [bx+hexgrid]            ; cell[pos]-1
        mov     [cursorcell], bx
bad_move:
        ret

move_up:
        sub     bx, byte 8                   ; pos - 8
        jge     good_move
        ret

move_down:
        add     bx, byte 8                   ; pos + 8
        cmp     bx, byte 32
        jl      good_move
        ret

even_up_left:
        sub     bx, byte 5                   ; pos - 5
        cmp     cx, byte 1
        jl      bad_move                ; x < 1 ?
        cmp     dx, byte 1
        jl      bad_move                ; y < 1 ?
        jmp     short good_move

even_up_right:
        sub     bx, byte 4                   ; pos - 4
        cmp     dx, byte 1
        jl      bad_move                ; y < 1 ?
        jmp     short good_move

even_down_left:
        add     bx, byte 3                   ; pos + 3
        cmp     cx, byte 1
        jl      bad_move                ; x < 1 ?
        cmp     dx, byte 7
        jge     bad_move                ; y >= 7 ?
        jmp     short good_move

even_down_right:
        add     bx, byte 4                   ; pos + 4
        cmp     dx, byte 7
        jge     bad_move                ; y >= 7 ?
	jmp	short good_move
	
odd_up_left:
        sub     bx, byte 4                   ; pos - 4
        cmp     dx, byte 1
        jl      bad_move                ; y < 1 ?
        jmp     short good_move

odd_up_right:
        sub     bx, byte 3                   ; pos - 3
        cmp     cx, byte 3
        jge     bad_move                ; x >= 3 ?
        cmp     dx, byte 1
        jl      bad_move                ; y < 1 ?
        jmp     short good_move

odd_down_left:
        add     bx, byte 4                   ; pos + 4
        cmp     dx, byte 7
        jge     bad_move                ; y >= 7 ?
        jmp     good_move

odd_down_right:
        add     bx, byte 5                   ; pos + 5
        cmp     cx, byte 3
        jge     bad_move                ; x >= 3 ?
        cmp     dx, byte 7
        jge     bad_move                ; y >= 7 ?
        jmp     good_move

DrawHexagon:
	mov	bx,dx			;xstart = xoffs
@@drawtop:
	call	Drawing			
	inc	cx			;xwide + 2
	inc	cx
	dec	dx			;xoffs - 1
	jnz	@@drawtop

@@drawbot:
	call	Drawing
	dec	cx
	dec	cx
	inc	dx
	cmp	dx,bx
	jle	@@drawbot
	ret
ScreenPixel:
	push	ax
	mov	ax,bp
	shr	ax,2
	mov	dx,(320*18)
	mul	dx			; scr pixel = (bp/4)*320*18
	xchg	di,ax
	
	test	bp,4
	jz	@@evenscr
	add	di, byte 36		;; odd row then di + 36
@@evenscr:
	mov	ax,bp
	and	ax,byte 3
	mov	dx,(48+16+8)
	mul	dx
	add	di,ax			; scr pixel + (bp mod 4)*(48+16+8)
	pop	ax
	ret
		
Drawing:
	push    cx
        push    di
        add     di, dx                  ; scr pixel + xoffs
        rep     stosb                   ; draw xwide pixels
        pop     di
        add     di, 320
        pop     cx
	ret


	
	
	
	
	

	
	


