;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
; HC#16 entry by gbm <gbm@ii.pw.edu.pl>, version 9, 167/166 bytes
;
; compile:
;	nasm -o entry.com entry.asm
;
; lame puzzle - colour the grid all the same colour (black) using
; the [7][8][9] and [1][2][3] keys for movement around the hex grid.
;
; pass the 32-char 'board' on the command-line using chars
; '0....7' with '4567' being used to denote cursor start
; example: entry.com 01203120033101530333333302121111
;____________________________________________________________________

;EAX = xxxx****, AL/AH = 00 if 1st/2nd FCB drive letter valid, FF if not
;EBX = xxxx0000
;ECX = xxxx00FF
;EDX = xxxxxxxx, DX = CS = DS = ES = SS = xxxx, 0080 <= DX <=9000.
;ESI = xxxx0100
;EDI = xxxxFFFE
;EBP = xxxx09xx
;ESP = xxxxFFFE
;EIP = xxxx0100

	section	.text
	
	org	100h
start:
	; video setup
	mov	al, 13h
	int	10h
	; scan grid from command-line
	shr	si, 1
spaces:
	inc	si
	test	[si], al
	je	spaces

	stc	; for 3rd instr in keytab
	push	word 0A000h+41
keytab1	equ	$-1
	pop	es	; 7
	adc	[bx+di], cl	; 16, 9 -- cl = ff, cy = 1
	cwd
	jns	newpos
	div	ax	; F7 F0 -- -9, -16
	stc		; F9 -- -7

	;; --- main loop --- ;;
processkey:
	; ah = 8, bh = 0, ch = 0, dl=3, cy=0
	; uses al, bl
	xlatb
	add	al, cl	; update pos, al=new
	test	al, 0c0h
	jnz	nochange
	test	al, 9
	jpo	nochange

	shr	al, 1	; real index
	mov	bl, al
	test	byte [si+bx], dl
	jz	nochange
	add	byte [si+bx], dl
newpos:

; on first entry ax=13h, bx = 0, cx=ff, dx = ?
;---------------------------------------------------------------
; Draw the entire 4x8 hexagon grid with cursor
;---------------------------------------------------------------
	mov	bx, 3fdfh	; 63 : -31
	mov	bp, 31
	mov	di, (160*7+7)*36+16*319+2
;---------------------------------------------------------------
; Draw a hex cell - deals with outer/inner hexagon + cursor
;---------------------------------------------------------------
DrawHexCell:
	mov	ax, 803h	; color, multiplier
	mov	dx, ax		; yheight = 17

	test	bh, 9
	jpo	nothing

	test	byte [si+bp], al
	jnz	cursor1
	cbw
	inc	bx
cursor1:
	test	byte [si+bp], 4
	jz	normal_cursor
	mov	cl, bh	; save position
	mov	ah, 15
normal_cursor:
	; ax = 0x03, cx=00xx, dx=0803, bp=00xx
	pusha
	mov	cl, 24			; xwide = 16
	and	byte [si+bp], al
	call	DrawHexagon	; draw outer board/cursor
	mul	byte [si+bp]
draw0:	call	DrawHexagon	; draw inner gap (0)
	dec	ax
	jns	draw0
	mov	ah, [si+bp]
	sub	dh, [si+bp]
	call	DrawHexagon	; draw color hexagon
	popa
	; ax = 0x03, cx=00xx, dx=0803, bp=00xx
	dec	bp
nothing:
	lea	di, [di-36]
	test	bh, 7
	jnz	samerow
	lea	di, [di-(18*320-288)]
samerow:
	dec	bh
	jns	DrawHexCell
	; ax=0x03, cx=00xx, dx=0803
;---------------------------------------------------------------
; Check for win (entire board = empty cells)
;---------------------------------------------------------------
	inc	bx
	xchg	ax, dx
	jz	quit
	; ax=0803, dx=0x03
;---------------------------------------------------------------
; Get and process key
;---------------------------------------------------------------
nochange:
	int	21h
	mov	bx, keytab1-'0';+1bh
	cmp	al, 1bh
quit:	; set text mode
	jne	processkey
	xchg	ax, dx
	cbw	; ax=0003
	int	10h
	ret
;-----------------------------------------------------------------
; Draw hexagon: ES:DI@start, ah=color, cx=mid width, dh=top width
;-----------------------------------------------------------------
DrawHexagon:
	mov	bx, -320
dohalf:
	pusha
	mov	al, ah
nextline:
	pusha
	rep	stosw			; draw xwide pixels
	popa
	lea	di, [di+bx+1]
	cmp	cl, dh
	loopne	nextline

	popa
	neg	bx
	jns	dohalf

	inc	di
	dec	cx
	ret
