;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;    rkz entry for hugi compo #16
;	
;	Thanks gbm for numerous hints.
;
; compile:
;       nasm -fbin -oentry.com entry.asm


        section	.text
	
        org 256

go:
        mov     al, 13h
        int     10h
	push	word 0A000h
	pop	es

	shr	si, 1	; si <- 80h

spaces:			; skip spaces
	inc	si
	cmp	byte [si], ' '
	je	spaces
	cwd
	mov	dl, 3		; const 3

mainloop:
	mov	bl, 31	; last cell index
	mov	di, 8*18*320 + 7*36 + 2
	mov	cl, bh

nextcell:
	mov	al, [si+bx]
	aam	4
	mov	[si+bx], al
	sahf
	cbw
	jnc	notactive
	mov	bp, bx
	mov	ah, 0Fh
notactive:
	dec	ax
	or	ah, 8
	inc	ax
	xchg	ah, al
	add	cl, ah	; counting total cell weight

drawcell:
	pusha
	call	drawhexagon
	popa

	;; decrement address
	xchg	ax, di
	sub	ax, 72
	test	bl, dl
	jnz	exitdec
	sub	ax, 18*320 - 4*72
	xor	al, 36
exitdec:
	xchg	ax, di

	dec	bx
	jns	nextcell

	;; jcxz	quit	; this should be used for degenerate starting grid

getkey:
        mov     ah, 08h
        int     21h
        cmp     al, 27
        jz      quit

	cbw
	xchg	ax, bx

	mov	ax, bp
	aam	4
	sahf
	adc	al, al
	aad	8

	add	al, [bx+coordelta-30h]
	test	al, 49h
	jpo	getkey

	shr	al, 1

	xchg	ax, bx

	test	byte [si+bx], dl
	jz	getkey

	add	byte [si+bx], dl
	loop	mainloop

quit:
        ;; vid mode 3 ;;
	xchg	ax, dx
        int     10h
	ret

;
; es:di  address of the leftmost pixel drawn
; ah color (inner) al color (border)
drawhexagon:
	mov	bl, 16
	mov	cl, 48
	cwd 
	call	drawhex
	inc	dx
	salc
	call	drawhex

	xchg	al, ah
	imul	dx, ax, byte 2
	sub	bx, dx
	add	dx, ax
	inc	dx
	inc	dx
;
; cx - maximum width of hexagon
; bx - minimum width of hexagon
; dx - offset (<256)
; es:di - address of the leftmost pixel of the hexagon
; al - color

drawhex:
	mov	si, -320
	call	drawline
	neg	si
drawline:
	pusha
	add	di, dx
	sub	cx, dx
	sub	cx, dx
	mov	dl, 1
	pusha
	rep	stosb
	popa
	add	di, si
	cmp	bx, cx
	jae	drawexit
	call	drawline
drawexit:
	popa
	ret

coordelta	
		db	8
		db	007h, 010h, 009h
		db	008h, 008h, 008h
		db	0F7h, 0F0h, 0F9h



