; Entry for Hugi size coding compo #16
;
; By Ruud v Gessel
;
; Thanx all for any feedback or suggestions
;
; Special thanx to TAD and Bonz for creating the test-suite and rules
; and any other activities to make the compo worth while
;
                    .MODEL    TINY
                    .386

_AAD                MACRO     N
                    db        0d5h,n
                    ENDM

_AAM                MACRO     N
                    db        0d4h,n
                    ENDM

                    .CODE
                    ORG       100h

; Start of code, init loop
;
; Assumes : CX=00FFH, commandline = numbers mixed with spaces followed by 0dh
;
; 1) initialize a table at 3e0h with pure colors
; 2) set bx is pointer to active field
; 3) set cx is number of legal moves needed to solve the game
; 4) set video mode is 13h

Start:              mov       si,81h              ;si=81h
                    mov       di,03dfh            ;Colors at 3e0h-400h
@ls0:               jnc       @ls1                ;>> Not active field
                    mov       bx,di               ; bx points to active field
@ls1:               stosb                         ;Stuff pure color
@ls2:               lodsb                         ;Color source byte
                    _AAM      4                   ;al=pure color, ah=flag
                    add       cl,al               ;add one for 0dh, cx was 0ff
                    sahf                          ;PF if bit 4, CF if bit 2
                              ;-( Hi TAD ;-) Thanx BCD junky!!!
                    jpe       @ls0                ;>> Bit 4 set->valid number
                    jnc       @ls2                ;>> Bit 2 clear -> space
                    _AAD      6                   ;Convert 301h to 0013h
                    int       10h                 ;Set video mode 13h

; Drawing loop, draws all hexagons
;
; Assumes : bx is pointer to active field
;           cx is number of legal moves needed to solve the game

DrawMove:           mov       dx,bx               ;DX pointer to active field
                    push      9c9ch               ;Calculated value video seg
                    
                    ; Double meaning, 4 bytes -> 3 useful instructions

                    db        0beh,0c0h           ;mov si,-140h (eats the fe)
Ooops:              db        0feh                ;Inc byte [bx] (eats the 7)
                    db        7                   ;pop es ES used for video

DrawAll:            mov       bl,0e0h             ;BX at first color
                    mov       di,4cbfh            ;DI video starting point

DrawOne:            mov       ax,0f810h           ;Multi purpose value
                    pusha                         ;Need to save registers
                    mov       cl,13h
                    cmp       dx,bx               ;Active field ?
                    je        @dec_ax             ;>> Active field
                    sub       al,[bx]             ;Nonzero color sets bit3
                    db        24h                 ;"and al,48h", eats dec ax
@dec_ax:            db        48h                 ;dec ax Active border = 0fh

                    ;Loop to get cx=cx-2col, di=di+3col, ah+=col, al=col

@IncCol:            adc       ax,100h
                    dec       cx
                    scasw
                    cmp       al,[bx]             ;Color reached?
@NextCol:           inc       di
                    dec       cx
                    jc        @IncCol             ;Nope loop color times
                                                  ;Or skip if border or 0

; Draws a solid hexagon, color in AL, size info in CX, AH
; Draws bottom half for SI 320, top half for SI -320

@bh1:               pusha
@bh0:               pusha
                    sub       cl,ah               ;Sets CF !
                    mov       ah,al
                    rep stosw
                    popa
                    adc       di,si               ;Up/Down +1 to the right
                    loop      @bh0                ;Line length - 2
                    popa
                    neg       si                  ;Flip Up/Down direction
                    jns       @bh1                ;Loop until si -320 again

                    cmp       al,[bx]             ;Was it color?
                    mov       al,0                ;Hate this one but....
                    jne       @NextCol            ;Draw next color

; Next hexagon
                    popa                          ;Restore registers
                    inc       bx                  ;At next color byte

TableTrim EQU low (offset MoveTable-830h-0bfh-0f810h)

; 830h   for ascII + 800h returned from int 21h
; 0bfh   for current DI value
; 0f810h for current ax value
; Currently TableTrim = about 5dh (well within 20h and 0e0h)

                    ; Move table including some useful instructions
                    ; Values between 20h and 0dfh ensure an invalid move!
                    ; Valid table values are 3,8,4,fb,f8,fc. All others
                    ; should be between 20h and 0e0h --> invalid move

MoveTable:          mov       bp,803h       ; bd 03 08 for ah=8, table offset
                    add       al,TableTrim  ; 04 xx    for table offset
                    xchg      ax,bp         ; 95       ah=8, bp table offset
                    test      bh,bl         ; 84 fb    bh=3  test for row skip
                    clc                     ; f8       lost byte
                    cld                     ; fc       lost byte

                    jne       @bf0                ;>> No row skip
                    add       di,1584h            ;To next row
                    jpo       @bf1                ;>> Even line
@bf0:               add       di,48h              ;Add 72
@bf1:               jnc       DrawOne             ;>> Loop until all drawn

; Handle the keyboard input and escape test, also put al bit 0 in al bit 2

                    int       21h                 ;Getch
                    add       bp,ax               ;Table offset see TableTrim
                    imul      bh                  ;al*4, ah=0, OV-> AL>20h
                    jno       Done                ;<20h -> maybe escape

; Handle move adding and border check... (Bit tricky but works great!)

                    mov       bx,dx               ;Pointer to current field
                    and       al,4                ;Bit 2 set if odd key
                    xor       al,dl               ;Bit 2 toggles for odd row
                    cmp       al,dl               ;CF if odd row and odd key
                    adc       bl,[bp+di]          ;Nicely in MoveTable !!
                    xor       al,bl               ;Bit difference with result
                    and       al,0e4h             ;Odd key MUST toggle 1 row
                    jne       DrawAll             ;>> Border or error key

                    dec       byte ptr [bx]       ;Update field color (or not)
                    js        Ooops               ;Ooops, was 0, undo change
                    loop      DrawMove            ;Count down and loop

Done:               mov       al,3
                    int       10h
                    ret

                    END       Start

