; SNIPER
; Forever Young Software
; http://www.cybertrails.com/~fys/index.htm
; fys@cybertrails.com
;
; ENTRY.COM (208 bytes)
; NBASM 00.25.00  (http://www.cybertrails.com/~fys/newbasic.htm)
; 02 Mar 2002                    ( ver 00.25.00 not available yet :-)
;
; ************************
;  I used my own assembler, NBASM, to assemble this file.  It produces
;   code very similar to MASM and TASM.  If you object to me using
;   my own assembler, please let me know and I will continue using
;   MASM in the future.
; ************************
;
; ************************
;  Thanks goes to TAD, Ruud, and Bonz for the compo
;   (okay, I don't know for sure that Ruud and Bonz helped,
;    but there name is in the examples and test files. :)
; ************************
;
; ************************
;  Thanks goes to Boreal for the 'push' to get this entry out :)
;  Thanks goes to Ruud for the table hint.
;   (even though he thinks he didn't give me a hint at all :)
;  Hi claw......
; ************************
;

HEXGRID    equ 0300h    ; above our code and 100h aligned
                        ;  and high byte = 0000_0011b for tests

.model tiny
.code
.386

           org  100h

           mov  di,HEXGRID

           ; the following places all numbers entered at the command
           ;  line into HexGrid. (0 - 7)
           ; we can assume there will be only one value > 4
           ;  and it will be the current cursor position
           mov  si,81h             ;
initgrid:  lodsb                   ;
           sub  al,'0'             ;
           js   short initgrid     ;
           stosb                   ;
           loop short initgrid     ;

           ; ax = 000xh  ; where x = last digit entered (0-7)
           ; bx = 0000h
           ; cx = 0000h
           ; dx = cs

           ; vga mode 13h (320x200x256)
           mov  al,13h             ; ah = 0 at startup
           int  10h

; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;  main loop
mainloop:  mov  bp,0A000h          ; we need low(bp) = 00h
           mov  es,bp              ; es = 0A000h

; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-  ; step 2
; Draw the entire 4x8 hexagon grid with cursor
           ; ax = last cursor position ?
           ;      (except of first time where ax = xxxxh)
           ; bx = 0140h ?
           ;      (except of first time where bx = 0000h)
           ; cx = 00xxh (1Fh ? )
           ;      (except of first time where cx = 00FFh)
           ; dx = 00xxh where xx = last count of lines/2
           ;      (except of first time where dx = cs)
           mov  di,51842   ; CA82h
           mov  ax,31              ; ax = index into hexgrid (zero based)
dh_again:  push ax

           mov  bl,al              ; calculate bx for below
           mov  bh,03h

           sub  di,72
           test al,0000_0011b      ; is it the next row up? (xxxx_xx11b)
           jz   short notnextrow   ; two jmp tests allow us to not
           jnp  short notnextrow   ;   modify al opposed to:
                                   ;     and  al,0000_0011b
                                   ;     cmp  al,0000_0011b
                                   ;     jne  short notnextrow
           sub  di,(((16*320)+352)+36)
           test al,0000_0100b      ; al is unmodified
           jz   short notnextrow
           add  di,(36<<1)
notnextrow: ; es:di -> top left corner of hexagon
           push di

           ; we will start by drawing a filled hexagon of either
           ;  color 8 or 15 (or 0 if nothing there).
           ; then draw a black filled hexagon just inside that one

           ; get the color of the hexagon and if is current cursor,
           ;  save it in si
           mov  al,[bx]            ; get current value (color)
           or   bp,ax              ; or bits 0 & 1 for win test
           push ax                 ; save color
           or   al,al
           jz   short notcc
           test al,0000_0100b
           mov  al,8
           jz   short notcc
           mov  si,bx
           mov  al,15
notcc:     ; al = color to use for border hexagon

; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; Draw hexagon
           ; ah = 0
           ; al = color to use for border hexagon
           ; si = ????
           ; bx = 03xxh
           ; dx = ????h
           ; es:di -> top left corner of rectangle to hold hexagon
           
           ; values to be sent to DrawHex #1
           ;  cx = 48, dx = 17, bx = 320, di = current, al = current
           mov  cl,(48+2) ;  32h     ; ch = 0
           mov  dx,(17+1) ;  12h     ; dh = ? from imul above
           mov  bx,320    ; 140h
           call DrawHex

           ; values to be sent to DrawHex #2
           ;  cx = 46, dx = 16, bx = 320, di += 1, al = 0
           xor  al,al              ; al = 0
           inc  di                 ;
           call DrawHex            ;
           pop  ax                 ; restore color

           and  al,0000_0011b      ; clear out the 'cursor' marker

           ; now draw a single filled hexagon with size
           ;  and color per AL
           push ax

           ; cx = 46   ; cx = pixels on longest line
           ; dx = 16   ; dx = lines per half including longest
           ; bx = 320  ;
           ; ah = 00   ;
           ;  values to be sent to DrawHex for al:
           ;      0:  doesn't matter as long as all positive numbers < before
           ;      1:  cx = 38, dx = 13, di += 3
           ;      2:  cx = 32, dx = 11, di += 6
           ;      3:  cx = 26, dx =  9, di += 9
           sub  dl,al
           sub  dl,al
           imul ax,3
           add  di,ax
           inc  di
           sub  cl,al
           sub  cl,al
           pop  ax

           ; ah = 0
           call DrawHex
; End a DrawHexagon
; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
end_disp:  pop  di
           pop  ax
           dec  ax
           jns  short dh_again
; End Draw Grid
; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

           ; ax = 0FFFFh
           ; bx = 0140h
           ; cx = 00xxh
           ; dx = 000xh
           ; si = 03xxh
           ; di = 1682h
           ; bp = A00xh

; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; start of 'CheckWin'              ; step 3
           and  bp,3               ; if bit 0 or 1 is set, we didn't win yet
           jz   short quit         ;

; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; get a key from the keyboard (stdin? rules don't say so)
           mov  ah,08h      ; (I could save one byte if 'int 16h' was allowed)
           int  21h

; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; start of 'CheckKeys'
           sub  al,'0'             ; make it zero based
           js   short quit         ; if ESC then exit

           mov  bl,low (quit+1)    ; point the array of movements (bh = 1)
           xlatb                   ;
           mov  bx,si              ; use bx as temp 'move to'
           test al,0000_0111b      ; if 8 or -8 then don't increment it
           jz   short noteven      ; ( test above clears the carry )
           bt   bx,02              ; are we on an even row (before move)
noteven:   adc  bl,al              ; move to next position

           ; need to check for border_crossings
           mov  ax,si              ;
           xor  al,bl              ;
           and  al,0000_0111b      ;
           cmp  al,3               ;
           je   short bad_move     ;  (bad move)

           cmp  [bx],dh            ; make sure not empty (dh = 0)
           jz   short bad_move     ;  (bad move)
           cmp  bl,31              ; checks to see if < 0 or > 31
           ja   short bad_move     ; (bad move)
           and  [si],bh            ; si -> previous move  (bh = 03h)
           add  [bx],bh            ; 'dec' the number and mark as cursor
           mov  si,bx              ; save new value
; end of 'CheckKeys'
; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; loop again
bad_move:  jmp  mainloop           ; ~27 less bytes for a short jump

; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;  return to mode 03h

;  The first number must be anything greater than 31 (signed) (B8h)
;  We want the next three numbers to be 3, 8, and 4
;  The next three can be anything greater than 31 (signed)
;  The last three must be -5, -8, -4
quit:      mov  eax,80040803h     ;  66h
                                  ;  B8h, 03h, 08h, 04h, 80h
           xor  ah,ah             ;  30h, E4h
           sti                    ;  FBh
           clc                    ;  F8h
           cld                    ;  FCh
           int  10h

; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;  and exit to DOS
;           ret
; we can let this fall throught the code below,
;  and let its RET return us to DOS.
; di still points to video memory, but we won't
;  see anything, because we have changed to
;  mode 03h


; draw a filled hexagon  (21 bytes)
;  al = color
;  ah = 00h
;  bx = 320
;  cx = pixels on longest line
;  dx = rows on each half
DrawHex    proc near
           dec  dx
           dec  cx
           dec  cx
drawhex1:  pusha
drawhex2:  pusha    ; save cx di
           rep
           stosb
           popa     ; restore cx di
           add  di,bx
           inc  di
           dec  cx
           dec  dx
           loopnz drawhex2  ; dec  cx
           popa
           neg  bx
           js   short drawhex1
           ret
DrawHex    endp

.end
