; Hugi Size Coding Competition #16 Entry: HexGrid Puzzle
; By:	o sparkz (wh1stler@ieg.com.br)	Brazil
;	o eks	 (instinc@users.sf.net)	Canada
;
; Size:	223 bytes	Date: 08-02-02 (dd-mm-yy)
;
; Build with:	nasm -fbin -oENTRY.COM hexen.asm -O3
; 		nasm version 0.98.16 or 0.98.19
;
; our first demo ever for both of us, so don't be shocked if we missed
; anything !
;

  org 0x100
  bits 16
  ;ax=0000 bx=0000 cx=00FF dx=xxxx si=0100 di=FFFE bp=09xx sp=FFFE
  
start:
  push word 0xA000			; es = video ram
  pop es				;
  mov al,0x13				; set video mode 13h (320x200x8bpp)
  int 0x10				;
mainloop:				;
  mov si,0x0081				; si = command line
  mov di,658				; di = starting screen offset 
  cwd					; dl = cell counter
  xor cx,cx				; cx = winning check counter
; mov bp,320
.filter:				;
  lodsb					; get one char
  sub al,'0'				; space char?
  js .filter				; yes, filter it
  cbw					; ah = 0 = selection color
  jz .draw				; empty cell, keep color 0
  mov ah,8				; set selection color to 8
  cmp al,4				; cell selected?
  jb .draw				; not selected, keep color 8
  mov ah,15				; set selection color to 15
  sub [si-1],byte 4			; unselect
  mov dh,dl				; record cursor location
.draw:					;
  and al,3				; unselect
  add cl,al				; win check count
  pusha					; backup
;  xchg al,ah				; set al to border color
  mov dx,0x1010				; set vert and horiz lenghts to 16
  call drawhex				; draw the selection hexbox
  add di,320				; get a little inset
;  add di,bp
;  dec dx				; a little smaller
;  xor al,al				; with color black
  cbw
  call drawhex				; draw this hexbox
;  aad 1					; movzx ax,ah
;  dec dx				; smaller
  mov bx,ax				; load color to base pointer
  add bx,bx				; it is a word table 
  sub dl,bl				; get the right size, vertical
  sub dh,bl				; get the right size, horizontal
  mov ah,al
  add di,[disptable+bx]			; apply displacement
  call drawhex				; draw this hexbox
  popa					; restore regs
  					;
  inc dx				; increment cell counter
  mov al,dl				; load to accumulator (1 byte smaller)
  add di,72				; next cell
  test al,3				; yet in this row?
  jnz .filter				; yes, draw another cell
  add di,18*320-4*72-36			; get to next row
  test al,4				; even row?
  jz $+5				; yes, do nothing
  add di,byte 72			; no, displace to the right
  cmp al,32				; drawed enough cells?
  jb .filter				; negative, draw some more
  					;
  jcxz quit				; win check

getkey:					;
	mov ah, 8			; get key from dos
	int 0x21			;
	sub al,'1'			; check for escape
	js quit				;
	mov cl, dh			; get cursor location
	mov bx, keyvals			; point to tables
	test al,1			;
	lahf				;
	xlatb				;
	test al,al			;
	jz getkey			;
	test cl, 4			; select odd/even table
	jz .even			;
	sahf				;
	jnz .even			;
	inc ax				;
.even:	aam 16				; unpack x,y
	; al = x displacement+2
	; ah = y displacement+2
	sub al, 2			; renormalize +/-
	sub ah, 2			;
	xchg ax, cx			;
	aam 4				; get original cursor coordinates
	add al, cl			; xpos += xdisp
	add ah, ch			; ypos += ydisp
	test ax,0xF8FC			; check if outside the grid
	jnz getkey
  
  	aad 4				; compute cursor from x,y
	xchg ax, bx			;
	cmp [bx + si - 32], byte '0'	; make sure cell count isn't 0
	jz getkey			;
	add [bx + si - 32], byte 3	; decrement cell count and move there
	jmp mainloop		;
;------------------------------------------------------------------------------

quit:
  mov ax,3
  int 0x10
  ret

keyvals:
%define KEYMOVE( y , x )  ((y+2)<<4) + ((x+2))
;               odd even

db KEYMOVE( 1,-1)  ; 1
db KEYMOVE( 2, 0)  ; 2
db KEYMOVE( 1, 0)  ; 3
db 0
db 0 
db 0
db KEYMOVE( -1,-1) ; 7
db KEYMOVE( -2, 0) ; 8
db KEYMOVE( -1, 0) ; 9

;------------------------------------------------------------------------------

drawhex:
; al = color
; dl = vertical size
; dh = horizontal size
; ch = 0
  pusha
  mov al,ah
  mov bx,-1				; bx is our direction
.pre:					;
  mov cl,dl  				; cx = vertical size
.inner:					;
  pusha					;
  mov cl,dh				; get run lenght
  rep stosb				; draw
  popa					;
  lea di,[di+bx+320]			; update scr pointer to next line
;  add di,bx
;  add di,bp
  sub dh,bl				; update horizontal size
  sub dh,bl				; a little more
  loop .inner				; next line
  inc dx				; middle line is bigger
  neg bx				; reverse direction
  jns .pre				; go
  popa
  dec dx
  ret

disptable:
  dw 0
  dw 320+(641)*1
  dw 320+(641)*2
  dw 320+(641)*3

;------------------------------------------------------------------------------
; Good Luck making it smaller than we could ;)
; (even though luck has nothing to do with it)
