
        section	.data

testcmdline     db      21h, 20h
testtableau     db      '0120'
                db       '3120'
                db      '0331'
                db       '0153'
                db      '0333'
                db       '3333'
                db      '0212'
                db       '1111', 0dh		; 35
		db	0				; 36
		dd	1, 2, 3, 4, 5, 6		; 60
		dd	16, 32, 23, 17, 645321	; 80
		dd	3210, 1, 65, 2123, 21	; 100
		dd	0, 0, 0, 0, 0, 0, 0		; 128

        section	.bss

cursorcell      resw	1
hexgrid         resb	32

	section	.text
	
InitGame:	
        mov     si, testtableau
        mov     bx, 0
.initgrid:
        lodsb
        cmp     al, '4'
        jb      .notstart
        mov     [cursorcell], bx        ; > 4 = cursor start position
.notstart:
        and     al, 03h
        mov     [bx+hexgrid], al
        inc     bx
        cmp     bx, byte 32
        jnz     .initgrid
	ret

;; Check for WIN condition ::
CheckWin:
        mov     bx, 0
win_loop:
        cmp     byte [bx+hexgrid], 0
        jnz     short win_no
        inc     bx
        cmp     bx, byte 32
        jnz     win_loop
win_no:
        ret

DoMove:
        mov     bx, [cursorcell]
        mov     cx, bx
        and     cx, 0003h               ; xpos = cell MOD 4
        mov     dx, bx
        shr     dx, 2                   ; ypos = cell DIV 4

        cmp     al, '8'
        jz      move_up
        cmp     al, '2'
        jz      move_down

        test    byte [cursorcell], 4
        jnz     odd_row_keys            ; is cursor on odd row ?

        cmp     al, '7'
        jz      even_up_left
        cmp     al, '9'
        jz      even_up_right
        cmp     al, '3'
        jz      even_down_right
        cmp     al, '1'
        jz      even_down_left
        ret

odd_row_keys:
        cmp     al, '7'
        jz      odd_up_left
        cmp     al, '9'
        jz      odd_up_right
        cmp     al, '3'
        jz      odd_down_right
        cmp     al, '1'
        jz      odd_down_left
        ret

good_move:
        mov     al, [bx+hexgrid]        ; 0 --> 1
        cmp     al, 0
        jz      bad_move
	inc	word [MovesCounter]
        dec     byte [bx+hexgrid]            ; cell[pos]-1
        mov     [cursorcell], bx
bad_move:
        ret

move_up:
        sub     bx, byte 8                   ; pos - 8
        jge     good_move
        ret

move_down:
        add     bx, byte 8                   ; pos + 8
        cmp     bx, byte 32
        jl      good_move
        ret

even_up_left:
        sub     bx, byte 5                   ; pos - 5
        cmp     cx, byte 1
        jl      bad_move                ; x < 1 ?
        cmp     dx, byte 1
        jl      bad_move                ; y < 1 ?
        jmp     short good_move

even_up_right:
        sub     bx, byte 4                   ; pos - 4
        cmp     dx, byte 1
        jl      bad_move                ; y < 1 ?
        jmp     short good_move

even_down_left:
        add     bx, byte 3                   ; pos + 3
        cmp     cx, byte 1
        jl      bad_move                ; x < 1 ?
        cmp     dx, byte 7
        jge     bad_move                ; y >= 7 ?
        jmp     short good_move

even_down_right:
        add     bx, byte 4                   ; pos + 4
        cmp     dx, byte 7
        jge     bad_move                ; y >= 7 ?
	jmp	short good_move
	
odd_up_left:
        sub     bx, byte 4                   ; pos - 4
        cmp     dx, byte 1
        jl      bad_move                ; y < 1 ?
        jmp     short good_move

odd_up_right:
        sub     bx, byte 3                   ; pos - 3
        cmp     cx, byte 3
        jge     bad_move                ; x >= 3 ?
        cmp     dx, byte 1
        jl      bad_move                ; y < 1 ?
        jmp     short good_move

odd_down_left:
        add     bx, byte 4                   ; pos + 4
        cmp     dx, byte 7
        jge     bad_move                ; y >= 7 ?
        jmp     good_move

odd_down_right:
        add     bx, byte 5                   ; pos + 5
        cmp     cx, byte 3
        jge     bad_move                ; x >= 3 ?
        cmp     dx, byte 7
        jge     bad_move                ; y >= 7 ?
        jmp     good_move

;----------------------------------------------------------------------------
; Draw the entire 4x8 hexagon grid with cursor
;----------------------------------------------------------------------------
DrawReference:
        mov     bp, 0                   ; cell = 0
@@again:
        call    DrawHexCell
        inc     bp
        cmp     bp, byte 32
        jnz     @@again
        ret

;----------------------------------------------------------------------------
; Draw a hex cell - deals with outer/inner hexagon + cursor
;----------------------------------------------------------------------------
DrawHexCell:
        ;; draw outer board/cursor ;;

        mov     al, 15                  ; colour(15)
        cmp     bp, [cursorcell]
        jz      short outer_cursor      ; draw cursor ?
        mov     al, [bp+hexgrid]
        cmp     al, 0                   ; if cell = empty then colour(0)
        jz      outer_cursor            ;
        mov     al, 8                   ; else colour(8) dgrey
outer_cursor:
        call    ScreenPixel
        add     di, 2+(2*320)           ; x+2,          y+2
        mov     dx, 16                  ; xoffs = 16
        mov     cx, 16                  ; xwide = 16
        call    DrawHexagon

        ;; draw inner gap colour(0) ;;

        call    ScreenPixel
        add     di, 3+(3*320)           ; x+3,          y+3
        mov     dx, 15                  ; xoffs = 15
        mov     cx, 16                  ; xwide = 16
        mov     al, 0                   ; colour(0)
        call    DrawHexagon

        ;; draw middle hexagon (if not empty) ;;

        mov     al, [bp+hexgrid]
        and     ax, 00FFh               ; n = HexGrid[pos]
        jz      empty_cell

        call    ScreenPixel
        add     di, 4+(4*320)           ; x+4, y+4
        push    ax
        mov     dx, 3+(2*320)
        mul     dx
        add     di, ax                  ; x + 3*n,      y+2n
        pop     ax

        mov     dx, 14
        sub     dx, ax
        sub     dx, ax                  ; xoffs = 14 - 2n
        mov     cx, 16
        sub     cx, ax
        sub     cx, ax                  ; xcnt = 16 - 2n
        call    DrawHexagon
empty_cell:
        ret

;----------------------------------------------------------------------------
; Draw hexagon screen[ES:DI]  color(AL)  xoffs(DX)  xwide(CX)
;----------------------------------------------------------------------------
DrawHexagon:
        mov     bx, dx                  ; xstart = xoffs
@@drawtop:
        push    cx
        push    di
        add     di, dx                  ; scr pixel + xoffs
        rep     stosb                   ; draw xwide pixels
        pop     di
        add     di, 320
        pop     cx
        add     cx, byte 2                   ; xwide + 2
        sub     dx, byte 1                   ; xoffs - 1
        jnz     short @@drawtop

@@drawbot:
        push    cx
        push    di
        add     di, dx
        rep     stosb
        pop     di
        add     di, 320
        pop     cx
        sub     cx, byte 2                   ; xwide + 2
        add     dx, byte 1                   ; xoffs + 1
        cmp     dx, bx                  ; until xoffs > xstart
        jle     short @@drawbot
        ret

;----------------------------------------------------------------------------
; (DI)=calculate screen pixel for hex grid position(BP)
;----------------------------------------------------------------------------
ScreenPixel:
        push    ax
        push    dx
        mov     ax, bp
        shr     ax, 2
        mov     dx, (320*18)
        mul     dx
        mov     di, ax                  ; scr pixel = (bp/4)*320*18

        test    bp, 4
        jz      short @@evenscr
        add     di, byte 36                  ; odd row then di + 36
@@evenscr:
        mov     ax, bp
        and     ax, byte 3
        mov     dx, (48+16+8)
        mul     dx
        add     di, ax                  ; scr pixel + (bp mod 4)*(48+16+8)
        pop     dx
        pop     ax
        ret
