;*** Test suite for Hugi compo #16
;
; compile:
;       nasm -fbin -ohex_dbug.com hex_dbug.asm
;
; Bonz:
;       - separated code for the reference implementation
;	- adapted to HC#16
;       - [F1] enters debug-mode
;
; Ruud:
;       - adapted to HC#10
;
; TAD:
;	- added all the '-D' debug mode switch
;	- keys:
;	       	[CURSOR]	- move by 1 pixel
;		[SHIFT+CURSOR]	- move by 8 pixels
;		[SPACE]		- run until next game-loop error
;		[ESC]		- disable debug-mode & run....
;		[N]		- locate next pixel error on screen
;		[TAB]		- toggle ENTRY <--> test screen
;		[F10]		- quit to DOS (a fake [QUIT] key press)
;
;	- you can also use the Mouse (if you have one #;o)
;
; TAD:
;     	- added MovesCounter
;	- current key
;	- key counter & file pos
;	- F1 help screen
;	- added [F10] quit function
;	- added screen description

QUIT_KEY        equ     1bh

; Prepare the environment for hexample.inc

%macro BEGINEMUL 0
	pusha
	push    ds
	push    es
	push    cs
	pop     ds
	mov     es,[wEmulSeg]
	mov	  [wSaveSS],ss
	mov	  [wSaveSP],sp

	cli
	mov     ss,[wCodeSeg]
	mov     sp,wEmulStack
	sti
	mov	byte [bHookKeyFlag], 0	; avoid reentering
%endm

%macro ENDEMUL 0
	mov	byte [cs:bHookKeyFlag], 1  ; not sure that CS=DS
	cli
	mov	  ss,[cs:wSaveSS]
	mov	  sp,[cs:wSaveSP]
	sti
	pop	es
	pop	ds
	popa
%endm

;; My control-codes ;;
XTAB	equ	1
YTAB	equ	2
LOCATE	equ	3
CARRET	equ	4
PEN	equ	5

        section	.text

        ORG     100h
Start:	mov     [wCodeSeg],cs
	mov     ax,wStack
        mov     sp,ax
        add     ax,1fh
        shr     ax,4
        mov     dx,cs
        add     dx,ax
        mov     word [wEmulSeg],dx
	add	dx, (64000/16)
	mov	word [wEntrySeg], dx
        add     ax,(64000/16)*2     ;;TAD:: Size of screen * 2 !!!
        mov     bx,ax
        mov     ah,4ah
        int     21h     ;Resize memory used
        mov     word [wCs1],ax
        mov     word [wCs2],ax
        mov     word [wCs3],ax
        mov     es,[wEmulSeg]
        xor     di,di
        xor     ax,ax
        mov     cx,64000/2
        rep stosw               ;Ref screen = 0

	;; detect mouse ;;

	mov	ax,3533h
	int	21h
	mov	ax, ES
	or	ax, bx
	or	al, ah
	mov	byte [bMouseFlag], al	; NZ = mouse INT 33h vector

        mov     ax,3521h
        int     21h
        mov     word [wOld21],bx
        mov     word [wOld21+2],es
        mov     dx,Int21Hook
        mov     ax,2521h
        int     21h

        mov     ax,3510h
        int     21h
        mov     word [wOld10],bx
        mov     word [wOld10+2],es
        mov     dx,Int10Hook
        mov     ax,2510h
        int     21h

        push    ds
        pop     es
        mov     si,82h-1
        mov     di,bFile
	call	SkipSpaces
	cmp	byte [si],'-'
	jnz	short .l00		; no '-' option ?
	inc	si
	lodsb
	and	al,0DFh
	cmp	al,'D'
	jnz	short .l03		; MUST be '-D' or '-d' !!
	inc	byte [bDebugMode]

.l03:	call	SkipSpaces
.l00:  cmp     byte [si],20h
        movsb
        jae     .l00
        mov     byte [di-1],0
        
        mov     di,bInput
.l01:  mov     dl,-1
        mov     ah,6
        int     21h
        stosb
        jnz     .l01
        dec     di
        sub     di,bInput
        mov     word [wInCount],di

	call    InitGame
	
	inc	byte [cs:bHookKeyFlag]			; start hooking
        mov     dx,bFile
        mov     bx,bEpb
	push	cs
	pop	es
        mov     ax,4b00h
        int     21h     ;Execute entry.com

        lds     dx,[cs:wOld21]
        mov     ax,2521h
        int     21h

        lds     dx,[cs:wOld10]
        mov     ax,2510h
        int     21h

        mov     ax,cs
        mov     ds,ax
        mov     es,ax

	mov	ax, 3			; restore text mode just in case
	int	10h

        mov     ax,[wErrCount]

        test    byte [bFlag],4		; restored text mode?
        mov     dx,msgNoText		; if not, error
        je      near .ShowErr
        mov     dx,msgPreExit
        test    byte [bFlag],3		; esc pressed or has won?
        jnz     near .Exit		; no error
.ShowErr:
	mov	ah, 9			; also sets errorlevel > 0 (AH=9)!
	int	21h
.Exit:	
        or      al,ah
        mov     ah,4ch
        int     21h


Old21:  popf
        db      0eah
wOld21  dw      0,0

Int21Hook:      pushf
	cld
	cmp	byte [cs:bHookKeyFlag], 0
	jz	short Old21

	cmp	ah, 8
	jne	short Old21

	BEGINEMUL
	call    DrawReference

        mov    ds, [cs:wVideoMem]
        xor     di,di
        xor     si,si
        mov     cx,64000/2
        repe cmpsw
        je      .Compares		; no drawing errors ?
	cmp	byte [cs:bDebugMode],0
	jz	.NoShow		; Debug mode off ?
	call	ShowDebug
.NoShow:
        inc     word [cs:wErrCount]  ;Error + 1
.Compares:
	ENDEMUL

.ReadKey:	
	mov	al, QUIT_KEY
	cmp	byte [cs:bQuitFlag], 0
	jnz	.NotEscapedYet

        dec     word [cs:wInCount]
        js     .Keyboard
        push    si
        mov     si,[cs:wInPoint]
        cs lodsb
        mov     word [cs:wInPoint],si
        pop     si
	jmp	short .HaveKey

.Keyboard:
	mov	ah, 8
        pushf
        call    far [cs:wOld21]
	
	cmp	al, 0
	jne	.HaveKey

        pushf					; Read scan code
        call    far [cs:wOld21]
	cmp	al, ';'				; F1?
	jne	.Keyboard

	mov	byte [cs:bDebugMode], 1
	call	ShowDebug
	
	jmp	short .ReadKey
	
.HaveKey:
        test    byte [cs:bFlag],1
        je      .NotEscapedYet
        inc     word [cs:wErrCount]
.NotEscapedYet:    
	cmp     al, QUIT_KEY
        jne     .NotEscKey
        or      byte [cs:bFlag],1
.NotEscKey:   
	BEGINEMUL
	call    CheckWin
	ENDEMUL
        jnz     .NoWin
        or      byte [cs:bFlag],2
        inc     word [cs:wErrCount]

.NoWin:
	BEGINEMUL
	mov	[CurrKeyCode], ax		; Keep current scan/key code
	inc	word [TotalKeyMoves]		; count every key (illegal & valid)
	call    DoMove        ;Update the reference data
	ENDEMUL
        popf
        iret

Int10Hook:      pushf
	cld

        cmp     ax,3
        je      .TextMode
	cmp	ax,2
	jne	Old10
.TextMode:
        or      byte [cs:bFlag],4
        test    byte [cs:bFlag],1
        jne     Old10   ;Escape pressed, OK
        inc     word [cs:wErrCount]
	BEGINEMUL
        call    CheckWin
	ENDEMUL
        jne     Old10   ;No winning field Error
	
        dec     word [cs:wErrCount]    ;Ok, exit allowed
        or      byte [cs:bFlag],2
Old10:  popf
        db      0eah
wOld10  dw      0,0


SkipSpc2:
	inc	si
SkipSpaces:
	cmp	byte [si],20h
	jbe	short SkipSpc2
	ret


;* Copy screen[SI:0000] to [DI:0000] *
CopyScreen:
	push	DS
	push	ES
	mov	DS, si
	xor	si, si
	mov	ES, di
	xor	di, di
	mov	cx,(64000/2)
	rep	movsw
	pop	ES
	pop	DS
	ret

;; The main debug-mode loop ;;
ShowDebug:
	push	DS
	push	ES

	push	CS
	pop	DS			; DS --> CS

	cmp	byte [bMouseFlag], 0
	jz	short .norat
	mov	ax, 000Fh
	mov	cx, 4
	mov	dx, 4
	int	33h			;set mickey-2-pixel ratio
.norat:

	mov	byte [bHookKeyFlag], 0		; disable INT 21h key hook

	mov	byte [bHelpRedraw],1

	mov	si, word [wVideoMem]
	mov	di, word [wEntrySeg]
	call	CopyScreen		; save video-mem screen

	mov	word [wErrorScr], 0
	call	FindNextError		; goto 1st error (if any)

	call	DrawBackground
.again:
	call	Vsync
	call	DrawWindow		; Draw zoom/help window
	mov	ax, word [wCursorMask]
	call	DrawCursor		; draw area cursor
	call	DebugMouse		; get mouse inputs
	mov	ah,01h
	int	16h
	jz	short .again		; no key press ?
	sub	ax,ax
	int	16h
	cmp	al,27
	jz	short .quit		; [ESC] turn off debug mode...
	cmp	al, 20h
	jz	short .next		; [SPACE] run until next error...
	cmp	ah, 044h
	jz	short .termin		; [F10] quit to dos ?
	push	ax
	mov	ah,02h
	int	16h
	mov	byte [bKeyStatus], al		; Key shift status
	pop	ax
	call	DebugKeys		; process key(AX)
	jmp	short .again
.termin:
	inc	byte [bQuitFlag]
.quit:
	mov	byte [bDebugMode], 0		; disable debug mode
.next:
	mov	si, word [wEntrySeg]
	mov	di, word [wVideoMem]
	call	CopyScreen		; restore video-mem

	pop	ES
	pop	DS
	mov	byte [cs:bHookKeyFlag], 1
	ret


;* Wait for V-SYNC *
Vsync:
	mov	dx, 3DAh
.1:
	in	al, dx
	test	al, 8
	jz	short .1
	ret

;* Process key(AX) *
DebugKeys:
	mov	bx, -1
	sub	dx, dx
	cmp	ah, 4Bh
	jz	short KeyRel		; [LEFT] ?

	neg	bx
	cmp	ah, 4Dh
	jz	short KeyRel		; [RIGHT] ?

	xchg	dx, bx
	cmp	ah, 50h
	jz	short KeyRel		; [DOWN] ?

	neg	dx
	cmp	ah, 48h
	jz	short KeyRel		; [UP] ?

	cmp	al, 9
	jz	short TogScr		; [TAB] ?

	and	al, 0DFh
	cmp	al, "N"
	jz	near FindNextError		; [N] ?

	cmp	ah, 03Bh
	jz	TogHelp			; [F1] ?


TogScr:
	xor	byte [bViewMode], 1
	call	DrawBackground
	ret

TogHelp:
	xor	byte [bHelpMode], 1
	call	DrawBackground
ShowF1Help:
	cmp	byte [bHelpMode],0
	jz	short .1
	inc	byte [bHelpRedraw]
.1:
	ret
	

;* Move relative dx(bx) dy(dx) scaled by [SHIFT] *
KeyRel:
	mov	cl, 3
	test	byte [bKeyStatus], cl
	jz	short MoveRel
	shl	bx, cl
	shl	dx, cl			; if SHIFT then dx*8, dy*8
MoveRel:
	add	bx, word [wZoomX]
	jns	short .1
	sub	bx, bx    	
.1:
	cmp	bx, 319
	jle	short .2
	mov	bx, 319
.2:
	add	dx, word [wZoomY]
	jns	short .3
	sub	dx, dx
.3:
	cmp	dx, 199
	jle	short .4
	mov	dx, 199
.4:

GotoXY:
	pusha
	mov	ax, 00FFh
	call	DrawCursor		; Erase cursor (restore line pixels)
	popa

	mov	word [wZoomX], bx
	mov	word [wZoomY], dx

	;; check that Zoom x,y isn't under zoom window ;;

	mov	ax, word [wZoomWinScr]
	xor	ax, 320-128
	jz	short .8
	cmp	bx, 142
	jbe	short .9
	jmp	short .6
.8:
	cmp	bx, 175
	jb	short .6
.9:
	mov	word [wZoomWinScr], ax		; move window to avoid cursor
	call	DrawBackground
.6:
	ret

;* Deal with the Mouse inputs *
DebugMouse:
	cmp	byte [bMouseFlag], 0
	jz	short .1

	mov	ax, 000Bh
	int	33h		; read mickey counters
	mov	bx, cx
	sar	bx, 1
	sar	dx, 1

	mov	ax, bx
	or	ax, dx
	jnz	short MoveRel	; has Mouse moved ?

.1:
	ret

;* Draw the background screen (Frame + HotSpot) *
DrawBackground:
	mov	byte [bHelpRedraw],1
	call	DrawFrame
	ret


;* Draw the window frame & clear window *
DrawFrame:
	mov	si, word [wEntrySeg]
	mov	ax, word [wEmulSeg]

	test	byte [bViewMode], 1
	jz	short .1		; viewing Entry screen ?
    	xchg	ax, si			; else view Emulated test screen
.1:
	mov	di, word [wVideoMem]
	call	CopyScreen

	;; now draw all the static border stuff... ;;

	push	ES
	mov	ES, word [wVideoMem]
	mov	di, word [wZoomWinScr]
	mov	ax, 0F0Fh
	mov	cx, (126/2)
	rep	stosw
	stosb
	add	di, 320-127
	mov	dx, 126+6
.2:
	mov	ax, 000Fh
	stosw
	sub	ax,ax
	mov	cx,124/2
	rep	stosw
	mov	byte [Es:di],0Fh
	add	di,320-126
	dec	dx
	jnz	short .2
	mov	ax, 0F0Fh
	mov	cx, (126/2)
	rep	stosw
	stosb
	pop	ES
	ret

;* Draw the Window Hotspot(0,0) cursor *
DrawHotSpot:
	push	ES
	mov	ES, word [wVideoMem]

	mov	ax,0F0Fh

	mov	di, word [wZoomWinScr]
	add	di, 61+(59*320)
	stosw
	stosw
	stosb
	add	di,320-5
	mov	cx,3
.3:
	mov	[Es:di], al
	mov	[Es:di+4], al
	add	di,320
	loop	.3
	stosw
	stosw
	stosb

	pop	ES

	mov	si,scr1txt
	test	byte [bViewMode], 1
	jz	short .1
	mov	si,scr2txt
.1:
	call	PrintMessage
	ret

;* Draw window stuff (zoom or help) *
DrawWindow:
	cmp	byte [bHelpMode],0
	jz	short DrawZoom
	shr	byte [bHelpRedraw],1
	jnc	short .1

	mov	di, helpnum1
	mov	ax, word [MovesCounter]
	call	outdec5

	mov	di, helpnum2
	mov	ax, word [TotalKeyMoves]
	call	outdec5

	mov	di, helpnum3
	mov	ax, CurrKeyCode
	call	outhex4

	mov	si, helptxt
	call	PrintMessage
.1:
	ret


;* Draw the zoom window & info bar status *
DrawZoom:
	call	DrawHotSpot

	mov	di, infotxt2
	mov	ax, word [wZoomX]
	call	outdec3

	mov	di, infotxt3
	mov	ax, word [wZoomY]
	call	outdec3

	mov	di, infotxt4
	mov	ax, 320
	mul	word [wZoomY]
	add	ax, word [wZoomX]
	call	outhex4

	push	DS
	push	ES
	mov	es, word [wEntrySeg]
	test	byte [bViewMode], 1
	jz	short .0		; viewing Entry screen ?
    	mov	es, word [wEmulSeg]	; else view Emulated test screen
.0:

	mov	bx, word [wZoomX]
	mov	bp, word [wZoomY]

	mov	ax, 320
	mul	bp
	add	ax, bx
	sub	ax, 15+(12*320)
	xchg	ax, si 

	mov	di, word [wZoomWinScr]
	add	di, 2+(320*12)
	mov	DS, word [wVideoMem]		; [DS:DI] --> screen pixel

	sub	bx, 15
	sub	bp, 12			; centre hotspot (x,y)

	mov	dh, 28
.1:
	mov	dl, 31
.2:
	mov	al, 0
	cmp	bp, 200	 		; this loop REALLY sux !!!
	jae	short .3
	cmp	bx, 320			; but I don't care... 
	jae	short .3
	mov	al, [Es:si]		; get clipped bitmap pixel
.3:
	mov	ah, al
	inc	si
	mov	[di], ax
	mov	[di+2], al
	mov	[di+320], ax
	mov	[di+322], al
	mov	[di+640], ax
	mov	[di+642], al		; simple 3x3 magnify

	add	di, 4
	inc	bx
	dec	dl
	jnz	short .2
	add	di, (4*320)-(4*31)
	add	si, (320-31)
	sub	bx, 31
	inc	bp
	dec	dh
	jnz	short .1

	pop	ES
	pop	DS

	;; display info bar ;;

	mov	si, infotxt
	call	PrintMessage	
	ret


;* Print message[DS:SI] in window *
PrintMessage:
	pusha
	push	ES
	mov	ES, word [wVideoMem]
	mov	bp, word [wTxtPen]
	jmp	pm_CALC

	;; decode & print 6x6 pixel char(AX) ;;
pm_PRINT:
	shl	bx, 3

	mov	ah,6
pm_CHRY:
	mov	al, [bx+dbugfont]
	inc	bx

	add	al, al
	sbb	cl, cl
	add	al, al
	sbb	ch, ch
	add	al, al
	sbb	dl, dl
	add	al, al
	sbb	dh, dh
	and	cx, bp
	and	dx, bp
	mov	[Es:di], cx
	mov	[Es:di+2], dx		; decode bits 7..4

	add	al, al
	sbb	cl, cl
	add	al, al
	sbb	ch, ch
	and	cx, bp
	mov	[Es:di+4], cx		; decode bits 3..2

	add	di, 320
	dec	ah
	jnz	short pm_CHRY
	add	di, 6-(6*320)
	inc	byte [wTxtX]
pm_NEXT:
	mov	bl, [si]
	inc	si
	and	bx, 00FFh
	cmp	bl, PEN
	ja	short pm_PRINT		; not a control-code ?
	add	bx, bx
	jmp	[cs:bx+pm_JUMPS]

pm_JUMPS	dw	pm_QUIT
		dw	pm_XTAB
		dw	pm_YTAB
		dw	pm_LOCATE
		dw	pm_CARRET
		dw	pm_PEN


pm_CARRET:
	mov	byte [wTxtX], 0
	inc	byte [wTxtY]
	jmp	SHORT pm_CALC

pm_XTAB:
	lodsb
	mov	byte [wTxtX], al
	jmp	short pm_CALC

pm_LOCATE:
	lodsb
	mov	byte [wTxtX], al
pm_YTAB:
	lodsb
	mov	byte [wTxtY], al

	;; calc pixel addr from text (x*6,y*6) ;;
pm_CALC:
	mov	di, [wTxtY]
	mov	ax, [wTxtX]
	imul	di, di, (6*320)
	imul	ax, ax, 6
	add	ax, 2+2+(320*5)
	add	ax, word [wZoomWinScr]
	add	di, ax			; [ES:DI] --> scr pixel
	jmp	short pm_NEXT

pm_PEN:
	lodsb
	mov	ah,al
	xchg	ax, bp
	jmp	short pm_NEXT

pm_QUIT:
	mov	word [wTxtPen], bp
	pop	ES
	popa
	ret



;* Find the next pixel error *
FindNextError:
	push	DS
	push	ES

	mov	di, word [wErrorScr]		; begin from last position
	mov	ES, word [wEntrySeg]
	mov	DS, word [wEmulSeg]

	mov	cx, 64000
	sub	cx, di
	jc	short .4
	mov	si, di
	repz	cmpsb
	jnz	short .2		; found error ?
.4:
	sub	si, si
	sub	di, di
	mov	cx, 64000
	repz	cmpsb			; restart from 0,0
.2:
	pop	ES
	pop	DS
	jz	short .3		; no error ?

	mov	word [wErrorScr], di

	;; calc x,y from pixel error address ;;

	xchg	ax, di
	dec	ax
	sub	dx, dx
	mov	si, 320
	div	si
	mov	bx, dx
	xchg	ax, dx
	jmp	GotoXY			; Move zoom window over pixel
.3:
	ret

;* Output(AX) into[DS:DI] as hex 4- digit *
outhex4:
	xchg	ax, dx
	mov	cx, 4
.1:
	rol	dx, 4
	mov	ax, 300Fh
	and	al, dl
	aaa
	aad	11h
	mov	[di], al
	inc	di
	loop	.1
	ret


outdec5:
	mov	bx, 1000
	sub	dx,dx
	div	bx
	call	outdec2
	xchg	ax,dx

;* Output(AX) into[DS:DI] as decimal 3-digit *
outdec3:
	mov	bx, 100
	sub	dx, dx
	div	bx
	or	al, '0'
	mov	[di], al
	inc	di
	xchg	ax, dx
outdec2:
	aam
	or	ax, '00'
	mov	[di], ah
	inc	di
	mov	[di], al
	inc	di
	ret

;* Draw the zoom area cursor on the background *
DrawCursor:
	xchg	ax, dx
	push	DS
	push	ES
	mov	bx, word [wZoomX]
	mov	di, word [wZoomY]

	mov	ES, word [wVideoMem]		; [ES:0000] --> vid mem

	test	byte [bViewMode], 1
	mov	ax, word [wEntrySeg]
	jz	short .1
    	mov	ax, word [wEmulSeg]
.1:
	mov	DS, ax			; [DS:0000] --> entry/test bitmap

	sub	bx, 16
	sub	di, 13
	lea	cx, [bx+32]
	call	HorzCursor

	lea	cx, [di+29]
	call	VertCursor

	push	bx
	lea	bx, [bx+32]
	call	VertCursor
	pop	bx

	add	di,29
	lea	cx, [bx+32]
	call	HorzCursor

	pop	ES
	pop	DS
	ret

;* Draw horz line(BX,DI) - (CX,DI) mask(DX) *
HorzCursor:
	pusha
	cmp	di,200
	jae	short .1
	test	bx, bx
	jns	short .2
    	sub	bx, bx
.2:
	cmp	cx, 319
	jle	short .3
    	mov	cx, 319
.3:
	sub	cx, bx
	jc	short .1
	inc	cx

	imul	di, di,320
	add	di, bx
.4:
	mov	al, [di]
	and	al, dl
	or	al, dh
	stosb
	loop	.4
.1:
	popa
	ret

;* Draw vert line(BX,DI) - (BX,CX) mask(DX) *
VertCursor:
	pusha
	cmp	bx, 320
	jae	short .1
	test	di, di
	jns	short .2
	sub	di, di
.2:
	cmp	cx, 199
	jle	short .3
	mov	cx, 199
.3:
	sub	cx, di
	jc	short .1
	inc	cx

	imul	di, di, 320
	add	di, bx
.4:
	mov	al, [di]
	and	al, dl
	or	al, dh
	stosb
	add	di, 320-1
	loop	.4
.1:
	popa
	ret


%include "hexample.inc"

        section	.data

bEpb    dw      0
        dw      testcmdline
wCs1    dw      00000
        dw      5ch
wCs2    dw      00000
        dw      6ch
wCs3    dw      00000
        dw      $-bEpb
wInPoint        dw      bInput
wErrCount       dw      0
bFlag   db      0		; bit 0 = ESC pressed, bit 1 = has won, 
				; bit 2 = restored text mode

msgNoText  db 'Text screen not restored on exit',0dh,0ah,'$'
msgPreExit db 'Program exit before winning field or escape',0dh,0ah,'$'
msgErrEnc  db ' error(s) encountered.',0dh,0ah,'$'

;*** TAD's DATA

infotxt		db	PEN,15, LOCATE,0,20,'X:',PEN,14
infotxt2	db	'000  ',PEN,15,'Y:',PEN,14
infotxt3	db	'000   ',PEN,11
infotxt4	db	'0000h',0

scr1txt		db	PEN,12,LOCATE,2,0,'ENTRY.COM Screen',0
scr2txt		db	PEN,14,LOCATE,2,0,'Reference Screen',0

helptxt		db	PEN,14, LOCATE,3,0,'F1 - tog. Help'
		db	PEN,10,LOCATE,4,2,'N - ',PEN,7,'next error'
		db	PEN,10,LOCATE,2,3,'TAB - ',PEN,7,'tog. screens'
		db	PEN,10,LOCATE,0,4,'SHIFT - ',PEN,7,'fast move'
		db	PEN,10,LOCATE,0,5,'SPACE - ',PEN,7,'1 game cycle'
		db	PEN,10,LOCATE,2,6,'ESC - ',PEN,7,'run/no debug'
		db	PEN,10,LOCATE,2,7,'F10 - ',PEN,7,'quit to DOS'

		db	PEN,14,LOCATE,7,9,'Colors'
		db	PEN,7,LOCATE,2,11,'0123456789ABCDEF'
		db	LOCATE,2,12
		db	PEN,0,219 ,PEN,1,219, PEN,2,219, PEN,3,219
		db	PEN,4,219, PEN,5,219, PEN,6,219, PEN,7,219
		db	PEN,8,219 ,PEN,9,219, PEN,10,219, PEN,11,219
		db	PEN,12,219, PEN,13,219, PEN,14,219, PEN,15,219

		db	PEN,14,LOCATE,5,14,'Puzzle Info'
		db	PEN,7,LOCATE,1,16,'Valid moves: ',PEN,10
helpnum1	db	'00000'
		db	PEN,7,LOCATE,1,17,'Total moves: ',PEN,10
helpnum2	db	'00000'
		db	PEN,7,LOCATE,4,19,'Last-key: ',PEN,15
helpnum3	db	'0000h'

		db	0


wVideoMem	dw	0A000h
wEntrySeg	dw	0

wZoomX		dw	160
wZoomY		dw	100

wZoomWinScr	dw	0
wErrorScr	dw	0
wCursorMask	dw	0F00h

bDebugMode	db	0		; NZ = debug/zoom stuff
bViewMode	db	0		; 0=view entry, 1=view emul. ref

bHookKeyFlag	db	0		; NZ = hook INT 21h key vector
bKeyStatus	db	0		; key status (Shift, Alt, Ctrl etc..)
bMouseFlag	db	0
bHelpMode	db	0		; NZ = F1 help mode
bHelpRedraw	db	0
bQuitFlag	db	0

MovesCounter    dw      0
TotalKeyMoves    dw      0
CurrKeyCode	dw	0

wTxtX		dw	0
wTxtY		dw	0
wTxtPen		dw	0F0Fh

;; A dodgy looking 6x6 pixel font (8 bytes per char) ;;

dbugfont:

;* File: "D:\FED\SYS6X6.MSK"
;*
	DW	00000h,00000h,00000h,00000h,07020h,020D8h,02020h,00000h
	DW	02020h,0D820h,02070h,00000h,01810h,018ECh,00010h,00000h
	DW	06020h,060DCh,00020h,00000h,0A870h,0A8D8h,00070h,00000h
	DW	0F0F8h,0C8E0h,00098h,00000h,0A8D8h,0A870h,000D8h,00000h
	DW	0180Ch,0E0B0h,00040h,00000h,08478h,0B4A4h,07884h,00000h
	DW	07830h,0FC78h,03000h,00000h,01810h,07010h,060F0h,00000h
	DW	080E0h,090DCh,01018h,00000h,080E0h,0E8B8h,02C38h,00000h
	DW	01414h,03414h,06474h,00000h,04040h,06040h,03070h,00000h
	DW	0C8F8h,0D8C8h,0F8D8h,00000h,02060h,07020h,07070h,00000h
	DW	00878h,0C0F8h,0F8C0h,00000h,010F0h,018F8h,0F818h,00000h
	DW	0C0C0h,0D8C0h,018F8h,00000h,080F0h,018F8h,0F818h,00000h
	DW	0C0C0h,098F8h,0F8D8h,00000h,008F8h,03038h,03030h,00000h
	DW	05070h,0D870h,0F8D8h,00000h,0D8F8h,0F8C8h,01818h,00000h
	DW	07000h,0F808h,00070h,00000h,080E0h,090DCh,01CF0h,00000h
	DW	03C1Ch,04060h,05870h,00000h,0D0E0h,00818h,02878h,00000h
	DW	02C44h,01428h,0C0ECh,00000h,0D008h,0A050h,000C0h,00000h
	DW	00000h,00000h,00000h,00000h,03030h,03030h,03000h,00000h
	DW	0D8D8h,00090h,00000h,00000h,0F850h,0F850h,00050h,00000h
	DW	0A078h,02870h,020F0h,00000h,0D0C8h,05820h,00098h,00000h
	DW	0D060h,0E860h,068D0h,00000h,03030h,00060h,00000h,00000h
	DW	06030h,06060h,00030h,00000h,03060h,03030h,00060h,00000h
	DW	03048h,03078h,00048h,00000h,02020h,020F8h,00020h,00000h
	DW	00000h,03000h,06030h,00000h,00000h,00078h,00000h,00000h
	DW	00000h,03000h,00030h,00000h,03018h,0C060h,00080h,00000h
	DW	09870h,0C8A8h,00070h,00000h,03010h,01010h,00010h,00000h
	DW	008F0h,08070h,000F8h,00000h,008F0h,00870h,000F0h,00000h
	DW	05030h,0F890h,00010h,00000h,080F0h,008F0h,000F0h,00000h
	DW	08070h,088F0h,00070h,00000h,008F8h,02010h,00020h,00000h
	DW	08870h,08870h,00070h,00000h,08870h,00878h,00070h,00000h
	DW	03030h,03000h,00030h,00000h,03030h,03000h,02010h,00000h
	DW	03018h,03060h,00018h,00000h,07800h,07800h,00000h,00000h
	DW	03060h,03018h,00060h,00000h,09870h,03030h,03000h,00000h
	DW	08870h,0B0B8h,07880h,00000h,08870h,088F8h,00088h,00000h
	DW	088F0h,088F0h,000F0h,00000h,08078h,08080h,00078h,00000h
	DW	088F0h,08888h,000F0h,00000h,080F8h,080F0h,000F8h,00000h
	DW	080F8h,080F0h,00080h,00000h,08078h,08898h,00078h,00000h
	DW	08888h,088F8h,00088h,00000h,02070h,02020h,00070h,00000h
	DW	00808h,08808h,00070h,00000h,05048h,05060h,00048h,00000h
	DW	04040h,04040h,00078h,00000h,0D888h,088A8h,00088h,00000h
	DW	0C888h,098A8h,00088h,00000h,08870h,08888h,00070h,00000h
	DW	088F0h,080F0h,00080h,00000h,08870h,08888h,01870h,00000h
	DW	088F0h,0A0F0h,00098h,00000h,08078h,00870h,000F0h,00000h
	DW	020F8h,02020h,00020h,00000h,08888h,08888h,00078h,00000h
	DW	08888h,05088h,00020h,00000h,08888h,0D8A8h,00088h,00000h
	DW	05088h,05020h,00088h,00000h,08888h,02050h,00020h,00000h
	DW	010F8h,04020h,000F8h,00000h,06078h,06060h,00078h,00000h
	DW	060C0h,01830h,00008h,00000h,01878h,01818h,00078h,00000h
	DW	07020h,000D8h,00000h,00000h,00000h,00000h,0F800h,00000h
	DW	06060h,00030h,00000h,00000h,07000h,0F808h,00078h,00000h
	DW	0F080h,08888h,000F0h,00000h,07000h,08080h,00070h,00000h
	DW	07808h,08888h,00078h,00000h,07000h,080F8h,00070h,00000h
	DW	02018h,02078h,00020h,00000h,07800h,07888h,0F008h,00000h
	DW	0B080h,088C8h,00088h,00000h,06000h,02020h,00070h,00000h
	DW	01010h,01010h,0E010h,00000h,09080h,090E0h,00088h,00000h
	DW	02060h,02020h,00070h,00000h,05000h,0A8F8h,00088h,00000h
	DW	0F000h,08888h,00088h,00000h,07000h,08888h,00070h,00000h
	DW	0F000h,08888h,080F0h,00000h,07800h,08888h,00878h,00000h
	DW	07000h,04048h,00040h,00000h,03800h,01860h,00070h,00000h
	DW	07020h,02020h,00010h,00000h,08800h,08888h,00078h,00000h
	DW	08800h,05088h,00020h,00000h,08800h,0A8A8h,000D8h,00000h
	DW	04800h,03030h,00048h,00000h,08800h,07888h,0F008h,00000h
	DW	07800h,02010h,00078h,00000h,03038h,03060h,00038h,00000h
	DW	03030h,03030h,03030h,00000h,03070h,03018h,00070h,00000h
	DW	0E840h,010B8h,00000h,00000h,02000h,0C870h,000F8h,00000h
	DW	08078h,08080h,0C078h,00000h,00050h,08888h,07888h,00000h
	DW	02010h,0F870h,07080h,00000h,05020h,00870h,078F8h,00000h
	DW	00050h,00870h,078F8h,00000h,02040h,00870h,078F8h,00000h
	DW	00020h,00870h,078F8h,00000h,07800h,08080h,0E078h,00000h
	DW	05020h,0F870h,07080h,00000h,00050h,0F870h,07080h,00000h
	DW	02040h,0F870h,07080h,00000h,00050h,02060h,07020h,00000h
	DW	05020h,02020h,07020h,00000h,02040h,02060h,07020h,00000h
	DW	00050h,08870h,088F8h,00000h,00020h,08870h,088F8h,00000h
	DW	0F820h,0F080h,0F880h,00000h,0F000h,0E038h,00078h,00000h
	DW	0A078h,0A0F8h,000B8h,00000h,05020h,08870h,07088h,00000h
	DW	00050h,08870h,07088h,00000h,02040h,08870h,07088h,00000h
	DW	05020h,08888h,07888h,00000h,02040h,08888h,07888h,00000h
	DW	00050h,07888h,0F008h,00000h,00050h,08870h,07088h,00000h
	DW	00050h,08888h,07888h,00000h,03810h,03860h,00010h,00000h
	DW	02018h,02070h,00078h,00000h,0D888h,02070h,02070h,00000h
	DW	0D8F0h,0D8F0h,0C0F0h,00000h,02018h,02078h,0C020h,00000h
	DW	02010h,00870h,078F8h,00000h,02010h,02060h,07020h,00000h
	DW	02010h,08870h,07088h,00000h,02010h,08888h,07888h,00000h
	DW	000F0h,088F0h,08888h,00000h,00078h,06848h,04858h,00000h
	DW	00870h,078F8h,0F800h,00000h,08870h,07088h,0F800h,00000h
	DW	00060h,06060h,070C8h,00000h,00000h,04078h,00040h,00000h
	DW	00000h,00878h,00008h,00000h,0C0C0h,02CD8h,03C18h,00000h
	DW	0C0C0h,014CCh,0043Ch,00000h,00030h,03030h,03030h,00000h
	DW	06C34h,06CD8h,00034h,00000h,0D8B0h,0D86Ch,000B0h,00000h
	DW	0B068h,00870h,078F8h,00000h,0B068h,08870h,07088h,00000h
	DW	04834h,06858h,0B048h,00000h,03008h,06858h,04030h,00000h
	DW	07000h,0A0B8h,00078h,00000h,0B078h,0B0B8h,00078h,00000h
	DW	02040h,08870h,088F8h,00000h,0B068h,08870h,088F8h,00000h
	DW	0B068h,08870h,07088h,00000h,00050h,00000h,00000h,00000h
	DW	02010h,00000h,00000h,00000h,07020h,02020h,00020h,00000h
	DW	0E868h,068E8h,02828h,00000h,0CC78h,0BCB4h,078C4h,00000h
	DW	08C78h,08CB4h,078A4h,00000h,05CF4h,00054h,00000h,00000h
	DW	00048h,04848h,01048h,00000h,048E8h,0E848h,03008h,00000h
	DW	0D898h,0D870h,000C8h,00000h,030F0h,03030h,000F8h,00000h
	DW	00878h,03818h,00068h,00000h,018FCh,01818h,00018h,00000h
	DW	018F0h,0D8D8h,000D8h,00000h,03070h,03030h,00030h,00000h
	DW	03078h,01818h,00018h,00000h,06CFCh,06C6Ch,0006Ch,00000h
	DW	0D8C0h,0D8D8h,000F8h,00000h,01878h,00018h,00000h,00000h
	DW	018F0h,01818h,000F0h,00000h,0F8C0h,01818h,00078h,00000h
	DW	07CD8h,06464h,0006Ch,00000h,01838h,01818h,00078h,00000h
	DW	0D8F8h,0D8D8h,00070h,00000h,06C6Ch,06C6Ch,000FCh,00000h
	DW	098F8h,018D8h,000F8h,00000h,0D8D8h,03870h,000F8h,00000h
	DW	018F8h,0D0D8h,0C0C0h,00000h,01870h,01818h,00018h,00000h
	DW	0D4D4h,0C4F4h,000FCh,00000h,05878h,05858h,000D8h,00000h
	DW	01838h,01818h,00018h,00000h,018F8h,01818h,00018h,00000h
	DW	0FC00h,06C6Ch,0007Ch,00000h,0F8F8h,0F8F8h,0F8F8h,00000h
	DW	0D8D8h,03070h,00030h,00000h,02830h,07070h,060A0h,00000h
	DW	02000h,0D870h,00088h,00000h,05800h,0B4B4h,00068h,00000h
	DW	06800h,0D0D0h,00068h,00000h,0D870h,0D8F0h,0C0F0h,00000h
	DW	06CFCh,06064h,06060h,00000h,0F800h,05050h,00050h,00000h
	DW	060F8h,06030h,0F8C0h,00000h,07038h,0D8D8h,00070h,00000h
	DW	06800h,06868h,0C07Ch,00000h,0F800h,03030h,02030h,00000h
	DW	07070h,0A8A8h,07070h,00000h,0D870h,0D8F8h,00070h,00000h
	DW	0D870h,050D8h,000D8h,00000h,06830h,0D870h,070D8h,00000h
	DW	02018h,0A870h,0C070h,00000h,07020h,0A8A8h,02070h,00000h
	DW	04038h,04078h,00038h,00000h,04830h,04848h,00048h,00000h
	DW	00078h,00078h,00078h,00000h,0F820h,00020h,000F8h,00000h
	DW	01860h,00060h,00078h,00000h,06018h,00018h,00078h,00000h
	DW	0100Ch,03030h,03030h,00000h,03030h,03030h,0C020h,00000h
	DW	00020h,000F8h,00020h,00000h,0B068h,06800h,000B0h,00000h
	DW	04830h,00030h,00000h,00000h,07830h,00030h,00000h,00000h
	DW	00000h,03030h,00000h,00000h,01C00h,0D010h,02070h,00000h
	DW	06870h,06868h,00000h,00000h,01870h,07830h,00000h,00000h
	DW	03070h,07010h,00000h,00000h,000F8h,00000h,00000h,00000h

        section	.bss

bFile		resb 20h
wCodeSeg   resw 1
wEmulSeg   resw 1
wInCount    resw 1
wSaveSS	resw 1
wSaveSP	resw 1
bInput  	resb 200h
        	resw 200h
wEmulStack  	resw 200h
wStack	resw 1
