; Bonz's little date-printing program
; -----------------------------------------------------------------------------
; Jan 4th -- 256 bytes: this was what I was aiming at and I stopped optimizing
;                       once I achieved it.
; Jan 31th - 236 bytes: after looking at INT-E's program I replaced an
;                       XCHG/STOSB/XCHG/STOSB sequence by MOV/INC/STOSB,
;                       and also stole the trick of flagging bytes instead of 
;                       encoding the length of each string before the string
; -----------------------------------------------------------------------------

	org 100h

	mov bp, print_2			; commonly used subroutine

	mov ah, 2ah			; read system date
	int 21h

	push cx				; save year as base of workspace
	push cx				; save year to print it

	cbw				; AH = 0
	xchg cx, ax			; weekday in CX, year in AX
	xchg di, ax			; DI = year, points to workspace 
	mov si, weekdays		; point to table
	call print_nth			; print weekday

	mov si, months-4		; point to fixed string 'day '
	movsw				; copy it
	movsw				; now SI points to months table
	mov cl, dh			; month in CX
	dec cx				; need 0=January
	call print_nth			; print month

	mov si, fixed			; point to fixed strings
	xchg ax, dx			; print day
	call bp
	mov [byte bp+fmt-print_2], bl	; set two-digit output format

	mov bx, stndrdth		; print st/nd/rd/th
	or ah, ah			; if 11th to 19th
	jz go				; all use `th'
	sub al, '4'			; else if units are 4-9
	jns go				; also use 'th'
	sub bl, al			; if 3, AL = -1 -> add 2
	sub bl, al			; if 2, AL = -2 -> add 4
go:					; if 1, AL = -3 -> add 6
	mov ax, [bx]			; copy two bytes from BX
	stosw
	
	pop ax				; pop year
	sub al, 2000 & 255
	movsw				; copy ' 2'
	call bp				; copy '0' and print it
	movsb				; copy ','

	mov ah, 2ch			; get time
	int 21h

	mov al,ch			; print hour
	call bp
	xchg ax,cx			; print minute (CL)
	call bp
	mov al,dh			; print second
	call bp

	movsw				; put CR/LF
	pop dx				; pop workspace
	mov cl, 9			; print function for CP/M entry point
	push byte 5			; copy '$' and two bogus characters,
					; print date and exit

	; AL = number
	; on output AH = tenths - 1, AL = units + 30h if one-digit format
	; while AH = tenths + 30h, AL = units + 30h if two-digit format
	
print_2:
	movsb				; Copy one from fixed
	aam				; Split into two digits
	add ax,3030h			; Make 'em ASCII
	mov [di], ah			; Print the high one
	sub ah, '1'			; If it is a zero (and 31h still here)
fmt: equ $-1
	jb nostore			; then don't print
	inc di
nostore:
	stosb				; always store low one
	ret

print_nth:
	lodsb
	aam 80h				; Put bit 7 into AH's bit 0
	stosb				; Write 7-bit character
	jcxz no_back
	dec di
no_back:
	sahf				; Set carry if end of string
	sbb cl, ch			; CH = 0
	jns print_nth
	ret

fixed:					; Fixed parts of the output
	db ' '				; After month
	db ' 20'			; After day
	db ','				; After year
	db ' ::'			; After hour, minute, second
	db 13,10,'$'			; At end

	db 'day '			; After weekday
months:
	db 'Januar', 128 + 'y'
	db 'Februar', 128 + 'y'
	db 'Marc', 128 + 'h'
	db 'Apri', 128 + 'l'
	db 'Jun', 128 + 'e'
	db 'Jul', 128 + 'y'
	db 'Augus', 128 + 't'
	db 'Septembe', 128 + 'r'
	db 'Octobe', 128 + 'r'
	db 'Novembe', 128 + 'r'
	db 'Decembe', 128 + 'r'

weekdays:
	db 'Su', 128 + 'n'
	db 'Mo', 128 + 'n'
	db 'Tue', 128 + 's'
	db 'Wedne', 128 + 's'
	db 'Thur', 128 + 's'
	db 'Fr', 128 + 'i'
	db 'Satu', 128 + 'r'

stndrdth:
	db 'thrdndst'
