
/***********************************************************************\
*  Idea for HC17:                                                       *
*   Some simple rules:                                                  *
*    100 < Input file size < 60000                                      *
*    ( this will allow code, stack, snake, and 60000 all in CS )        *
*    delay will be a set algo so all machines 'delay' the same          *
*    etc., etc.                                                         *
*                                                                       *
*  The below code was compiled with QC25 (TINY) and could easily        *
*   be optimized (in C no doubt), but I throw it together in a hurry.   *
*                                                                       *
*  Just an idea for HC17.  Any other suggestions?                       *
*                                                                       *
*  RUN:                                                                 *
*   snake snake.bin                                                     *
*                                                                       *
*  USE:                                                                 *
*   q = quit                                                            *
*   + = faster                                                          *
*   - = slower                                                          *
*                                                                       *
*  I am sure a few other 'ideas' would make this a little harder        *
*    task for HC17.                                                     *
*                                                                       *
\***********************************************************************/

#include <conio.h>
#include <stdio.h>
#include <stdlib.h>

void delay(unsigned long wait);

/* buffer set to larger than we will read */
unsigned char buffer[512];

/* our tail is 256 'links' each */
unsigned char _far *tail[256];

/* adjust this to suit your machine */
unsigned long wait = 0x00008000L;
/* on a PI 233Mhz, this runs quite nice */
/* the faster the machine, the larger the number */

FILE *fp;

int main(int argc, char *argv[]) {
	 int i, j, size;
	 char ch;

	 /* initalize tail */
	 /* all point to starting position */
	 for (i=0; i<256; i++)
		 tail[i] = (unsigned char _far *) 0xA0005E10;

	 /* open file, read in max 512 bytes (s.bin is 400+5(CRLF's)) */
	 /* notice no error checking.... */
	 fp = fopen(argv[1], "rb");
	 size = fread(&buffer, 1, 512, fp);
	 fclose(fp);

	 /* set screen mode */
	 _asm {
		 mov  ax,0013h
		 int  10h
	 }

	 /* make palette grey scale */
	 /* hint:  HC15 :) */
	 outp(0x3C8, 0x0);
	 for (i=0; i<64; i++)
		 for (j=0; j<12; j++)
			 outp(0x3C9, i);

	 /* do the looping */
	 j = 0;
	 ch = '\0';
	 while(ch != 'q') {
		 while(!kbhit()) {
			 for(i=0; i<255; i++)
				 tail[i] = tail[i+1];
			 switch (buffer[j]) {
				 case '2':
					 tail[255] += 320;
					 break;
				 case '4':
					 (tail[255])--;
					 break;
				 case '6':
					 (tail[255])++;
					 break;
				 case '8':
					 tail[255] -= 320;
					 break;
				 default:
					 break;  /* do nothing */
			 }
			 if(++j > size) j = 0;
			 for(i=0; i<255; i++)
				 *tail[i] = i;
			 delay(wait);  /* pause  */
		 }

		 switch (ch = getch()) {
			 case '+':
				 if(wait > 0x1000) wait -= 0x1000;
				 break;
			 case '-':
				 wait += 0x1000;
				 break;
		 }
	 }

	 _asm {
		 mov  ax,0003h
		 int  10h
	 }

	 return 0;
}

/* Pauses for a specified number of milliseconds. */
void delay(unsigned long wait) {
	unsigned long l = 0;
	while (l < wait) { l++; };

	/* if you have a really fast machine, change this delay
		 to something else.  This is simply a temp delay.  The
		 rules will have a fixed delay independant of the
		 processor speed */

}
