; -==============================-
; Hugi Size Coding Competition #17
;
; Task   : A small DUMP utility
; Author : Ang Chin Keong
; Country: Malaysia
; Contact: chinkeong81@yahoo.com
; Date   : Mar/Apr 2002
; Compile: tasm entry; tlink entry /t
; Size   : 124 bytes
;
; -===[ http://hugi.de/compo ]===-

.MODEL TINY
.286
.CODE
.STARTUP

Start:
            PUSH 0FFF0H                 ; Set Counter = -16
            SHR  SI,1                   ; Assume SI=0100h, SI=080h

            LODSB                       ; Read parameter length
            XCHG BX,AX                  ; Thanks Boiled Brain for the bugs fix at this line
            MOV [BX+SI],BH              ; Put 0 at the end of parameter
SkipSpace:
            MOV DX,SI                   ; assume SI already point to filename
            LODSB                       ; read a byte, inc SI for next byte
            CMP AL,20H                  ; is it a space ?
            JBE SkipSpace               ; if yes, next byte

            MOV  AX,3D00H               ; Open file
            INT  21H                    
            XCHG AX,BX                  ; Save file handler
Main:

            MOV  DI,OFFSET STRING       ; Set pointer to string
            PUSH DI                     ; Save pointer
            MOV  AX,03F20H              ; 3Fh = Read file, 20h = Space
            MOV  CL,57
            REP                         ; Fill String with space
            STOSB
            MOV  DX,DI                  ; DX Point to Buffer
            MOV  SI,DI                  ; SI Point to Buffer
            POP  DI                     ; Get back pointer to String

            MOV  CL,16                  ; Read 16 bytes max
            INT  21H                    ; Call Read File
            OR   AX,AX                  ; Success ?
            XCHG BP,AX                  ; Save total byte read in bp
            POP  AX                     ; Get Counter
            JZ   Done                   ; EOF

            ADD  AX,CX                  ; Increase Counter by 16
            PUSH AX                     ; Save Counter
            PUSH DI                     ; Save pointer for PrintLine
                        
            MOV  CL,4                   ; Write 4 counter bytes

WriteHex:
HexLoop:
            ROL  AX,04                  ; Get Half Byte
            PUSH AX                     ; Save before AND
            AND  AL,0FH                 ; Mask unrelated bits
            DAA                         ; for 'A..F'
            ADD  AL,0F0h                ; Convert to hex char
            ADC  AL,40h         
            STOSB                       ; Store in string
            POP  AX                     ; Next half byte
            LOOP HexLoop        

            INC  DI                     ; Spacing
            CMP  SI,DX                  ; Need double spacing?
            JZ   DoubleSpace

            INC  AX                     ; turn FFh (if any) into 0
            CMP  AL,32                  ; Unprintable character?
            JA   PrintOK                ; It is OK to print this character

;-Code before optimize --------------------------------------------
;            CMP  AL,0FFH               ; Unprintable character?
;            JE   Replace                 
;            CMP  AL,31                 ; Unprintable character?
;            JA   PrintOK
;------------------------------------------------------------------

Replace:
            MOV  BYTE PTR [SI-1],250    ; Replace with ""
PrintOK:

            DEC  BP                     ; Decrease Total byte left
            JZ   StartPrint             ; No more byte?

            CMP  SI,OFFSET STRING+65    ; Is it time to print '-'?
            JNZ  Skip                   ; No, not center yet.
            DEC  DI                     ; "Erase" pre-printed space
            MOV  BYTE PTR [DI],'-'      ; print '-'
DoubleSpace:
            INC  DI                     ; print space
Skip:
            MOV  AH, [SI]               ; Load new data into AH
            INC  SI                     ; Point to next byte of data
            MOV  CL,2                   ; A byte got 2 part to print as hex
            JMP  WriteHex               ; Print next byte
StartPrint:

            POP  DI                     ; Get Pointer to String
            MOV  [SI],DI                ; write CrLF (DI = 0A0Dh)
            MOV  CX,SI
            SUB  CX,OFFSET STRING-2     ; Calculate string length
PrintLine:
            MOV  DL, [DI]               ; Get a byte
            INC  DI                         
            MOV  AH,06          
            INT  21H                    ; Print to Standard Output
            LOOP PrintLine
            JMP  Main
Done:                                   
            RET                         ; Exit to DOS

STRING      EQU  0A0DH                  ; I need a fix address for 2 purpose 

;------ Data Structure -------------
;STRING      db      57 dup (?)      -> 57 bytes for printing Hex decimal
;BUFFER      db      16 dup (?)      -> 16 bytes for printing ASCII
;CrLf        db      0DH,0AH         -> 2 bytes for new line
;-----------------------------------

END
