;*************************************************************************
; Program:       ENTRY.COM
; Created by:    Alexione
; Contact:       Aleksa Todorovic <alexione@eunet.yu>
; Started:       5-4-2002
; Last modified: 23-4-2002
; Description:   Hugi Compo #17 competition entry
; Compile with:  nasm -fbin -o entry.com entry.asm
;*************************************************************************

        org     100h

%define jmps            jmp short
%define magic_pos       (5Ch + 9)

;*************************************************************************
open_file:
        mov     di, magic_pos

; Here goes Alvaro's trick from HC15:
        shl     dword [di], 8
        mov     byte [di], '.'

        mov     ah, 3Dh
        mov     dx, 005Dh

        int     21h ; open file
        xchg    bx, ax ; BX <- file handle, AX <- 0
;*************************************************************************



;*************************************************************************
loop_line:
        mov     cl, 16

        pusha ; global loop save
;*************************************************************************



;*************************************************************************
print_line_address:
        xchg    ah, al

..@print_byte:
        push    ax

        aam     16

.again:
        xchg    al, ah

        cmp     al, 10
        sbb     al, 69h
        das

        stosb

        neg     bp
        js      .again

        pop     ax

.magic_jump:
        sub     dl, 5Fh
        jns     ..@cont_print_values
        jpo     print_line_address
        dec     dx ; DL <- magic_pos + 4 + 2 + 47 + 4
;*************************************************************************



;*************************************************************************
setup_load_line:
        mov     ax, 3F20h

        pusha
        mov     cl, 2 + 47 + 4
        rep     stosb
        popa

int_21:
        int     21h ; read from file / quit program

        cmp     al, 8
        jbe     $ + 6
        mov     byte [di + 2 + 23], '-'

        xchg    ax, cx
        jcxz    int_21 ; here, AH = 0, so this will quit program
;*************************************************************************



;*************************************************************************
print_values:
        mov     si, dx
        inc     di

.loop:
        inc     di

        lodsb

        mov     dl, magic_pos + 5Fh
        jmps    ..@print_byte

..@cont_print_values:
        inc     ax
        cmp     al, 32
        ja      .next
        mov     byte [si - 1], 250

.next:
        loop    .loop

        mov     word [si], 0A0Dh
;*************************************************************************



;*************************************************************************
print_line:
        lea     cx, [si - magic_pos + 2]
        mov     bl, 1
        mov     ah, 40h
        int     21h

        popa ; global loop restore

        add     ax, cx ; CX = 16

        jmps    loop_line
;*************************************************************************



