;FileDump by Aphex
;entry for HC17
;compile: tasm /m entry
;         tlink /t/x entry

p286
model tiny
codeseg
startupcode

DEBUG	equ	0

start:

	IF	DEBUG
	xor	ax, ax
	xor	bx, bx
	mov 	cx, 0FFh
	mov	dx, cs
	mov	si, offset realstart
	mov	di, sp
	mov	bp, 91Eh
	ENDIF
	
realstart:	
	mov	dh, 1Ah				
	sub	cx, [bx]                        ; cx = 0E032h
	push	dx
	daa
fileop:
	lodsw					
	db	10h, 0DDh			; adc ch, bl
						; as bl = 0 and ch << 0 
						; whether the CF is set or not
						; it will set SF until the
						; read operation when
						; ch will be either 0 or 1
						; and it will clear SF
	int	21h    
	mov	dx, 5Ch				; dx -> 1st FCB
	js	fileop
	pop	si

biggerloop:
	mov	bp, sp
	mov	di, 20Ah			; di -> string buffer
	mov	cx, 17				; 16 bytes / row 
						; + 1 loop for offset
	push	di
printbx:
	mov	al, bh
	xchg	bl, bh	
	db	8				; or [...], ch
bigloop:
	stosb					; write last char
	lodsb					; get byte
	inc	bx				; next address

	mov	dx, 0DFAh
	inc	ax
	cmp	al, 21h
	dec	ax
	jc	displayable
	mov	dl, al
displayable:
	mov	[bp+242h], dx			; draw char

	aam	16				; break al into nibbles
	db	8				; or [...], ch
loopdigit:
	stosb
	mov	al, 89h
	xchg	al, ah                          
	cmp	al, 10
	sbb	al, 69h
	das
	jc	loopdigit			; until al = 20h
	inc	bp				; bp = counter:
						;  -1 = address high byte
						;   0 = address low byte 
						; > 0 = data byte
	jz	loopdigit                       
	js	printbx				

	cmp	bx, ds:word ptr [6Ch]		; CF = !EOF
	jz	exitloop
	cmp	cx, bp
	jnz	skipdash
	add	al, 0Dh
skipdash:
	loop	bigloop
	   					
exitloop:
	stosb
	
writesp:
	stosb
	stosb
	stosb
	loopz	writesp
						
writestr:
	pop	ax				; ax = 20Ah
	mov	[bp+di], ax		        ; di = 243h
						; bp = data bytes on row + 1
	xchg	di, ax				; di = 20Ah, ax = 243h
getmorechars:
	mov	dl, [di]
	int	21h                             ; display char
	scasw
	dec	di
	jc	getmorechars			; until ax = 20Ah

	inc	cx
	loop	biggerloop			; if !EOF then loop
	ret

end start