	ORG	100h

; 119 first entry using file handles
; 118 first entry using FCBs

	mov	ah, 0fh			; open FCB
	mov	dx, 5ch
	int	21h			; read
	mov	[bx+69h], si		; Set record size to 1
	mov	bp, [bx+6ch]

nextline:
	mov	si, output+3		; point past offset
	call	incr			; increment	
	lodsb				; point SI past the first space
	lodsb				; setting AL = 20h

	mov	di, si
	mov	cl, 34h
	rep	stosb			; write spaces, DI points to characters
	mov	cl, 16

read:
	mov	ah, 14h
	int	21h			; read a byte into [80h]

	mov	bl, 80h			; AL=0, so MOV+XLAT=MOV AL,[80h]
	xlatb				; get it from DTA into AX and BX
	mov	bl, al
	inc	bx			; increment for hex->dec loop
	cmp	bl, [si]		; to check if in FFh-1Fh range,
	ja	ok			; check if x+1 <= 20h
	mov	al, 0fah		; if so, use ASCII dot instead
ok:
	stosb				; store it

	cmp	cl, 8			; eight character on the line?
	jne	nodash
	mov	byte [si], 2dh		; put a dash at the eighth place
nodash:

	lodsb				; advance SI
	mov	word [si], 2f30h	; 2fh will be incremented to '0'
	lodsw				; advance SI *past* the number
incr_n:
	call	incr			; increment the hex digit
	dec	bx			; to match the character we loaded
	jnz	incr_n

	dec	bp
	loopnz	read			; Loop if more to do for the line and the file

print:
	mov	si, crlf		; append CR/LF
	movsw				; point SI to output

	pusha			; Save bytes left and DTA
	inc	bx			; BX = 1 for stdout
	mov	dx, si			; DX points to output
	mov	cx, di			; # of bytes to print
	sub	cx, dx
	int	21h			; AH=40h from the INCR subroutine
	dec	bp			; Test again for BP=0
	popa
	jns	nextline		; If EOF, fall through to the RET

	mov	ah, 10h
	int	21h
	
	; increment hex number, SI points past the number.

incr:
	push	si			; save pointer to hex number
next:
	dec	si
	mov	ax, 3046h		; 46h='F' overflows into '0'=30h...
	cmpxchg	[si], ah
	je	next			; ...and carries into the next byte
	mov	ax, 4039h		; 39h='9' overflows into 'A'=40h+1
	cmpxchg	[si], ah
	inc	byte [si]		; increment the first non-carrying byte
	pop	si			; restore pointer to hex number
done:
	ret				; also used to exit the program

crlf:
	db	13,10
output:
	db	'00', 2fh, '0 '		; 2fh will be incremented to '0'
