;#########################################################################################;
;#                                                                                       #;
;#   Bratalarm presents...                                                               #;
;#   ---------------------------------------------------------------------------------   #;
;#                                                                                       #;
;#    contributed to Hugi-Compo #17                                                      #;
;#                                                                                       #;
;#    a  DUMP utility that dumps a file's contents                                       #;
;#    to StdOut in the following format:                                                 #;
;#    "xxxx  xx xx xx xx xx xx xx xx-xx xx xx xx xx xx xx xx    xxxxxxxxxxxxxxxx"        #;
;#                                                                                       #;
;#   ---------------------------------------------------------------------------------   #;
;#            04/27/2002 - first release [ ENTRY.COM: 159 Byte, DUMP.ASM ]               #;
;#   ---------------------------------------------------------------------------------   #;
;#                                                                                       #;
;#    Contact: JtCrk2000@gmx.net                                                         #;
;#                                                                                       #;
;#########################################################################################;


; TASM

.model tiny
.386

CODE	SEGMENT PUBLIC USE16

ASSUME	CS:CODE, DS:CODE, SS:CODE
ORG	100h


START:				; Entrypoint

; --------------------------------------------------------------------o
; Get command-line
; --------------------------------------------------------------------o
	mov	si, 80h
	mov	bl, [si]
	mov	[si+bx+1], bh

	
; --------------------------------------------------------------------o
; Open file | read only (al = 0) | filename = DS:DX
; --------------------------------------------------------------------o
	mov	dx, si
	inc	dx
	mov	ah, 3Dh
	int	21h		; ... no error-check here
	xchg	bx, ax		; save handle


; --------------------------------------------------------------------o
; Read file | max 32768 chars
; --------------------------------------------------------------------o
	mov	ah, 3Fh
	mov	cx, 32768
	lea	dx, [filebuf]
	int	21h
	mov	cx, ax			; loop counter
	xor	bx, bx			; file offset
	push	offset filebuf		; pointer to file - buffer


; --------------------------------------------------------------------o
; Now start to output the stuff
; --------------------------------------------------------------------o
DumpFile:

	pop	si			; pointer to file - buffer
	test	cx, cx			; end of file - buffer ?
	jz	short the_end
	lea	di, [otpbuf]		; pointer to output - buffer
	pusha
	mov	al, 20h			; 
	mov	cx, 73			; fill output - buffer
	rep	stosb			; with spaces
	popa

	
; --------------------------------------------------------------------o
; Create offset (BX)
; --------------------------------------------------------------------o
	mov	al, bh
	call	gethex	; convert HighWord -> DX and store it in DS:DI
	mov	al, bl	
	call	gethex	; convert LowWord -> DX and store it in DS:DI
	inc	di	; increase pointer to make one space
			; the second one will be created in the
			; hex-bytes-loop (another 'inc di')

; --------------------------------------------------------------------o
; Create hex- and ascii-bytes
; --------------------------------------------------------------------o
	
	lea	bp, [otpbuf+57]
	mov	dl, 17		; do 16 loops at max
hb_0:	dec	dl		; loop 16 times and then..
	jz	short hb_3	; ..goto ascii-byte-creation
	lodsb			; al = [DS:SI] , SI++
	push	ax
	cmp	dl, 8		; do we need the hyphen?
	ja	short hb_1
	mov	byte ptr [otpbuf+29], "-"
hb_1:	inc	al		; if al=255 it becomes 0 so we can..
	cmp	al, 32		; ..check if the char is between..
	ja	short hb_2	; ..0-32 instead of 0-31 and 255
	mov	al, 251		; why not 250? watch below!
hb_2:	dec	al		; remember the 'inc al' ? :)
	xchg	di, bp
	stosb
	xchg	bp, di
	pop	ax
	inc	di		; leave one byte blanc (space)
	call	gethex		; convert al to hex
	dec	cx		; decrease loop counter (size of file)
	jnz	short hb_0	; end of buffer?
hb_3:

; --------------------------------------------------------------------o
; Print the output-buffer to screen (ASCiiZ)
; --------------------------------------------------------------------o
	mov	eax, 000A0Dh	; CRLF
	xchg	di, bp
	stosd
	push	si		; save file-buffer-pointer
				; the first instruction below the label
				; 'DumpFile' is the restore
	lea	si, [otpbuf]	; output-buffer has got the whole line

pb_0:	lodsb			; get one char to al
	test	al, al		; zero-termination reached?
	jz	short pb_1	; if so .. ready :)
	mov	dl, al		; 
	mov	ah, 6		;
	int	21h		; output service
	jmp	short pb_0	; one more time
pb_1:	add	bx, 16		; increase the offset
	jmp	short DumpFile	; next round :)


; --------------------------------------------------------------------o
; Exit to DOS
; --------------------------------------------------------------------o
the_end:	ret


; --------------------------------------------------------------------o
; Convert al to hex and store it in DS:DI
; --------------------------------------------------------------------o

gethex:
	push	cx
	mov	cx, 2		; one byte => 2 hex-chars => 2 loops
gh_1:	rol	al, 4
	push	ax
	and	al, 0Fh
	daa
	add	al, 0F0h
	adc	al, 40h
	stosb
	pop	ax
	loop	gh_1
	pop	cx
	ret

; --------------------------------------------------------------------o
; Buffer
; --------------------------------------------------------------------o
	otpbuf	  DB 76     DUP(?) ; 73 chars + CRLF + Zero = 76 :]
	filebuf	  DB 32768  DUP(?)


CODE	ENDS
END	START