.model tiny	;Dump program for 17th Hugi Compo by Akos Fekete ( Chut )
.486		;
.code		;e-mail: akosf@interware.hu

		org	100h

b_		equ	byte ptr
s_		equ	short

HC17:		xchg	ax,bp		;BP - dump address
		shr	si,1
		mov	bl,[si]
Again:		inc	si
		mov	[si+bx],ch	;Close filename with 0
		mov	dx,si		;Filename w/wo leading spaces
		mov	ah,3Dh
		int	21h
		jc	s_ Again	;Skip leading spaces
		xchg	ax,bx
ReadLine:	mov	ax,3F20h
		mov	di,cs		;DI - text puffer
		mov	cl,39h
		rep	stosb		;Fill up with spaces
		mov	cl,10h
		int	21h
		xchg	ax,cx
		jcxz	s_ OutOf
		pusha			;BX - handler; SI,DX - input puffer
		pusha			;CX - length; SI,DI - in/out puffer

		mov	di,cs		;Storing the address...
		mov	bx,bp
		call	Hex
		call	Hex
		inc	di		;Skip over ONE space (after address)

		mov	dl,9		;Position of hyphen

ReadByte:	lodsb			;Storing hex codes of data...
		mov	bh,al
		dec	dx
		jnz	s_ NoHyphen
		mov	b_ ds:[di],'-'
NoHyphen:	call	HexSpc
		loop	ReadByte

		popa
ReadChar:	lodsb			;Storing ascii codes of data...
		inc	ax
		cmp	al,21h
		dec	ax
		jnc	s_ PutChar
		mov	al,0FAh
PutChar:	stosb
		loop	ReadChar

		mov	ax,0A0Dh	;Storing a CR+LF pair
		stosw

		mov	si,cs
PrintChar:	lodsb			;Print out the stored characters
		xchg	ax,dx
		mov	ah,02h
		int	21h
		cmp	di,si
		ja	s_ PrintChar

		popa
		add	bp,ax		;Increment address value
		jmp	s_ ReadLine

HexSpc:		inc	di		;Skip a space or hyphen
Hex:		mov	ax,300Fh	;BL -> BH -> hex conversion
		rol	bx,4		
		and	al,bl
		aaa
		aad	11h
		stosb
		neg	sp
		jns	s_ Hex
OutOf:		ret

		end	HC17