;------------------------------------------------------------
;Program: entry.com
;Author: DrXem (drxem@hotmail.com)
;Compiled with: TASM 5.0
;Size: 144 bytes
;Description: Hex Dumper for HUGI Compo 17.

;The program reads all bytes in a file to "buffer".
;Then it adds the offset, 16 bytes converted to ascii and 
;the ascii characters for these bytes to "line". Finally 
;it prints "line" and loops until no bytes are left.
;------------------------------------------------------------
.model tiny
.186
.code

org 100h

start:
;Skips spaces and puts a 0 at the end of the filename to make it
;a valid ASCIIZ string.
	shr si,1		;SI = 100h at execution, divided by 2 = 80h
skip:
	inc si
	cmp byte ptr[si],20h
	jbe skip		;Skips all spaces before filename
	
	mov dx,si		;dh <- 0
skip2:
	inc si
	cmp byte ptr[si],0Dh
	jne skip2
	
	mov [si],dh		;add a 0 at the end

;Open file in read-only mode
	mov ah,3Dh		;al = 0 = read only
	int 21h			;Returns filehandle in ax

	xchg bx,ax		;move file handle to bx, required for 21,3fh

;Read file, max 32768 bytes, into "buffer"
	mov ah,3Fh
	mov cx,32768
	mov dx,offset buffer
	int 21h			;Returns number of bytes read in ax

        mov si,dx		;si <- offset of buffer
        xchg bx,ax		;move bytes read into bx 
        xor ax,ax		;ax <- 0, used as the offset counter

mainloop:
	mov bp,offset line+57	;Used later when adding the ascii characters to "line"

	mov di,offset line	;di <- "line"
	mov cx,04h		;Add 4 characters to "line"
        call hex2ascii		
        add ax,10h
        push ax			;Save offset

;Add Spaces (20h) to all bytes in "line" but the offset
	mov al,20h
        mov cl,69
        rep stosb
   
        mov dx,16		;16 bytes on each line
        sub di,67		;Begin after the offset + 2 spaces

;Loops 16 times or until no bytes are left.
;Each time it converts the hex byte to ascii
;and adds them plus their ascii characters to
;"line". If the characters are 255 or 0-31,
;ascii character 250 is added instead.
;This loop also checks if a hyphen should be
;printed.
underloop:
        lodsb			;al <- byte
        mov ah,al
        mov cl,2
        call hex2ascii		;convert to ascii
        inc ax			;if character is 255 it becomes a 0
        cmp al,32		;0-32 = 255 and 0-31
        ja nodot
        mov al,251		;then use ascii character 250
nodot:
	dec ax
	
	xchg bp,di		;switch values in bp and di. BP points to the place in "line"...
	stosb			;...where the ascii characters should be.
	mov [di],word ptr 0A0Dh	;also add a LF and CR byte to end the line when 16 or no bytes are left
	xchg bp,di		;Switch back
        
        dec bx			;decrease total byte counter
        jz printline		;If no byte are left, print the last line
        cmp dx,09		;If a 9th byte is present...
        jne nohyphen
        mov byte ptr[di],2Dh	;...add a hyphen
nohyphen:
	inc di			;else let it be a space
        dec dx			;decrease line-byte counter
        jnz underloop		;if 16 bytes are written, print line
	
printline:
        push si			;save old si (points to a place in "buffer")
        mov si,offset line	;instead point to "line"
printline2:
        lodsb			;al <- character from "line"
        xchg dx,ax		;dl <- al
        mov ah,02h		;Print character to STDOUT
        int 21h
        cmp dl,0Ah		;Continue print characters until LF occurs 
        jne printline2
        pop si			;Restore SI
        
        pop ax			;ax <- offset "counter"
        xor bx,cx        	;if no bytes are left then quit (cx = 0)
        jnz mainloop
        
	int 20h

;Converts bytes in ax to their ascii characters and puts them in "line".
;If it loops two times and ah = al only one byte is converted. ex: 10h becomes 31h and 30h.
;If it loops four times, two bytes are converted.

;The idea is from HUGI Compo 17 example file
hex2ascii:
	rol ax,04
	push ax
	and al,0Fh		;al <- hex value that should be converted
	cmp al,10		;character < 10, CF <- 1
	sbb al,69h
	das
	
	stosb

	pop ax
	loop hex2ascii
	ret

line DB 75 DUP (?)		;Used to store all bytes in one line
buffer DB 32768 DUP(?)		;Used to store all bytes from the file specified at the commandline

end start