;===================================================
; Hugi Size Compo #17
;===================================================
; Fourth version (117 bytes)
; Uses FCB
;===================================================
; Author: Vinicius J. Fortuna
; Contact: fortuna@acm.org
;===================================================
; Assembled with NASM :
;   nasm entry.asm -o entry.com -l entry.lst -O3
;===================================================


;***************************************************
; Constants definition

%define FIRST_FCB	5Ch
%define FIRST_FILENAME  5Ch+1
%define FIRST_FILE_SIZE 5Ch+10h 
%define CR      0Dh
%define LF      0Ah


;***************************************************
; Begin of the code

SECTION .text

		org     100h
		bits 16

;***************************************************
; Assumptions
; AX == 0000   BX == 0000   CX == 00FF
; DX == CS == DS == ES == SS == xxxx
; 0080 <= DX <= 9000   BP == 09xx
; SI == IP == 0100   DI == SP == FFFE

entry_point:

;***************************************************
; Open and Reads File (Based on Ruud's HC06)

set_DTA:	mov dh, 11h			; DX <- Buffer (anywhere after 1100h (must be after Line))
		mov ax, 1A5Ch
		int 21h
		cbw				; AH <- 00h (AX == FIRST_FCB (5Ch))
		xchg dx, ax			; AX <- Buffer, DX <- FIRST_FCB
		xchg si, ax			; SI <- Buffer, AX <- 0100h

open_file_FCB:	mov ah, 0Fh
		int 21h

read_file:	; Assumes DX==FIRST_FCB
		inc cx				; CX <- 0100h
		mov ah, 27h
		int 21h				; Read 100h*80h bytes

close_file:     ; DX==FIRST_FCB
		mov ah, 10h
		int 21h				; AL <- 00 (success)


;***************************************************
; Initialization

init:           mov word bp, [bx+6Ch]		; BP <- File size
		xchg bx, ax			; AH <- 0 (First offset), BX <- 1000h (Line addres)


;***************************************************
; Processing

process_line:	mov dl, 16			; Bytes to print in the line (Assumes DH==0)

store_offset:   call print_hex2                 ; Stores offset
                mov di, bx			; DI <- Address to store
		inc bx				; skips 1st space
                add ax, dx			; Offset <- Offset + 16
		push ax				; Saves file offset
                
clear_line:	mov al, 32
		mov cx, 0053			; Spaces to store (Assumes CH==0)
		repnz
		stosb				; Assumes AL==32

process_bytes:	
hex_value:      cmp dl, 8			; Is it a dash to print?
                jne space
                mov byte [bx], '-'
space:          inc bx 
  		dec si				; Anticipate SI
  		lodsw				; AH <- next byte
		call print_hex			; AL <- AH

ASCII_value:	inc ax
		cmp al, 32
		ja printable			; Char is printable
		mov al, 251			; "Dot(250)" + 1
printable:	dec ax
		stosb				; Stores ASCII

		dec bp
		jz next				; Is it the end?
		dec dx				
		jnz process_bytes		; There's still more bytes (Assumes DH==0)
		dec dx				; Sets SF (DX was 0) Means BP>0

next:		mov ax, 0A0Dh			; End of line
		stosw

print_string:   mov dx, di			; DX <- 1000h + LineLength
		xchg cl, dl			; CL <- LineLength, DL <- 00h (CX==LineLength, DX==LineAddress(1000h))
		mov bx, 0001h			; BX <- 1 (StdOut handle) (Assumes ZF not changed since "next")
		mov ah, 40h			; Print to device
		int 21h

		xchg bx, dx			; BX <- 1000h, DX <- 0001h
		pop  ax				; AX <- offset value
		js process_line			; Sign flag set? -> BP>0, continue...


;***************************************************
; End of program  (goes through print_hex)

end:
             	;ret


;***************************************************
; Stores the hex repr in ASCII of the number in AX(H)
; Based on Ben's example for the Compo
; Modifies ax, bx, ci

print_hex2:	call print_hex
print_hex:	call PLoop
PLoop:     	rol ax, 04
           	push ax
           	and al,0Fh
           	daa
	       	add al,0F0h
		adc al,40h
		mov [bx], al
		inc bx			; Store the value in the buffer
		pop ax
		ret


;***************************************************
; Buffer area

;section .bss
;Line:		resb 100                ; Line to be output
;Buffer:        	resb 32769+256          ; buffer file content
