;-----------------------------------------------------------------------;
;                                                                       ;
; Entry for HUGI size coding competition #17 - a dump program           ;
; To compile with MASM: ml entry.asm                                    ;
;                                                                       ;
; By Jeff (USA)                                                         ;
;                                                                       ;
;-----------------------------------------------------------------------;
		.MODEL	tiny
		.386
		.CODE
		.STARTUP

;		mov	si, 100h	; DEBUGGING ONLY - REMOVE
		shr	si, 1		; SI = 0080h
		lodsb			; SI = 0081h
		xchg	bx, ax
		mov	[bx + si], al
		mov	bp, 0a0dh	; CR/LF - start of data
		mov	dx, si
		mov	si, bp
NextOpen:
		mov	ah, 3dh
		int	21h		; Open file
		inc	dx
		jc	NextOpen
		xchg	bx, ax

d_default:
		mov	dx, si
		mov	di, si
		mov	ax, 3f20h
		mov	cl, 57
		std
		rep	stosb		; Initialize data to spaces
		cld
		mov	cl, 10h
quit:		int	21h		; Read 16 bytes
		cmp	al, 8
		jbe	NoDash
		add	[di + 29], bp
NoDash:		xchg	cx, ax
		jcxz	quit		; Quit if no data

		push	di
		sub	dx, bp
		mov	al, dh
		call	disp_char
		xchg	ax, dx
		call	disp_char	; Display offset
		scasw			; add 2 to di in one byte

d_byte:
		lodsb
		inc	ax
		cmp	al, 32
		ja	print_ok
		mov	byte ptr [si-1], 250
print_ok:	dec	ax
		call	disp_char	; Display character
		inc	di
		loop	d_byte
		mov	[si], bp

		pop	di
		mov	ah, 2
NextChar:
		mov	dl, [di]
		int	21h		; Write character
		cmp	si, di
		inc	di
		jnc	NextChar
		jmp     d_default


disp_char:
		db	0d4h, 10h		; AAM 16
		call	PrintChar		; Loop twice
PrintChar:
		xchg	al, ah
		cmp	al, 0ah
		sbb	al, 69h
		das
		stosb
		ret

		END