; Hugi Compo 17 Entry (150 bytes)
; By Martins Mozeiko from Latvia
; Copyright 2002
; 
; Assembled with Nasm 0.98
[BITS 16]               ;Set code generation to 16 bit mode
[ORG 0x0100]            ;Set code start address to 0100h

[SEGMENT .text]         ;Main code segment

    mov  ah,0Fh         ; Open File via FCB
    mov  dx,5Ch
    int  21h

    mov  byte [5Ch+0Eh],10h   ; read in 16 byte blocks
    mov  bp,[5Ch+10h]   ; bp = file size in bytes
    dec  bp

    xor  bx,bx          ; bx = line number

NewLine:                ; New Line
    mov  ah,14h         ; Read Sequential File via FCB
    mov  dl,5Ch		; dh already is 
    int  21h

    mov  ah,02h         ; for printing char
    mov  cl,10h         ; 16 bytes in line
    mov  di,cx          ; di = 10h = 16

    mov  al,bh          ; write line nr
    call ToHex          ;
    mov  al,bl          ;
    call ToHex          ;

    mov  dl,20h         ; 2 spaces
    int  21h
    int  21h

    mov  si,80h
    push si
BigLoop:
    lodsb               ; al = byte
    call ToHex          ; write hex

    mov  dl,20h         ; assume space
    cmp  cl,9
    jne  @skip          ; if not 8 byte in line then ok
    test bp,bp
    jz   @skip          ; if not last byte then ok
    mov  dl,'-'         ; change to '-'
@skip:
    int  21h

    inc  bx             ; increment printed byte count

    dec  bp             ; dec total bytes to write
    js   WriteEnd
    dec  cx             ; inc written bytes in line
    jnz  BigLoop

    inc  cx
WriteEnd:
    sub  di,cx          ; di is 10h,  di = 16 - cx

    mov  dl,20h		; ' '
PrintSpaces:
    int  21h
    int  21h
    int  21h
    loop PrintSpaces    ; write 3*cx spaces

    mov  cx,di          ; cx number of bytes to write
    inc  cx

    pop  si             ; pointer in buffer to line start
PrintBytes:
    lodsb
    cmp  al,255
    je   @notok
    cmp  al,31
    ja   @ok
@notok
    mov  al,250
@ok:
    mov  dl,al
    int  21h
    loop PrintBytes

    mov  dl,0Dh         ; write CR
    int  21h            ;
    mov  dl,0Ah         ; write LF
    int  21h            ;

    test bp,bp
    jns  NewLine

    mov  ah,10h         
    mov  dl,5Ch         ; Close File via FCB
    int  21h
    ret                 ; end programm

ToHex:                  ; converts al to hex and prints out, assumes ah = 02h
    push ax             ;1
    shr  al,4           ;3
    call OneChar        ;3
    pop  ax             ;1
OneChar:
    and  al,0Fh         ;2
    cmp  al,0Ah         ;2
    sbb  al,69h         ;2
    das                 ;1
    mov  dl,al          ;2
    int  21h            ;2
    ret                 ;1
                        ;=20

[SEGMENT .bss]          ;Uninitialised data segment

Buffer resb 32768

