;*************************************************************************
; Program:       ENTRY.COM
; Created by:    alexione
; Contact:       Aleksa Todorovic <alexione@eunet.yu>
; Started:       3. 6. 2002.
; Last modified: 22. 7. 2002.
; Description:   Hugi Compo #18 competition entry
; Compile with:  nasm -fbin -o entry.com entry.asm
;*************************************************************************

        org     100h

%define jmps    jmp short

;*************************************************************************
; input buffer -> [DI]
; output buffer -> [BP + SI]
;*************************************************************************



;*************************************************************************
program:
        shr     di, 1 ; D1 EF ; DI <- 7FFFh

; byte before roman_1 has to be >= 80h
roman_1 equ $
        db      'MCXI'
; 4D    DEC     BP
; 43    INC     BX
; 58    POP     AX
; 49    DEC     CX

        std
        mov     ah, 8

again:
        pusha

.loop:
int21 equ $
        int     21h

        stosb

        cmp     al, 0Ah
        jne     .loop

        mov     [di], byte '$'
;*************************************************************************



;*************************************************************************
convert:
        mov     bl, 4 + 3 + 1
; max 4 digits + 3 for 0D, 0Ah, '$' + 1 for JZ below

.loop:
        dec     bx
        jz      next_number

        mov     ax, 0500h + '4'
;        mov     dx, [byte si + roman_1 - 2 + bx] ; DL = x10, DH = x1
; ..@roman1 = SI + 2
        mov     dx, [si + bx] ; DL = x10, DH = x1
        mov     cl, [byte si + roman_5 - 2 + bx] ; CL = x5

; a little bit tricky loop

.loop_4_9:
        cmp     [di], al
        jb      .decimal

        xchg    dl, cl ; CL, DL : x5 <-> x10
        je      .decimal_4_9

        cmp     [di], dx
        je      .roman_4_9

        add     al, 5
        jpe     .loop_4_9 ; AL = 39h -> PE, AL = 3Eh -> PO

.count_x1:
        mov     al, '0' - 1
        dec     di

.loop_x1:
        inc     ax
        inc     di
        cmp     [di], dh
        je      .loop_x1

        cmp     [di], cl
        je      .add_5

        cmp     al, '3'
        ja      next_number ; more that 3 x1's

        dec     di ; back to last x1

        db      0F7h ; TEST WORD [DI], 4705h
.add_5:
        db      5, 5 ; ADD AX, 4705h
.roman_4_9:
        inc     di ; 47h

        jmps    .xstore_al

.decimal_4_9:
        xchg    dl, dh
        mov     al, '9' + 5

.store_dh:
        dec     bp
        mov     [si + bp], dh

.decimal:
        aad     255 ; 1) AL <- AL - 5, 2) AL <- AL; AH <- 0
        inc     ax
        cmp     al, [di]
        jb      .store_dh

        mov     al, [di]

        cmp     al, '4'
        jae     .store_dl

        cmp     al, 27h
        ja      .next
; 0Ah - 27h = E3h -> PO
; 0Dh - 27h = E6h -> PO
; 1Ah - 27h = F3h -> PE
; 24h - 27h = FDh -> PO
        jpe     int21 ; AH = 0 -> quits program

.xstore_al:
        xchg    ax, dx

.store_dl:
        dec     bp
        mov     [si + bp], dl

        or      dl, dh ; check to see if we used wrong character
        js      next_number

.next:
        inc     di
        jns     .loop
;*************************************************************************



;*************************************************************************
print:
        cmp     [si + bp], byte 0Dh
        je      next_number

        lea     dx, [si + bp]
        mov     ah, 9
        int     21h
;*************************************************************************



;*************************************************************************
next_number:
        popa
        jmps    again ; EB 8x
;*************************************************************************

; byte before roman_5 has to be >= 80h
roman_5 equ $
        db      'DLV'
