; HugiCompo 18 entry by Beeblebrox / TMA
; Roman <-> decimal conversion
; 143 bytes version 21.07.2002 01:22
.model use16 tiny
.286
.code
                org     100h
begin:
; Assume CX=00FFh => CX*16=0FF0h which is greater than BP=09xxh
dec2bcd:        shl     cx,4          ;3; convert ASCII string to packed BCD
                add     cl,al         ;2
                cmp     cx,bp         ;2; >=4000h?
                jae     start         ;2
check_str:      lodsb                 ;1; get next char
                test    al,40h        ;2; roman char?
                jnz     roman2decimal ;2
                sub     al,30h        ;2; CR ?
                jnc     dec2bcd       ;2
                jcxz    start         ;2
                dec     bx            ;1
print:          inc     bx            ;1
                call    cx2str        ;3; cx to string[di]
                movsw                 ;1; Cr, Lf
                movsb                 ;1; '$'
                mov     ah,9          ;2
                int     21h           ;2 -> 31
; bp=4000h=offset in_buf (roman string CrLf-terminated)
; di=end_of_in_buf (first "dummy" loop)
roman2decimal:  mov     cx,bp         ;2
rom2dec:        push    cx            ;1
                shr     di,1          ;2; mov di,2000h
                call    cx2str        ;3; cx to roman string[di]
                movsw                 ;1; Cr, Lf
                xchg    di,dx         ;2; 2000h
                mov     cl,dl         ;2; length
                mov     si,bp         ;2; offset in_buf
                repe    cmpsb         ;2
                pop     cx            ;1
                je      print         ;2; print cx as decimal
start:          mov     bp,4000h      ;3
                mov     di,bp         ;2; offset in_buf
                mov     si,bp         ;2
                loop    rom2dec       ;2; mov cx,0
                xor     bx,bx         ;2; to roman (flag)
getchar:        mov     ah,8          ;2
                int     21h           ;2; al <- char from STDIN
                stosb                 ;1
                cmp     al,10         ;2; Lf?
                je      check_str     ;2
                cmp     al,1Ah        ;2; EOF?
                jne     getchar       ;2
to_dec:         add     al,'0'        ;2
                stosb                 ;1
next_decimal:   lodsw                 ;1
                retn                  ;1 -> 49

; In:  cx=input (1...4000h), di=offset output string, bx=function
; bx=0 => ToRoman, bx=1 => ToDecimal
cx2str:         mov     si,offset roman_chars+7 ;3
                mov     dx,di         ;2
unpack_bcd:     jcxz    _ret          ;2
                push    cx            ;1
                shr     cx,4          ;3
                dec     si            ;1
                dec     si            ;1
                call    unpack_bcd    ;3
                pop     ax            ;1
                and     al,0Fh        ;2
                or      bx,bx         ;2
                jnz     to_dec        ;2
                mov     cl,al         ;2
                jcxz    next_decimal  ;2
                cmp     al,9          ;2
                ja      to_dec        ;2; skip A,B,C,D,E,F
                je      _9            ;2          +-----------+
not9:           cmp     al,4          ;2          |   3 2 1 0 |
                lodsb                 ;1; s       | --MDCLXVI |
                jb      _123          ;2          |       tsr |
                je      _4            ;2; 4 => rs |     tsr   |
                stosb                 ;1; s       |   tsr     |
                sub     cl,5          ;3; 5 => s  | tsr       |
_123:           lodsb                 ;1; r       +-----------+
                repnz                 ;1; 1,2,3 => r,rr,rrr
                stosb                 ;1; 6,7,8 => sr,srr,srrr
_ret:           retn                  ;1
_9:             dec     si            ;1
                lodsw                 ;1; al=t
_4:             movsb                 ;1; r
                stosb                 ;1; 9 => rt  4 => rs
                retn                  ;1 --> 53

roman_chars     db      'MDCLXVI',13,10,'$'; -> 10

                end     begin
