;----------------------------------------------------------------------------;
;									     ;
;		entry for hugi compo #18 - 107 bytes total		     ;
;		 by Boiled Brain (pogonyshev@tut.by, Belarus)		     ;
;									     ;
;      compile: tasm /m2 entry.asm					     ;
;     and link: tlink /t entry.obj					     ;
;									     ;
; ripping note: db 0Dh,0Ah,'$'	trick was taken from  many entries for hugi  ;
;		compo #12.						     ;
;									     ;
;	  note: this entry  is hundreds or even thousands times slower than  ;
;		an optimized for speed one, but the rules say nothing about  ;
;		speed.							     ;
;----------------------------------------------------------------------------;

;		how it works
;
;  this entry is somewhat tricky - instead of converting input line  to the
;  other notation, it generate both notations for all the numbers from 1 to
;  3999  (actually, from 3999 to 1) and compares them to the input line. if
;  a decimal notation  matches,  it outputs the corresponding roman one and
;  vice versa.	it saves  a lot of bytes  because input  validity check  is
;  automatic  (if anything matches then input is valid).  however, it takes
;  much more time to run  (takes about 3 seconds  to pass the test suite on
;  my athlon-900). looking at the latest results i guess that other entries
;  also use this trick ;)
;
;  all notations are generated from the last  (least significant)  digit to
;  the first.  it simplifies  digit extraction	and allows line terminators
;  (0Dh, 0Ah, '$' bytes) to be at constant addresses.

		ideal
		p186
		model	tiny
		codeseg
		org	100h
;----------------------------------------------------------------------------;
;		main procedure (program entry point)			     ;
;  input: stdin contains lines with numbers in either notation		     ;
;	  assumes that si=0100h, bp=09xxh, df=0 			     ;
; output: converts numbers from stdin to other notations and prints them to  ;
;	  stdout							     ;
;----------------------------------------------------------------------------;
		proc	Main
		;; some data and initilizations - 16 bytes ;;
		db	0Dh,0Ah,'$'		; or ax,240Ah. harmless
						;  instruction, useful bytes
		db	0BFh
			; mov di,i16 opcode. eats 'IV', sets di to 5649h.
			;  decimal notations will be stored under 5649h
		db	'IVXLCDM'
			; roman digits, from the smallest to the largest. with
			;  'IV' eaten, gives pop ax, dec sp, inc bx, inc sp,
			;  dec bp instructions. note that stack is empty now
		inc	bp			; ensure that high byte of bp
						;  is 9
		mov	bx,si			; bx=100h. roman notations
						;  will be stored under 100h
		movsw				; copy 0Dh, 0Ah, '$' to 5649h,
		movsw				;  set si=104h -> roman digits
		;; reading a line - 16 bytes ;;
ReadNextLine:
		mov	di,bp			; a nice place to store the
						;  line at
		mov	ah,8			; read a char function
WriteChar:
		dec	di			; store al at [di-1] and 8 at
		stosw				;  di. after the loop passes,
						;  gives bp -> line, 0Dh, 8
EndOfFile:
		int	21h			; read a char
		test	al,0E1h 		; jumps for all alphanumeric
		jnz	WriteChar		;  chars and for 0Dh
		aam	20h			; sets ah=0, calculates parity
						;  of al (al=0Ah or 1Ah)
		jnp	EndOfFile		; if al is 1Ah then jump and
						;  quit the entry (stack is
						;  empty, we use int 21h, 0)
		;; generating roman and decimal notations - 49 bytes ;;
		mov	cx,3999 		; maximum number that is
						;  representable
		mov	di,[si] 		; di=[si]=5649h - a pointer
						;  to decimal notation
PreviousNumber:
		pusha				; save registers
		xchg	ax,cx			; ax=number to generate
						;  notations for, cx=0Ah=10
NextDigit:
		cwd				; zero dx
		div	cx			; get a digit in dx, divide
						;  the number by 10
		push	ax			; save the quotient
		lodsw				; get the roman digits for
						;  this decimal position
		xchg	ax,dx			; ax=digit, dx=roman digits
		dec	di			; make room for the decimal
						;  digit
		mov	[di],al 		; store it
		add	[byte di],'0'		; and convert it to a char
		aam	5			; ah=digit/5, al=digit%5
		jz	Digit0or5		; skip filling if it is 0 or 5
PutMoreIXCM:
		dec	bx
		mov	[bx],dl 		; put corresponding roman
						;  "one"
		dec	ax			; continue until al becomes
		jnp	PutMoreIXCM		;  0 or 3
Digit0or5:
		sub	al,ah
			; modify flags:  digits   al-ah   al	zf   pf   cf
			;		  0 - 3    0-0	=  0	 1    1    0
			;		    4	   3-0	=  3	 0    1    0
			;		  5 - 8    0-1	= -1	 0    1    1
			;		    9	   3-1	=  2	 0    0    0
		jz	RomanGenerated		; it is digit 0, 1, 2 or 3,
						;  so notation is generated
		jp	NotDigit9		; skip if digit is not 9
		mov	dh,[si] 		; and if it is, load next
						;  roman "one" to dh
NotDigit9:
		dec	bx			; make some space. keeps cf
		mov	[bx],dh
			; write roman "five" (in case of digit 9, it is not
			;  actually "five", but it will be overwritten, so
			;  we don't care)
		jc	RomanGenerated		; it is not digit 4 or 9, so
						;  notation is generated
		mov	[bx],dx 		; write subtraction term in
						;  one move (digit 4 or 9)
RomanGenerated:
		pop	ax			; restore what is left of
						;  the number
		test	ax,ax			; if we still have something,
		jnz	NextDigit		;  we'll work with it further
		;; comparing notations and printing - 26 bytes ;;
		xchg	ax,bp			; ax -> the line read, ah=9
						;  (for printing), bp=0
CompareNotations:
		pusha				; save ax, cx, si and di
		xchg	ax,si			; si -> the line read, ax>100h
		xchg	ax,cx			; ax=0Ah, cx is "large enough"
		repe	cmpsb			; compare strings
		dec	di			; di -> first character that
						;  doesn't match
		scasb				; isn't it 0Ah? (if it is,
						;  then notations match)
		popa				; restore ax, cx, si and di
		jne	SkipPrinting		; skip printing if not a match
		mov	dx,bx			; dx -> matching notation
						;  counterpart
		int	21h			; print it (ah=9)
		dec	bp
			; make jp below not jump (both -2 and -3 are of odd
			;  parity). ax is modified and who knows what is at
			;  924h, a second match is possible
SkipPrinting:
		xchg	di,bx			; swap notation pointers
		dec	bp			; modify pf
		jp	CompareNotations	; jumps once to check the
						;  roman notation
		popa				; restore registers
		loop	PreviousNumber		; loop for all numbers that
						;  are less than 4000
		jmp	ReadNextLine		; line proceeded, read next
		endp	Main
                end     Main