	org 100h

; 153 first version
; 149 cool AAM trick in decimal-to-roman
; 148 use AND to reset SI to 100h
; 146 use DOS function to mask the value of a roman digit
; 165 trap all the errors
; 164 misc. redisorganization of I/O
; 161 use a single CMP to detect 10-1 or 5-1
; 159 after dumping requirement on leading spaces
; 157 use a single TEST to distinguish roman/letter/end
; 154 reinitialize CX to 111d after subtracting, instead of rotating it
; 149 removed loop to skip leading zeros
; 144 use a single CMP to detect valid subtractions
; 142 keep CX=0 throughout the program (first version submitted)
; 141 use two XCHG's to put buffer address in DX
; 141 fix bug (IVI incorrectly considered valid) by clever use of PF/OF

	db 0dh, 0ah, 24h		; or ax, 0d0ah

%ifdef DEBUG
	mov si, 100h
%endif

print:
	xchg si, ax		; Pointer to data in AX
	sahf			; If SI >= 100h, set CF
	xchg dx, ax		; Pointer to data in DX
	jc begin		; If SI >= 100h, don't print anything
	mov ah, 9		; Print string up to $
	int 21h

begin:
	xor sp, sp
	mov cl, 80h		; Make a workspace at 80h to 100h
	mov di, cx
	mov al, 30h		; made of zeros.  And make the first
	rep stosb		; pushed byte a 30h
	mov si, di		; SI points to the workspace
	
accept:
	mov ah, 7		; Input w/o echo
	push ax
int21:
	int 21h
	cbw			; AH = 0
	cmp al, 1ah		; On EOF, exit
	je int21		; (with function 0! see HC15 entry by claw)
	sub al, '0'		; If above zero, 
	jae accept		; consider character valid
	jpo begin		; skip LFs (DAh has odd parity, DDh even)

	mov di, r2d_tab		; Point DI to transliteration table
	
scan2:
	mov bx, 111dh		; BX = roman value table (bit 3 = new digit)
scan:
	pop ax			; Load a character in reverse order
	test al, 30h		; 10h/20h = letter, 30h = flag, 0h = digit
	jz d2r
	jpe print

	cmp [di-3], al		; Is it a digit greater than the current one?
	jne seek		; If not, sum
	cmp byte [si], 0b2h	; Is it a three or four?
	jpe seek		; If so, we are not subtracting (XXXIX)
	jo four		; Check if we are subtracting from 5

	mov word [si],3a30h	; Change last digits to 09 (considering the
	inc si				; decrement below)
	dec di			; Allow all the three possible occurrences
					; of the 2nd digit (e.g. X for XXXIX)
four:
	dec byte [si]		; Subtract one
	jmp short scan2		; and reset CX (effectively, go back 1 nibble)

seek:
	ror bx, 4		; Pass to next nibble
	sbb si, cx		; Decrease SI every 4 iterations (CX=0)
	scasb			; Compare with the table
	jo begin		; Bad value? Restart
	jne seek		; Else, if not this one, loop
	and ah, bl		; Get digit value in AH
	add [si], ah		; Sum digit to current decimal value
	jmp short scan
	
d2r:
	scasw			; Advance DI by 4
	scasw
	jns begin			; Check for 10000+
	mov bx, d2r_tab		; Setup BX for XLATB
	xlatb			; Chars to print in AL
	lea bx, [di-3]		; Setup BX for another XLATB
digit:
	aam 4		; Low 2 bits in AL, others in AH
	jz scan			; If a zero was placed in AL, leave
	xlatb			; Convert to ASCII-'0'
	dec si			; And store
	add [si],al
	js begin			; Check for 4000-9999
	mov al, ah		; Move high 6 bits back into AL
	jmp short digit

r2d_tab:
	db 'I'-'0', 'I'-'0', 'I'-'0', 'V'-'0'
	db 'X'-'0', 'X'-'0', 'X'-'0', 'L'-'0'
	db 'C'-'0', 'C'-'0', 'C'-'0', 'D'-'0'
	db 'M'-'0', 'M'-'0', 'M'-'0'

	; ----------- next byte must be 80h <= x <= 92h to overflow on 'C'-'0'
	; the first three also must have the sign bit set to check for >=4000
	
d2r_tab:
	db 10000000b		; high bit set, nothing printed
	db 10000001b		; high bit set, I printed
	db 10000101b		; high bit set, II printed
	db 00010101b		; III
	db 00000110b		; IV
	db 00000010b		; V
	db 00001001b		; VI
	db 00100101b		; VII
	db 10010101b		; VIII
	db 00000111b		; IX
