;*** Messy entry for HC18 by Ruud
;
;    Let's see what more bytes we can eat
;    Usual credits (Thanx Ben for running this compo)
;

                    .MODEL    TINY
                    .386
                    LOCALS

                    .CODE
                    ORG       100h

Start:              xchg      ax,cx               ;CX=0 1 byte before CRLF
                    or        ax,240ah            ;0d, 0a, 24
                    mov       ah,8
                    
                    db        0bfh                ;mov di,0fc61h
MainLoop:           popa                          ;61h
                    cld                           ;0fch
                    
                    pusha    ;di=0fc61h, si=100h, cx=0, ax=24ffh, bp=9xx
                    
GetCh:              stosb                         ;First byte stored is 0ffh
                    cmp       al,1ah              ;Check EOF
                    je        _RET                ;>> AH=0, INT 21h
                    int       21h                 ;Getch
                    jnc       GetCh               ;Last char stored is 0dh

                    std                           ;From now on DOWN
                    stosw                         ;DI-=2
                    mov       bx,offset tab2-1    ;Pointer to tables
                    xchg      si,di               ;SI=SOURCE, DI=DEST

NextSrc:            push      si
                    lodsb
                    test      al,20h
                    jne       HaveDecimal
                    mov       cl,3ah
TryNextDec:         mov       al,cl
                    das                           ;Order to try : 49876543210
                    pop       si
                    push      si
                    dec       cx
                    stosb                         ;Stuff assumed dec digit
HaveDecimal:        sub       al,bl
                    add       al,low offset tab1-30h  ;Sets CF
NextRomDig:         xlatb
                    jc        GetTblOff           ;First time jump
                    
                    jcxz      StuffRom            ;>> just stuff, no compare
                    inc       di
                    xor       al,[si]
                    jne       TryNextDec
                    cmpsb
                    db        0a8h                ;Skip the stosb

StuffRom:           stosb
                    mov       al,ah
GetTblOff:          aam       4
                    jne       NextRomDig
                    pop       dx                  ;Last value of si
                              
                    inc       bx
                    inc       bx
                    sahf                          ;CF for 0,4 or 9
                    xlatb
                    sbb       al,24h
                    jb        MainLoop            ;Number too large
                    cmp       ah,[si]             ;AH=9 for last char = '0'
                    jl        NextSrc             ;Loop if not past input
                    jpo       _OUT                ;No jump if input was '0'

                    ; tab2: with si=0fc61 gives ah=42h -> fseek -> do nothing
                    ; _RET: with ah=8     gives ah=00h -> terminate program
                    ; _OUT: with ah=?     gives ah=09h -> output valid

;   49h,56h,58h,4ch,43h,44h,4dh

tab2:               db        'IVXLCDM'
tab1:               db        24h  ; xxxxxc00B    ; '$' :-)        +CF
                    db        01h  ; xxxc0001B    ;   I
                    db        05h  ; xc000101B    ;  II
                    db        15h  ; 00010101B    ; III
                    db        46h  ; xc000110B    ;  IV            +CF
                    db       0f2h  ; xxxc0010B    ;   V Tune code  +CF
                    db        49h  ; xc001001B    ;  VI            +CF
_RET:               db        25h  ; 00100101B    ; VII and ax,4795h
_OUT:               db        95h  ; 10010101B    ;VIII xchg ax,bp
                    db        47h  ; xc000111B    ;  IX inc di     +CF

                    mov       dx,di
                    int       21h
                    jmp short MainLoop

                    END       Start

