.model tiny
.code
.486

letters_offset	equ	64h		;offset letters-offset start+1

	org	100h

	;assume ax=0000, bx=0000, cx = 00xx, si = 0100, bp=09xx

start:
	db      13,10,'$'       	;or	ax,240Ah
					;read string to code 10
	mov	ah, 7			;Read a key thru DOS
	mov	di,bp
	cwd				;dx=0
read_key:
	int	21h
	stosb
	inc	dx
	
	cmp	al, 26			;Exit on EOF
	je	short return
	cmp	al, 10
	jne	short read_key

;----------------------------------------------------------
;for every number from 3999 to 1
	xchg	ax,di			;di=070Ah, ax=0Fxxh
	mov	ax,0F9Fh		;ax=0F9Fh=3999
loop_n:
	pusha

	movsw			;move first word
	std
	movsw			;move second word

	push	dx		;length of input string

;----------------------------------------------------------
;make decimal and roman numbers
num_loop:
	cwd
	mov	cl,10		;cx<100h
	div	cx
	xchg	ax,dx

	add	al,30h		;make decimal number
	cmpsb			;si--,di--
	mov	[si],al

	sub	al,30h-1
	aam	5		;zf=1 for 4,9
	rcr	ah,1		;cf=1 for 4,5,6,7,8
	mov	cl,al
	mov	ax,word ptr [si+letters_offset+2]	;XI
	xchg	al,ah
	jnc	short m1
	mov	ah,byte ptr [si+letters_offset+6]	;V
m1:
	rep	stosb		;I*n	n=0..4
	jne	short m2
	clc
	dec	di
	stosw
m2:
	stosw
	sbb	di,-4		;di+=4-cf

	xchg	ax,dx
	sub	ax,bx		;bx=0
return	equ	$-1		;last code = 2B C3
	jne	short num_loop
				;ax=0
;----------------------------------------------------------
;compare numbers with input string
	pop	cx
	cld

	xchg	ax,di
next_compare:
	pusha
	xchg	ax,dx
	mov	di,bp
	repe	cmpsb
	jne	short not_print

	xchg	ax,bp			;ah=9	print string
	int	21h
not_print:
	popa
	xchg	ax,si
	dec	di
	jp	short next_compare	;one time when al=FF
	
	popa
	dec	ax
	jne	short loop_n
	jmp	short start

letters	db	'M','C','X','I','D','L','V'

	end	start