	org	100h

; ---------------------- Read a line and dispatch to the correct routine ------

input:
	mov	si, copy_tabs	; Rewrite overwritten data
	mov	di, convert_tab
	mov	cx, di
	sub	cx, si
	rep	movsb

	mov	di, 80h			; Point to start of the line buffer
	
read_key:
	mov	ah, 7			; Read a key thru DOS
	int	21h
	
	cmp	al, 10			; Skip the LF characters
	je	read_key
	cmp	al, 26			; Exit on EOF
	jne	not_eof
	int	20h
not_eof:

	stosb				; Store a character
	cmp	al, 13
	jne	read_key		; And go on if it is not a CR
	
	mov	si, 80h			; point SI to the line we read
	xor	cx, cx			; CX = accumulator
	
	; The string is built in reverse order on the stack, so we create
	; the end (cr,lf,0) here
	
	push	byte 0
	push	byte 10
	push	byte 13
	mov	bp, sp			; to check whether digits were output
	
start:
	lodsb
	cmp	al, '0'			; accept numbers
	jb	input
	cmp	al, '9'			; by jumping to d2r
	jbe	d2r
	
	cmp	al, 'A'			; accept alphanumeric
	jbe	input
	cmp	al, 'Z'			; else leave
	ja	input
	
; ---------------------- Roman to decimal conversion --------------------------

r2d:
	mov	bx, valid_tab-1
	
r2d_loop:
	mov	ah, [si]		; look ahead the next character
seek_valid:
	inc	bx			; find whether the character we're
	cmp	byte [bx], 0		; under is a valid one
	je	input
	cmp	[bx], al
	jnz	seek_valid
	
	mov	di, roman_tab		; if so, look it up in the table of
seek_data:				; roman digits
	cmp	[di], al
	je	found
	add	di, byte 5		; 5 is the size of each entry
	jmp	short seek_data

found:
	mov	dx, [di+1]		; load chars we can subtract for
	mov	word [di+1], 0		; Cannot subtract anymore (for IVI)
	mov	word [di+6], 0		; Cannot subtract anymore (for VIV)
	cmp	dl, ah			; check if we are subtracting
	je	subtr
	cmp	dh, ah
	je	subtr

	add	cx, [di+3]		; Not subtracting, add to accumulator
	jmp	short next_char		; and go on
	
subtr:
	mov	[bx], ah		; Subtracting, remove all remaining
	inc	bx			; occurrences of the current character
	cmp	[bx], al		; in valid_tab with the lookahead char
	je	subtr

	dec	bx			; and point to the last one
	dec	bx
	sub	cx, [di+3]		; and subtract from the accumulator

next_char:
	lodsb				; load a character
	cmp	al, 13			; if a CR,
	je	output_10		; output CX in base 10
	cmp	al, 'A'			; if not a letter,
	jb	near input		; error
	cmp	al, 'Z'
	ja	near input
	jmp	short r2d_loop		; else go on

; ---------------------- Convert CX to base-10 --------------------------------


output_10:
	mov	bx, 10			; radix in BX
	mov	ax, cx			; decimal value in AX
out10_loop:
	cwd				; divide AX by 10
	div	bx
	add	dl, '0'			; the remainder is a digit
	push	dx			; push it on the stack
	or	ax, ax
	jnz	out10_loop

; ---------------------- Printing loop common to both conversions -------------


print_loop:
	cmp	sp, bp			; If no digits were output
	je	near input		; it's an error

print_loop2:
	pop	dx			; pop a character
	or	dx, dx			; if NUL, we're done
	jz	near input
	mov	ah, 2			; else print it
	int	21h
	jmp	short print_loop2
	
; ---------------------- Decimal to roman conversion --------------------------


d2r:
	inc	cx			; count number of characters
	cmp	cx, 5			; if string too long to be < 4000, exit
	jae	near input

	lodsb
	cmp	al, 13
	je	do_d2r
	cmp	al, '0'			; in the meanwhile check their validity
	jb	near input
	cmp	al, '9'
	ja	near input
	jmp	short d2r

do_d2r:
	mov	bx, units_roman_tab	; point BX to table of roman digits
	dec	si
d2r_loop:
	dec	si			; now load the character backwards
	mov	al, [si]
	sub	al, '0'			; convert ASCII->decimal
	mov	di, convert_tab-1
	
out_digit:
	inc	di			; look the digit up in the table of
	or	al, al			; decimal->roman conversion
	jz	out_roman
	cmp	byte [di], -1		; each entry is separated from the next
	jne	out_digit		; by a -1 byte
	dec	al			; if we found it, next version
	jmp	short out_digit
	
	; When we come here BX points to an entry in the roman digit table
	; whose three characters are the units, fifths and tenths for the
	; current digits: respectively, I/V/X, X/L/C, C/D/M
	
out_roman:
	mov	al, [di]		; load a digit from the table
	cmp	al, -1			; go on until we reach the end
	je	next_digit
	xlatb				; convert units/fifths/tenths to roman
	cmp	al, 0			; if loaded a zero, it is an error
	je	near input		; (number is too big)
	push	ax			; push a roman digit
	inc	di
	jmp	short out_roman

next_digit:
	sub	bx, byte 10		; next digit, next entry in the table
	loop	d2r_loop		; do for all the characters in the
					; command line
					
	jmp	short print_loop	; then go print the output

; ---------------------- A copy of the conversion tables -----------------------
	
copy_tabs:
	
	db	-1
	db	0,-1			; I
	db	0,0,-1			; II
	db	0,0,0,-1		; III
	db	1,0,-1			; IV (in reverse order! also below)
	db	1,-1			; V
	db	0,1,-1			; VI
	db	0,0,1,-1		; VII
	db	0,0,0,1,-1		; VIII
	db	2,0,-1			; IX

copy_valid_tab:
	db	'MMMDCCCLXXXVIII', 0

copy_roman_tab:
	db	0,0,0
	dw	10000
	
	db	0,0,0			; these are dummy entries
	dw	5000

	db	'M', 0,0
	dw	1000
	
	db	'D', 0,0
	dw	500
	
	db	'C', 'DM'
	dw	100
	
	db	'L', 0,0
	dw	50
	
	db	'X', 'LC'		; etc.
	dw	10
	
	db	'V', 0,0		; V cannot be subtracted
	dw	5			; and its value is 5
	
copy_units_roman_tab:
	db	'I', 'VX'		; I can be subtracted from V or X
	dw	1			; and its value is 1

	db	0,0,0
	dw	0

; ---------------------- Conversion tables ------------------------------------

convert_tab	equ $
valid_tab		equ $ + copy_valid_tab - copy_tabs
roman_tab		equ $ + copy_roman_tab - copy_tabs
units_roman_tab	equ $ + copy_units_roman_tab - copy_tabs
