;---------------------------------------------------------------------
;	ENTRY.ASM
;
;Albe, -=Quequero=- and Spider's contribution to Hugi Competition # 19
;
;Assemble with: nasm -o entry.com entry.asm
;---------------------------------------------------------------------

	org	0x100
	
	SECTION	.text
	BITS	16

main:
	mov	al,0x13
	int	0x10

	mov	dx,0x5c		;open first fcb
	mov	ah,0x0f
	int	0x21

	xchg	di,ax		;DI=0x0F00 = array where to store the points informations
	mov	si,0x301	;SI=how many times we must write palette

	xor	bp,bp		;set PF=0 (and we also need BP=0) (BP = maxdist)

.read_again:
	jnp	short .another_digit ;if PF=1, we've just read a 0x1A or 0x0A byte from the file

	xchg	bx,ax		;put the number read from file in AX

	stosb			;store the number in the array
	dec	si		;if SI is signed, we must not set any palette value (we've already set the whole palette)
	js	short .nopalette

	push	dx		;save DX=0x5C for further fcb reading function
	adc	dx,(0x3c8-0x5c)	;first time, we are here with CF=0 (because of the "xor bp,bp");
	out	dx,al		;other times, we are here with CF=1 (because of the "sub al,0x30")
	pop	dx

.nopalette:
	mov	bx,0x140	;we'll need BX=320 for the "div bx" in drawing loop. But setting it here
				;is ok (instead of a "xor bx,bx");

	mov	byte [bp+0x5c+0x0e],bh	;set fcb record size to 1 byte

.another_digit:
	mov	ah,0x14		;read from file
	int	0x21

	daa			;set PF if AL=0, clear it if AL=1
	jnp	short .no_more_numbers

	mov	al,byte [0x80]	;take byte read

	sub	al,0x30		;ascii-to-bin conversion, and also check for 0x20, 0x0D, 0x0A and 0x1A
	jb	short .read_again

	mov	ah,bl		;BL contains the previous number
	aad	10		;AL=(AH*10)+AL

	xchg	bx,ax		;put the number in BX
	jmp	short .another_digit

.no_more_numbers:
	xchg	cx,ax		;set AX=0x00FF
	stosw			;store it as a marker of end of the buffer...and we'll also need 0x00FF
				;for the division in the drawing loop

	push	word 0xa000
	pop	es


draw:
	mov	si,points+0x300+1	;SI contains the starting address of the points coordinates
					;(skip the first 0x301 bytes, because they're palette bytes)

	mov	ch,0x7f		;CX contains mindist

points_loop:
	cwd			;AX here is always positive (at most, it is 0x7Cnn)
	mov	ax,di

	div	bx		;calculate x and y of current pixel
				;DX=x, AX=y
	mov	ah,dl
	xchg	dx,ax		;DL=y, DH=x

	lodsw			;take point's coordinate (AL=x, AH=y)
	cmp	al,0xfe		;if AL=0xFF, where're at the end of the buffer (0x00FF is our marker for the end of the buffer)
				;we need to set the CF here...(see below)
	ja	short points_loop_done

	sub	al,dh		;AL=dx=(x2-x1)
	sub	dl,ah		;DL=dy=(y2-y1)

.distance2:
	test	al, 192		;Thx Bonz! This trick "normalizes" the dx (or dy)
	jp	short .below
	xor	al, 128

.below:
	imul	al		;dx=dx*dx (or dy=dy*dy)
	xchg	dx,ax		;swap between dx and dy

	xor	bl,bh		;trick to execute "distance2" twice: here we have BX=0x140...
	jp	short .distance2

        add	ax,dx		;distance^2 in AX

	cmp	ax,cx		;mindist check
	ja	short points_loop

points_loop_done:
	xchg    cx,ax
	jbe	short points_loop ;if CF=0, we're here from the "cmp ax,cx", and we must loop again
				  ;if CF=1, we're here from the "cmp al,0xfe" / "ja ..." and the loop is done

	cmp	ax,bp		;maxdist check
	jb	short da_below
	xchg	bp,ax


da_below:
	mul	cx		;CX=0x00ff
	div	bp		;bp=maxdist

inverted_color:
	not	cl		;not cl / not al (depends on the last bit of the opcode...we xor it with 1
				;before the int 16h)
	stosb			;put AL in video memory

	test	di,di
	jnz	short draw


	dec	sp		;we need to do the drawing loop twice...the first time, maxdist
	jnp	short draw	;is not a correct value.
	pop	dx		;

	db	0x30,0x7f	;xor byte [bx+(inverted_color-0x140+1],bh
				;Nasm doesn't allow us to use labels as imm8 values...so we need
				;to write the opcode manually
	
	dw	(inverted_color-0x140+1)+(0xCD*0x100)
	db	0x16		;int 0x16 (0xCD 0x16)
				;(AH is zero from the DIV)

	cmp	al,0x20		;spacebar check
	je	short draw


	mov	ax,3		;text mode
	int	0x10
	ret

;----------------------------------------------------------

points	equ	0x0F00
