; Texture generator by Aphex
; Hugi 19 competition entry
; compile: 	tasm /m entry
;		tlink /t/x entry

p286
model tiny
codeseg
startupcode

; maximum input file size is: 256*13+500*9+1=7829 

; it assumes dx = cs > 182h

start:
	push	cx
fileio:
	sbb	cl, [bx]		; dummy
	daa				; dummy
	add	ds:word ptr[0A000h], ax	; dummy
					; the three lines above stand for
					; 1A, 0F, 17, 01, 06, 00, A0

	mov	al, 13h			; ah = 0, 9, 1Ah
					; 1st time init video
					; 2nd time write a char with color 0
					; 3rd time nothing (fct 13 is not impl)
	int	10h                     ; set video mode

	lodsw				; ah = 1Ah, 0Fh, 27h
	int	21h			; execute DOS fct
	mov	dx, 5Ch			
	dec	si

	xchg	bp, ax			; assures al = 0 upon exit
					; and a good value for bp
	jnp	fileio                  ; for 3 times

	inc	bx
	les	cx, [bx+si]		; load es with video seg, cx with 601h
	mov	si, cs			; si -> file buffer

	mov	dx, 3C8h		; dx -> palette index port
outp:
	out	dx, al
	or	dx, bx
	loop	readch

	pop	ax			; ax = 0FFh
	xchg	bx, ax			; xchg
drawinit:
	mov	[bx], ax		; first time load max with 1
					; next times, adjust max
	sub	di, di

draw:
	push	si			; save buffer offset

	                                ; first time bp will be 270x
					; next times bp will be EA00
					; both values > 2000h which is max
dist0:
	xor	dx, dx			; due to EA00, can't use cwd
						
	mov	ax, di			; get video offset

	div 	word ptr[bx+offset c140-255]
					; div by 140
	org	$-3
	db	77h			; short delta correction
	org	$+1

					; ax = y, dx = x

dist:
	push	ax			; save y

	mov	cl, 1			; annihilate next loop
readch:
	xor	ax, ax			; number = 0
readdig:
	aad	0Ah			; mul number by 10
	xchg	al, ah			; number in ah
	lodsb				; read next digit
	sub	al, 0Ah			
	jz	readdig                 ; reject 0A
	sub	al, 26h			; character -> digit
	jns	readdig

	xchg	al, ah                  ; number in al, al in ah	
	loop	outp

	mov	cl, 3			; for three times	
	jnp	eof			; EOF ? 

calc:
					; this loop doesn't need dl % 128!!
	sub	al, dl			
	jns	$+4
	neg	al
					; al = |al-dl|
	mov	dx, 140h
	org	$-2
c140:
	org	$+2

	loop	calc			; after loop al = |||al-dl|-64|-64|
					; max al value = 64
					; that means max dist can be
					; 64 * 64 * 2 = 2000h

	sahf				; hex | PF
					; F0 |  0
					; DD |  1

	imul	al			; al = al ^ 2
	pop	dx			; next loop will be done for y

	jnp	dist

	add	ax, dx			; ax = dist

	cmp	bp, ax
	jc	dist0
eof:      		
	xchg	bp, ax			; set min or get mindist in ax
	jnc	dist0

	pop	si 			; adjust stack
	pop	si			; reset buffer offset

	cmp	[bx], ax		; if another max is found then redraw
	jc	drawinit

	mul	bx                      ; ax *= 255
	div	word ptr[bx]		; ax /= maxdist
					
modeop:
	or	dl, al			; mode: dummy or invert
	
	stosb				; write pixel

	or	di, di			; until di = 0
	jnz	draw

	neg 	byte ptr[bx+offset modeop-255]
					; toggle mode
	org	$-3
	db	5Fh			; short delta correction
	org	$+1

					; ah = 0 after div
	int	16h                     ; wait a keystroke

	cmp	al, 20h	
	jz	draw			; if space then redraw
	xchg	cx, ax			
	int	10h                     ; restore text mode
					
	ret				; exit 

end start