; HugiCompo 19 entry by Beeblebrox / TMA
; Cellular texture generation (138 bytes)
; Run: entry points.txt
.286
.model tiny
.code
                org     100h
start:          std
                mov     al,13h
                int     10h
                mov     dx,5Ch          ; first FCB
                mov     ah,0Fh
                int     21h             ; FCB open file
                mov     [bx+69h],si     ; record size <- 1
                mov     si,bp           ; 09xxh=offset palette
        ; convert decimal numbers to bytes
readchar0:      xor     ax,ax
readchar:       aad                     ; al <- ah*10 + al
                mov     [bp],al
                xchg    ax,cx           ; cl <- al
                mov     ah,14h
                int     21h             ; FCB read one byte to [80h]
                mov     ah,cl
                mov     al,ds:[80h]
                sub     al,'0'
                jnc     readchar        ; one of the 0Dh,0Ah,20h or 1Ah?
                jpo     skip_writing    ; write only after Space or Cr
                dec     bp
skip_writing:   sub     al,0EAh         ; EOF found? (1Ah-30h)
                jne     readchar0
                mov     ah,0A0h
                mov     es,ax
        ; set palette
                mov     ch,3
                mov     dx,3C8h
                out     dx,al
                inc     dx
                rep     outsb           ; now si = offset points
        ; Display the texture
                inc     bx              ; amplitude := 1
                inc     di              ; screen address=320*1024-65536*5-1
redraw:         mov     ch,4            ; y=1024...1
y_loop:         mov     ax,320          ; x=320...1
x_loop:         push    ax si           ; si=offset points
        ; Find the closest point to (x,y)
                mov     dx,sp           ; mindist = +infinity
find_min:       push    ax cx
        ; Compute the "wraped" distance^2 between two points
delta2:         dec     ax
                sub     al,[si]
                dec     si
                shl     al,1            ; copy bit 6 to bit 7 (sign)
                sar     al,1            ; now range is -40h...40h
                imul    al              ; signed mul! Range is 0...4096
                xchg    cx,ax           ; ax <- y, keep (x1-x2)^2 in cx
                neg     bx              ; amplitude < 8192, so
                js      delta2          ; do exactly 2 times
                add     ax,cx
                cmp     ax,dx           ; put mindist in dx
                jae     not_min_dist
                xchg    dx,ax
not_min_dist:   pop     cx ax
                cmp     si,bp
                jne     find_min
                cmp     dx,bx           ; Put max(mindist) in amplitude (bx)
                jbe     not_max
                mov     bx,dx
not_max:        mov     ax,255
                mul     dx              ; 255*distance^2
                div     bx              ; Color=255*distance^2/amplitude
        ; Color (version 1) or 255-Color (version 2)
versn           db      0Ah,0D0h        ; or dl,al <-> not al
                stosb                   ; put pixel
                pop     si ax           ; si=offset points
                dec     ax
                jnz     x_loop
                loop    y_loop

                neg     byte ptr versn  ; not al <-> or dl,al
                int     16h
                cmp     al,20h          ; If <space> is pressed switch
                jz      redraw          ; between version1 and version2
	
                mov     ax,3            ; Any other key: return to dos
                int     10h
                retn

                end     start
