;----------------------------------------------------------------------------;
;									     ;
;		entry for hugi compo #19 - 129 bytes total		     ;
;		 by boiled brain (pogonyshev@tut.by, belarus)		     ;
;									     ;
;      compile: tasm /m2 entry.asm					     ;
;     and link: tlink /t entry.obj					     ;
;----------------------------------------------------------------------------;

;		some comments
;
;  this entry reads all the numbers from an input file	and stores them one
;  after another in memory.  this gives  300h  consecutive bytes of palette
;  and	a buffer  containing  pairs  of coordinates  of controlling points.
;  since each number in a valid input file fits into a byte, we can use aad
;  command safely.
;
;  it doesn't tile the texture,  instead it draws the whole screen at once.
;  if it discovers a new square distance larger than current known maximum,
;  it updates the maximum  and resets the counter of drawn pixels (cx).  it
;  stops after having drawn 64k of pixels without discovering new maximums.
;
;  it always deals  with quadrupled square distances.  they fit into a word
;  perfectly and we divide them, so no problems for that.
;
;  the entry can handle files with about  30000 points in them	(estimated,
;  never tried).

		ideal
		p386
		model	tiny
		codeseg
		org	100h
;----------------------------------------------------------------------------;
;		main procedure (program entry point)			     ;
;  assumptions: ah=00h, bx=0000h, cx=00FFh, df=0			     ;
;----------------------------------------------------------------------------;
		proc	Main
		;; video initialization - 8 bytes ;;
		mov	al,13h
		int	10h			; switch to mode 320x200x256
		push	0A000h
		pop	es			; es -> video memory
		;; reading input file - 42 bytes ;;
		mov	ah,0Fh
		mov	dx,5Ch			; open the input file
		int	21h			;  using FCB
		rol	[byte bx+5Ch+0Eh],1	; set record size to 1 byte
		xchg	ax,bx			; bx=0F00h, ah=al=0
		mov	si,bx			; si=0F00h, buffer to save
						;  ipnut values at
		push	cx			; cx=255, keep it on stack
						;  for a while
AnotherDigit:
		aad				; append digit from al to the
						;  number
		xchg	ax,cx			; save the number in cl
ReadNextChar:
		mov	ah,14h
		int	21h			; read one byte from the file
		mov	ah,cl			; ah=number being read (for
						;  digit appending)
		mov	al,[80h]		; al=byte read
		sub	al,'0'			; normalize digit
		jae	AnotherDigit		; if it was really a digit,
						;  append it
		xor	al,1Ah-'0'		; modify flags:
						;    byte      pf    zf
						;     0Ah	1     0
						;     0Dh	0     0
						;     1Ah	1     1
						;     20h	0     0
		jp	SkipThisChar		; write numbers only after
						;  spaces and CRs
		mov	[bx],cl 		; save number read
		inc	bx			; move pointer
		mov	cx,300h 		; start from zero next time.
						;  also used in palette
						;  setting
SkipThisChar:
		jnz	ReadNextChar		; if not EOF, keep reading
		;; setting palette - 8 bytes ;;
		mov	dx,3C8h 		; palette write address
						;  register
		out	dx,al			; al=0, start with first
						;  palette entry
		inc	dx			; dx=3C9h, palette data
						;  register
		rep	outsb			; set the palette (cx=300h).
						;  si -> point coordinates
		inc	ax			; initial maximal distance.
						;  ax=1 to avoid division by
						;  zero
		;; creating and drawing texture - 53 bytes ;;
		pop	[word bx]		; pops 255. used for
						;  multiplication
NewMaximalDistance:
		xor	cx,cx			; reset drawn pixels counter.
		xchg	ax,bp			; bp keeps maximal distance
NextPixel:
		push	si			; save point coordinates
						;  pointer
		push	es			; minimal distance for current
						;  pixel. set to something
						;  large initially (0A000h)
NextPoint:
		mov	ax,320
		cwd				; dx=0 for division
		push	di			; save current pixel address
		xchg	ax,di			; ax=pixel address, di=320
		div	di			; ax=y coordinate,
						;  dx=x coordinate
NextCoordinate:
		xchg	ax,dx			; swap coordinates
		sub	al,[si] 		; al=distance to point
		add	al,al			; now al is double wrapped
						;  distance
		imul	al			; quadrupled square of wrapped
						;  distance
		inc	si			; next coordinate
		dec	di			; di: 320 -> 319 -> 318
		jp	NextCoordinate		; loop once (two coordinates)
		pop	di			; restore current pixel
						;  address
		add	ax,dx			; add two distance components
		pop	dx			; current minimal distance
		cmp	dx,ax			; is distance to the current
						;  point smaller?
		jbe	KeepMinimalDistance	; no - drop it
		xchg	ax,dx			; set new minimal distance
KeepMinimalDistance:
		push	dx			; save back on stack
		cmp	si,bx			; any more points there?
		jne	NextPoint		; keep working then
		pop	ax			; ax=minimal distance to a
						;  controlling point
		pop	si			; restore point coordinates
						;  pointer
		cmp	bp,ax			; have we found a new maximum
						;  on this pixel?
		jb	NewMaximalDistance	; then save the maximum and
						;  reset the counter
		mul	[word bx]		; calculate the color of the
		div	bp			;  current pixel ([bx]=255)
		stosb				; and save it
		loop	NextPixel		; loop until we have drawn
						;  64k of pixels consequently
		;; inverting texture and shutting down - 18 bytes ;;
WaitForKeypress:
		int	16h			; read a key (ah=0)
InvertTexture:
		not	[byte es:di]		; invert a pixel
		inc	di
		loop	InvertTexture		; invert the whole screen
		cmp	al,' '			; was it space?
		mov	ax,3
		je	WaitForKeypress 	; then keep reading keys
		int	10h			; otherwise, restore text mode
		ret				;  and quit
		endp	Main
                end     Main