;Entry in Hugi Size Compo #19
;Copyright 2002 GreenGhost
;
;Compile: nasm -f bin -o entry.com entry.asm
;Run: entry points.txt

org 100h

Main:

;mov ax,0
;mov bx,0
;mov cx,00FFh
;mov si,0100h

shr si,1		;2	si=80h
lodsb			;1	get length
xchg bx,ax		;1	bx=len, ax=0
mov [si+bx],al		;2	zero terminate cmd line

mov al,13h		;2	func 0=setmode, al=mode 13h
int 10h			;2

inc si			;1	skip space
mov dx,si		;2	dx->filename

mov ax,3d00h		;3	func 3dh=open
int 21h			;2
xchg bx,ax		;1	file handle in bx

mov si,Buffer		;3

mov ah,3fh		;2	func 3fh=read
not cx			;2	size>7061
mov dx,si		;2
int 21h			;2

mov cx,256*3		;3
mov dx,3c8h		;3
xor al,al		;2
out dx,al		;1
inc dx			;1
.NextPal:
  call ReadNum		;3
  out dx,al		;1
loop .NextPal		;2

mov bp,0a000h		;3	invert=lo(bp)=0
push bp			;1	set screen segment
pop es			;1

inc cx			;1	maxdist=1

call Draw		;3	calculate maxdist

.Redraw:

  call Draw		;3	draw
  not bp		;2

  xor ax,ax		;2	func 0=readkey
  int 16h		;2
  cmp al,20h		;2	space?
jz .Redraw		;2

mov ax,3		;3	text mode
int 10h			;2
ret			;1	quit

Draw:
  xor di,di		;2
  .NextPixel:

    push di		;1

    mov ax,7F7Fh	;3	mindist>8192
    cwd			;2	dx=0
    xchg ax,di		;1
    mov bx,320		;3
    div bx		;2	dl=x
    mov dh,al		;2	dh=y
    and dx,di		;2	mask x,y to 0-127

    push si		;1	save points start
    .FindMin:

      call ReadNum	;3	get x
      jz .LastPoint	;2
      call WarpCoord	;3
      xchg ax,bx	;1
      call ReadNum	;3	get y
      call WarpCoord	;3
      add ax,bx		;2	dx*dx+dy*dy

      cmp ax,di		;2	dist<mindist
      ja $+3		;2
        xchg ax,di	;1	mindist=dist
    jmp .FindMin	;2
    .LastPoint:
    pop si		;1	restore points start

    cmp di,cx		;2	if (dist>maxdist) maxdist=dist
    jb $+4		;2
      mov cx,di		;2

    mov ax,255		;3	255*dist
    mul di		;2
    div cx		;2	/maxdist

    pop di		;1

    xor ax,bp		;2	invert?
    stosb		;1	draw pixel

    cmp di,320*200	;4
  jne .NextPixel	;2
ret

WarpCoord:
  sub al,dl	;2	d=abs(c1-c2)
  jns $+4	;2
    neg al	;2
  cmp al,64	;2	if (d>64) d=128-d
  jna $+6	;2
    sub al,128	;2
    neg al	;2
  mul al	;2	d*=d
  xchg dh,dl	;2	swap x2,y2
ret

ReadNum:
  xor ax,ax		;2	num=0
  .NextChar:
    aad			;2	ah*10+al
    mov ah,al		;2
    lodsb		;1	get char
    sub al,30h		;2
  jae .NextChar		;2
  cmp al,0EAh		;2
  jae $+3		;2	space/EOF (EOF sets zf)
    inc si		;1	CR: skip LF
  mov al,ah		;2	result in al
ret			;1

Buffer:

.end
