;-----------------------------------------------------------------------;
;                                                                       ;
; Entry for HUGI size coding competition #19 - a cellular text          ;
;  generator								;
; To compile with MASM: ml entry.asm                                    ;
;                                                                       ;
; By Jeff (USA)                                                         ;
;                                                                       ;
;-----------------------------------------------------------------------;
		.MODEL 	tiny
		.CODE
		.386
		.STARTUP

; Set screen mode
		mov	al, 13h		; ah = 0 at startup
		int	10h


; Open input file using FCBs
		mov	dh, 0fh		; DTA = 0fxx
		mov	si, dx
		mov	ax, 1a5ch
		int	21h		; Set DTA
		cbw
		xchg	ax, dx
		int	21h		; Open FCB
		mov	ah, 27h
		int	21h		; Read in 32,640 bytes (cx = 00ffh)


; Convert ASCII numbers
		mov	bh, 9dh		; Buffer starts at 9d00h
		push	bx
		dec	bx
retnum:
		inc	bx
		xor	ax, ax
		mov	dx, 3c8h
		out	dx, al		; Start palette at 0
validdigit:
		aad
		mov	ah, al
nextchar:
		lodsb
		sub	al, '0'
		jnc	validdigit
		mov	[bx], ah		; advantage: at end, [bx]
		jpe	retnum			;  contains a zero byte!
		add	al, '0' - 1ah + 3
		jnc	nextchar
		pop	si			; Here, ax = 3
		


; Set up palette registers
		inc	dx
		mov	cx, 256*3
		rep	outsb
		mov	es, si			; es = a000h


; Draw the picture
		push	ax			; save for later
drawbuffer:
		xchg	bp, ax			; bp = max distance
						; Note: with at most 500 pts
						; max_dist is at least 3
redraw:
		xor	di, di
drawpt:
		cwd
		mov	ax, di
		mov	cx, 320
		div	cx
		mov	dh, al			; dh, dl = current pt
		push	si
		push	bp
		mov	bp, sp
dist:
		lodsb
		sub	al, dl
		add	al, 40h
		and	al, 7fh
		sub	al, 40h
		imul	al
		xchg	ax, cx
		xchg	dh, dl
		neg	bx			; loop controller
		jns	dist
		add	ax, cx			; ax = distance
min_bp:
		xchg	ax, bp
		cmp 	ax, bp
		jb 	min_bp

		cmp 	si, bx
		jne 	dist
		xchg	ax, bp
		pop	bp
		pop	si
		cmp	ax, bp
		ja	drawbuffer
		mov	dx, 255
		mul 	dx
		div	bp			; Color=(255*(distance^2))/max_dist
		xor	al, [bx]
		stosb				; Display
		test	di, di
		jnz	drawpt


; Get key
		int 	16h
		not	byte ptr [bx]
		cmp	al, 20h			; check for space
		jz 	redraw			; switch between versions



; Reset video mode	
		pop	ax
		int 	10h
		ret

		END
