; keff's entry to Hugi-compo 19
; (actually keff's first entry to hugi-compo ever :)
; size: 227 bytes
 ORG 100h

SECTION .text
start:

   ;this trick is from alvaros entry to HC#15
   mov bl, 5dh + 8
   mov ah, 3dh

   shl dword [bx], 8
   mov byte [bx], '.'
   lea dx, [bx-8]         

   int 21h                ; open file

   xchg ax, bx            ; save file-handle

   mov ax, 13h            ; enter mode13
   int 10h

; ah -> 00h
;
; read in palette+points
;  dx -> 0x5dh  (we'll use this to save the read char)
;  bx -> file-handle (for reading)
;  ax -> number from file (after read_char is done)
;
  mov di, palette - 1  ; we'll read in palette, then points
  push di          ; save palette-pointer for later

  @save_char:
     mov al, ah    ; save number -> al
     stosb        

     xor ax, ax    
     ;
     ; read_char
     ;  read a number from 'fileh'
     ;
    @read_char:

     push ax
     mov ah, 3fh           ; read-file bx = filehandle
     mov cx, 1             ; cx = number of bytes
     int 21h               ; ds:dx = where to write
     pop ax

     mov al, byte [5dh]

     cmp al, 0Dh     ; check for <CR>
     je @read_char   ; read in the <LF> too

     cmp al, 1Ah     ; check for <EOF>
     je @done

     cmp al, 30h     ; if al < '0', we're done (hit a space or <LF>)
     jb @save_char   ; save value to es:di

     sub al, 30h     ; remove 30 to get the number
     aad             ; al = ah * 10 + al
     mov ah, al      ; save number in ah

     jmp short @read_char
    ;
@done:
  mov bp, di         ; bp -> end of points

; ax = 001Ah
; dx = 005Dh

;
; set the palette
;
  pop si         ; restore palette-pointer

  mov cx, 256*3  ; 256 colors with 3 numbers to be written each

  mov dx, 3c8h
  outsb          ; write 0...
  inc dx

  rep outsb      ; ...followed by all colors

  push word 0a000h  
  pop es

;
; generate_buf && draw
; ds:si -> points-buffer
; es:di -> screen pointer
; bp    -> end of pointer-buffer
; bx    -> current image-point (0-128, 0-128)
; cx    -> maxdist && mindist
; dx    -> screen counter (0-320)
;

xor bx, bx
inc cx

@draw_again:
 inc cx
 
@gen_draw:
  push cx         ; save cx for loop-use later

  mov cx, bx     ; restore maxdist

  xor bx, bx      ; bl = x, bh = y
  xor di, di

 @y_loop:
  xor bl, bl      ; x = 0
  mov dx, 320     ; screen x-counter
 @x_loop:
    push dx       ; <- save screen-pos

      push cx ; <- save maxdist
       ;
       ; find_nearest
       ;
       xor cx, cx            ; cx = mindist
       dec cx                ; mindist = infinity
       mov si, points        ; for i=points(0) to end_of_points
   
       @find_loop:
       push bx               ; save x1 and y1

       lodsw                 ; load x2 and y2

       call distance
       ; ax = Distance^2(x,y,points[i].x,points[i].y)

       cmp ax, cx            ; if ax < mindist
       jae @dist2_greater
       xchg cx, ax           ; mindist = ax
       @dist2_greater:

       pop bx                ; restore x1 and y1

       cmp si, bp            ; are we at the end of points?
       jne @find_loop
       xchg ax, cx           ; ax = mindist
       ;
      pop cx                 ; <- restore maxdist

    cmp ax, cx            ; ax > maxdist
    jbe @not_greater
    xchg cx,ax            ; maxdist = ax
    @not_greater:         ;  

    mov dx, 0FFh
    mul dx                ; dist*255
    div cx                ; div with maxdist

    inc bl           ; increase bl and clear zero-flag

@flip_flop:
    jmp short  @no_flip
    sub al, 255
    neg al
    @no_flip:

    stosb            ; write to di

    pop dx           ; <- restore screen-pos

    and bl, 127      ; x%128
    dec dx
    jnz @x_loop

  inc bh
  and bh, 127     ; y%128

  cmp di, 64000
  jb @y_loop

  mov bx, cx       ; save calculated maxdist
  pop cx
  loop @gen_draw

;
; EBh xor 9Fh = 74h  -> jmp short XOR 9Fh = jz/je
; 74h xor 9Fh = EBh
;
; by using this information, we change
; the meaning of our flip_flop jump
; between 'jmp short' and 'jz/je', giving us
; two modes (inverted/not-inverted)
;

  xor byte [@flip_flop], 9Fh

  mov ah, 0      ; read character
  int 16h
  cmp al, 20h    ; check for space
  je @draw_again

@draw_done:
  mov ax, 03h    ; set text-mode
  int 10h
 
  ret

            ;
            ; distance
            ;  al = x1, ah = y1, bl = x2, bh = y2
            ;
            ;    Distance^2(x1,y1,x2,y2)   with 0<=x1<128  0<=x2<128
            ;      dx=abs(x1-x2)                0<=y1<128  0<=y2<128
            ;      dy=abs(y1-y2)
            ;      if(dx>64) dx=128-dx
            ;      if(dy>64) dy=128-dy
            ;    return dx*dx+dy*dy
            distance:

            sub al, bl
            jns @no_xswitch
            neg al
            @no_xswitch:     ; al = abs(x1-x2);

            sub ah, bh
            jns @no_yswitch
            neg ah       
            @no_yswitch:     ; ah = abs(y1-y2);

            cmp al, 64       ; al > 64
            jbe @no_dx_fix
            sub al, 128
            neg al           ; al = 128 - al
            @no_dx_fix:

            cmp ah, 64       ; ah > 64
            jbe @no_dy_fix
            sub ah, 128
            neg ah           ; ah = 128 - al
            @no_dy_fix:

            xor bx, bx
            mov bl, ah       ; bx = ah
            cbw              ; ax = al
            mul ax           ; ax = ax * ax
            xchg ax, bx      ; ax <-> bx
            mul ax           ; ax = ax * ax
            add ax, bx       ; ax = ax + bx = dx*dx + dy*dy

            ret
            ;

SECTION .bss
  dummy resb 1
  palette resb 256*3
  points:
