; Entry.asm
; Entry for HUGI SIZE CODING COMPETITION 19
;
; By: Kees Willem van der Meer
;     The Netherlands
;
; assemble with:
;   nasmw entry.asm -f bin -o entry.com

; Warning: don't run this program when assembled without DEBUG defined. The complete
; test-suite will then take between 30 and 40 years to run on a 450 Mhz pentium.
; testentry.com is assembled with DEBUG defined.

;%define DEBUG

DTA		equ	80h
FCB		equ	5ch
dosversion7	equ	40h
PrevPSP		equ	38h
recsize		equ	FCB+0eh
palette		equ	0fffeh>>1
points		equ	palette+3*256


		org	100h
%ifdef DEBUG
		mov	di, 0fffeh
		mov	si, 100h
		mov	ax, 0
		mov 	bx, 0
		mov	cx, 0ffh
%endif
		; assume ah=0
		mov	al, 13h
		int 	10h		; set mode 13h

		mov	dx, FCB		; 5ch
		mov	ah, 0fh
		int	21h		; open file
		; assume bx=0
 		rol	byte [bx+recsize], 1	; set recordsize to 1
		shr	di, 1		; di := palette (7fffh)
		push	di
readnumbers	
		; add al to tempresult in bl
		mov	ah, bl
		aad
		xchg	ax, bx
readnumber
		mov	ah, 14h	
		; assume dx=5ch
		int	21h		; read sequential
screenptr	equ	$-1		; a000:3c21
		cmp	al, 0		; test if al=0 (succesfull read)
		mov	al, [DTA]
		jne	setpalette	
		cmp	al, 0dh
		je	readnumber
		add	al, 100h-'0'	
		jc	readnumbers
		salc			; al:=0
		xchg	ax, bx		; al := result; bl := 0
		stosb
		jmp	short readnumber
setpalette
		dec	di
		mov	ax, 1012h
	 	; assume bx=0		; first color register
		xchg	si, cx		; si:=255, cx := 256
		pop	dx		; dx := palette
		int	10h		; set palette

		mov	fs, di

		; ax = 1012h
		; bx = 0
		; cx = 256
		; dx = 07fffh
		; di = fs = points (82ffh) + pointcount*2
		; si = 255
screenloop
		les	bp, [byte si+screenptr-255]	; es := a000; bp := 3c21
		; bp=mindist^2 is initialized to 3c21
		; (bp must not be negative for cwd to work 
		; on second pass of pointloop (after xchg bp, ax))

		mov	bx, fs
pointloop         
		cwd			; dx := 0
		mov	ax, di		; ax := index in videomemory
		div	word [byte si+val320-255]
		; following code repeated for coordinates in ax and dx
.pl1
		dec	bx
		sub	al, [bx]	; ignore bit 8 (mod 256)
		aam 	128		; mod 128
		aam	64		; if >= 64 then
		aad	64+128		; add 128
		imul	al
		xchg	ax, dx
%ifdef DEBUG
		test	bl, 1
		je	.pl1
%else
		push	bx
		popf			; last popf (of 82ff) in pointloop sets interrupt flag 
					; and clears direction flag
		jnc	.pl1		; Repeat if bx=even (lowest bit clear)
%endif
		dec	ax
val320		; dw 320 formed by next one and a half command
 		inc	ax		
		add	ax, dx		; ax=dx*dx+dy*dy

		cmp	ax, bp		
		ja	.pl5		; if ax < mindist^2 then
		xchg	bp, ax		; mindist^2 := ax
.pl5
		cmp	bh, points>>8	; points at 82ffh
		jne	pointloop

		cmp	bp, [si]		
		jl	.pl7		; if mindist^2 > maxdist^2 then
		mov	[si], bp	; maxdist^2 := mindist^2
.pl7
		xchg	ax, bp		; ax := mindist^2
		mul 	si		; * 255
		div	word [si]	; / maxdist^2
patch
		db 	0ah, 0d0h 	; or dl, al
					; cannot be coded directly because NASM chooses
					; the wrong encoding
					; this is changed to 'not al' on even passes (al := 255 - al)
		stosb
		or	di, di		
		jne	screenloop
%ifdef DEBUG
		; there must be at least three passes the first time, because the first pass
		; is incomplete and during the second one maxdist will not yet be calculated correctly.
		; assume dos version 7 here. 
		shr	 byte [di+dosversion7], 1
		jc	screenloop	; jump two times (after that version will be 0)
%else
		loop	screenloop	; 100h passes for first screen
					; 10000h passes for following screens
%endif
		; assume si=255
		neg	byte [byte si+patch-255]	; change harmless 'or dl, al' to 'not al' or vice versa

		; assume ah=0
		int	16h		; read key in al		
		cmp	al, ' '
		je	screenloop
		mov	ax, 3h
		int	10h		; set mode 3
		retn
