; // tasm /m entry
; // tlink /t entry
; // 144 octets

.486
cseg	segment byte public use16
	assume	cs:cseg, ds:cseg, es:cseg, ss:cseg

	org	100h

main:
	

PROCESS_CMD_LINE:
	; // assume si = 0100h
	; // assume bh = 00
	; // assume cx = 00FFh

	mov dx,82h
	mov bl,[si-80h]
	mov [bx+si-7fh],bh	; // bh=0 ; //put 0 after file_name

	; // open the file, (handle)
	mov ah,3dh		
	int 21h
	xchg bx,ax ; // bx <- handle , ah<-0

	
SWITCH_TO_MODE_13h:
	
	mov al,13h
	int 10h

READ_ALL_FILE:
	
	; // assuming that there is no more than 500 points
	; // there are 256 palette lines
	; // a number takes no more than 4 chars (3 digits + <cr> or <space>)
	; // ==> a line takes no more than 13 chars (3*4 + <lf>)
	; // ==> all data <= 13 * (500+256) < 2700h

	mov dx,0a000h
	xchg ch,cl ; // cx=0xff00 read all data
    mov ah,3fh
    int 21h

DRAW_SECTION:	
	mov es,dx

	; // xor di,di
	; // initial di=FFFE
	; // DI <- 0000
	stosw
	
		
	; // di = 0 
	
	; // bx is the max
	; // bx = file handle =3
	; // stdin=0 , stdout=1 , stdprn=2

	; // cx = FF00
	; // cl = 0 for version1 and 255 for version2	
	

re_draw:

	; // bx = max
	; // we will draw 65536 points, not harmfull
	; // since we draw the right thing in the right place

	; // the value of 'maximum distance' is right after 
	; // execution of 'draw_loop'
	; // so we'll draw twice
	; // the drawing is not rapid, but it's right	
	
	draw_loop_outer:
		draw_loop:
			
			push cx
			    
				mov si,es ; //data start
				mov dx,3c9h
				mov cx,300h ; // 256*3 
				palette_loop:
					call read_byte
					out dx,al		
					loop palette_loop

				; //(ah & 80h) =0 , from read_byte
				cwd			
				mov ax,di ; // 0,1,2,...
				mov bp,320
				div bp

				mov dh,al
				
				; //do not need to execute "and coordinate,7Fh"
				; //it works perfectly, thanks to the "shl ax,1"
				; //another magic property of circular 8 bits computations :-)

				; //  let x,y 2 values in [0..127]
				; //  1. no problem for (x-y) 
				; //  2. (x+128)-(y+128) = (x-y) : no problem
				; //  3. (x+128)-y = 128 + (x-y)
				; //     2*(x+128)-y = 2*(128 + (x-y))
				; //                 = 256 + 2*(x-y)
				; //                 = 2*(x-y) (8 bits value)
				;
				; //  4. x-(y+128) = -128 + (x-y)
				; //     2*(x-(y+128)) = 2*(-128 + (x-y))
				; //                 = -256 + 2*(x-y)
				; //                 = 2*(x-y) (8 bits value)
				
				; // si = points start
				; //here cx=0 from loop upper
				dec cx ; //the min (FFFF)
					
					points_loop:
	
						loop1:	
								
							call read_byte
							je no_more_points ; // char read is EOF (1Ah)

							sub al,dl

							square:
							    ; //these are conclusions from different observations
								; //some could be considered as demonstrations (there are 
								; //    surely some real demonstrations for them).
								; //I won't (and may be I can't) give these demonstrations.
								;
								; //At least here is some explanations.

								; //cases
								; //1. al in [0..63]
								; //   the result is correct
								; //   the factor "2*" is simply handled later
								; //       by an "shr ax,2" ('/4' because of the square)

								; //2. al in [64..127]
								; //   after "shl ax,1" : al<0 (bit 7 become 1)
								; //   al = 2*oldAL         (Unsigned byte)
								; //      = (2*oldAL - 256) (Signed byte)
								; //      = 2*(oldAL - 128) (Signed byte)
								; //      = -2*(128-oldAL) (Signed byte)
								;
								; //   ==> (128-oldAL) THAT's what we need
								; //   the sign will be drooped by the "imul"
								; //   the factor "2*" is simply handled later
								; //       by an "shr ax,2" ('/4' because of the square)

								; //3. al in [-63..-1]
								; //   al = 2*oldAL ([-126..-2])
								; //   the sign will be drooped by the "imul"
								; //   the factor "2*" is simply handled later
								; //       by an "shr ax,2" ('/4' because of the square)
								; //   
								; //   after "imul"
								; //   ax = (2*oldAL)*(2*oldAL)
								; //      = 4*oldAL*oldAL
								; //      = 4*(abs(oldAL)^2)
								; //   that's what we need

								; //4. al in [-127..-64]
								; //   more complicated
								; //   al = 256-abs(2*oldAL)   (Signed BYTE value) (>=0)
								; //      = 2*(128-abs(oldAL)) (Signed BYTE value) (>=0)
								; //   
								; //   (128-abs(oldAL)) : exactly what we need
								
								shl ax,1
								imul al

								; //shr ax,2
								; //the factor "4*" is not harmful since both the distance
								; //buffer and MAX values have it. 
								; //(4*value)/(4*max)=value/max

							end_square:
							
							xchg bp,ax
							add ax,bp
							
							xchg dh,dl
							neg bx
							; // before 1st loop : dh=x, dl=y, BIT(bx,15)=0 ; // dx=xxxx 
							; // after 1st loop (just here) : dh=y, dl=x, BIT(bx,15)=1, SF=1 ; // bp=(x1-x2)^2 ; // ax=xxxx
							; // after 2nd loop (just here) : dh=x, dl=y, BIT(bx,15)=0, SF=0 ; // bp=(y1-y2)^2 ; // ax=(x1-x2)^2 + (y1-y2)^2
							js loop1						

						cmp ax,cx
						ja __above
							xchg cx,ax
						__above:					
					jmp points_loop

					no_more_points:
				
				xchg cx,ax
				cmp ax,bx
				jb __below
				    ; // yeah this xchg is not "politically correct" :-)
					; // but we'll draw twice, the first frame does not matter
					; // while drawing the second frame, we have the correct value
					; // of the "MAX" in "bx", so the only case this "xchg" is executed
					; // is (bx==ax=="MAX"), not harmful at all [I think :-)]
					xchg bx,ax
				__below:	

				mov dx,0ffh 
				mul dx

				div bx			

			pop cx			

			xor al,cl	; // = not al = 255 - al  if cl==255
						; // = al  if cl==0
			stosb

			test di,di			
			jnz draw_loop
		
		neg ch
		jns draw_loop_outer
			
		; // after the loop :
		; // dx = 0		
		; // di = 0
	
	keyboard:
		not cl
		
		xchg dx,ax ; //dx=0  after last "div bx"
		int 16h

		aad 233 ; //the only sequeces that leads to ax=0 are
		dec ax  ; //ax=3920h (space) and ax=8000h (shift+F6)
		
		jz re_draw




	; // restore text mode
	restore_video:
	; //ah = 0 from AAD upper
	mov al,3
	int 10h

	; // no matter if "read_byte" is executed before executing its "RET"

read_byte:
	; // assume si = pointer to data to be read
	; // guaranteed results :
	; //     ah=al=binary number (0..127) equal to the valid ASCII input number (0..127)
	; //     (ah & 80h)=(al & 80h)=0
    
	xor ax,ax
	begin_number:	    
		lodsb							
		sub al,"0"
		jb  end_number	
        aad ;al <- ah*10+al
		xchg ah,al
    jmp begin_number
	end_number:

	cmp al,1ah-"0"    ; // exit condition for "points_loop" loop
	mov al,ah
	jae end_read_byte ; // this is a <space> or <EOF>

	; // here it's (<CR> - "0")
	inc si ; // bypass <LF> 
	       ; // si won't be 0 after the "inc"
	       ; // so the 'je (in the draw_loop->points_loop)' 
		   ; // after this won't be wrong

	end_read_byte:
	ret
	


end main

