;Compile: nasm -f bin -o example.com example.asm
;Run: example points.txt
[org 100h]

RESX equ 320
RESY equ 200

TEXTWIDTH equ 128
TEXTHEIGHT equ 128

[SECTION .text]

	mov si,81h
	call SkipSpaces

	mov di,filename
	call CopyName

	mov ax,3d00h
	mov dx,filename			;can't open the file so exit
	int 21h
	jc @notfound
	mov word[filehandle],ax
	
	push word 0a000h
	pop es

	mov ax,13h
	int 10h

	call read_pal
	call read_points
	call calc_distbuffer
@redraw:
	call draw_buffer
	neg byte[one_minus_c]
	
	mov ax,0
	int 16h
	cmp al,32		;If <space> is pressed switch
	jz @redraw		;between version1 and version2
	
	mov ax,3		;Any other key: return to dos
	int 10h

	mov bx,word[filehandle]
	mov ah,3eh
	int 21h
	
@notfound:
	ret

SkipSpc2:
	inc	si
SkipSpaces:
	cmp	byte [si],20h
	jbe	short SkipSpc2
	ret

CopyName:
	lodsb
	cmp al,20h
	jbe copyend
	stosb
	jmp CopyName
copyend:
	mov byte [di],0
	inc di
	ret

;Display the texture
draw_buffer:
	mov si,dist_buffer
	xor di,di
	mov word [posy],0
@drawnline:
	xor bp,bp
	mov word [posx],0
@drawncol:
	xor eax,eax
	mov ax,word[si+bp]				;ax=distance^2
	add bp,2
	and bp,255						;this is equivalent to x%128
	sub ax,word [min_val]
	mul dword [maxcolor]
	xor edx,edx				;Version1:
	div dword [amplitude]	;Color=(255*(distance^2)-min_val)/amplitude
	cmp byte[one_minus_c],-1
	jz @notminus
	sub al,255				;Version2:
	neg al					;Color=255-Color
@notminus:
	stosb					;Display
	inc word[posx]
	cmp word[posx],RESX
	jne @drawncol
	add si,TEXTWIDTH*2		;Next distance line
	cmp si,dist_buffer+TEXTHEIGHT*TEXTWIDTH*2
	jne @nomodulo			;this is equivalent to y%128
	mov si,dist_buffer
@nomodulo:
	inc word [posy]
	cmp word [posy],RESY
	jne @drawnline
	ret

;Compute the distance buffer
calc_distbuffer:
	mov si,dist_buffer
	mov word[posy],0
@nextline:
	mov word[posx],0
@nextcol:
	mov ax,word[posx]
	mov bx,word[posy]
	call find_min_dist
	mov cx,word [min_dist]
	mov word [si],cx		;Save distance^2
	add si,2
	cmp cx,word [amplitude]	;Put max val in amplitude
	jb @notmax
	mov word[amplitude],cx
@notmax:
	cmp cx,word[min_val]
	ja @notmin
	mov word[min_val],cx
@notmin:
	inc word[posx]
	cmp word[posx],TEXTWIDTH
	jne @nextcol
	inc word[posy]
	cmp word[posy],TEXTHEIGHT
	jne @nextline
	
	mov ax,word [min_val]
	sub word [amplitude+2],ax	;amplitude=maxval-minval
	
	ret
	
;Put all points in points
read_points:
	mov di,points
@next_coord:
	call read_num
	cmp cx,-1
	jz @points_end
	mov [di],cx
	add di,2
	jmp @next_coord
@points_end:
	mov bp,di	;bp=end of points
	ret

;Load the palette
read_pal:
	mov bp,256*3
	mov dx,3c8h
	xor al,al
	out dx,al
@next_pal:
	call read_num
	mov dx,3c9h
	mov al,cl
	out dx,al
	dec bp
	jnz @next_pal
	ret

;Read a number from STDIN and return it in cx
;cx=-1 if we reach the end of the point list or 
;the end of the file
read_num:
	xor cx,cx
@nextchar:
	push cx
	mov ah,3fh
	mov bx,word[filehandle]
	mov cx,1
	mov dx,letter
	int 21h
	pop cx
	mov al,byte[letter]
	cmp al,0Dh
	jz @nextchar
	cmp al,0Ah
	jz @retnum
	cmp al,1Ah	;EOF?
	jz @lastnum
	cmp al,32
	jz @retnum
	imul cx,10
	sub al,'0'
	xor ah,ah
	add cx,ax
	jmp @nextchar
@lastnum:
	mov cx,-1
@retnum:
	ret

;Compute the "wraped" distance between two points
;(x1,y1)=ax,bx (x2,y2)=cx,dx
wrapdist:
	sub ax,cx
	jns @positive
	neg ax
@positive:			;ax=abs(x1-x2)
	sub bx,dx
	jns @positive2
	neg bx
@positive2:			;bx=abs(y1-y2)
	cmp ax,TEXTWIDTH/2
	jna @dy				;if(abs(x1-x2))>textwidth/2) ax=textwidth-ax
	sub ax,TEXTWIDTH
	neg ax
@dy:
	cmp bx,TEXTHEIGHT/2
	jna @calcdist		;if(abs(x1-x2))>textwidth/2) ax=textHEIGHT-ax
	sub bx,TEXTHEIGHT
	neg bx
@calcdist:
	mul ax
	xchg bx,ax			;Now compute the standard distance
	mul ax
	add ax,bx
	ret

;Find the closest point to (x,y) and
;put the distance^2 in [min_dist]
;(ax,bx)=(x,y)
find_min_dist:
	mov word [min_dist],0FFFFh
	mov di,points
@find_min:	
	mov cx,word[di]
	mov dx,word[di+2]
	push ax
	push bx
	call wrapdist
	cmp ax,word [min_dist]
	ja @not_min_dist
	mov word [min_dist],ax
@not_min_dist:
	pop bx
	pop ax
	add di,4
	cmp di,bp
	jne @find_min

	ret

[SECTION .data]

min_val   dw 0FFFFh
amplitude dd 0h
min_dist  dw 0
maxcolor  dd 255

one_minus_c db -1

[SECTION .bss]
letter resb 1

filehandle resw 1
filename resb 13

posx resw 1
posy resw 1

dist_buffer resw 128*128
points: