;Hugi/Sniper Compo 20 
;Easter Date calculator
;entry by Aphex
;compile: tasm /m entry
;	  tlink /t/x entry
;
;a big thanx goes to Jean-Charles Meyrignac for showing me some tricks in
;the pfm calculation (the 15-Y/300 part) and revealing me all equivalences
;between algorithms, so that a mixture could be possible
;another big thanx goes to Ruud for sharing precious info about optimizations
;on the mailing list (how much is 19N/30 :-) ?), so that more than enough clues 
;were given 
;also thanx to Ben, Claus and all others that keep this compo alive !
;
;algo: optimized Kershaw-Oudin
; G = (Y%19)*19
; K = Y/400-Y/100-16
; S = Y+Y/4+K-16
; P = G-Y/300-1-K
; PFM = P%30
; C = P/30
; if ((PFM<28)||((PFM==28)&&(C<7))) PFM++
; PFM += 19
; D = PFM-((S+PFM)%7-7)
; MONTH = 3
; DAY = D/31+1
; if (D%31==1) MONTH++
;

p286
model tiny
codeseg
startupcode

start:
		or	ax, 240Ah		; end of string

		imul	bx			; ax = dx = 0
		mov	dl, 0F3h
		mov	di, dx
read:
		imul	bx, 10			; next digit
		add	bx, ax			; add digit to Y

stdin:
		mov	ah, 8
		int	21h			; input char
		cmp	al, 0Dh
		jc	stdin			; if 0A read again

		stosb				; store char
		mov	byte ptr [di], 24h

		push	bx			; save data
						; 0, Y/1000, Y/100, Y/10, Y
		
		aad	26			; make digit from char

		jc	read             	; more digits to read?

		jnp	exit			; we have a zero on stack :)

						; bx = Y
						; a nice stack set!

		org	$-1
loopS:
		dec	di

		lea	ax, [bp+si]		

		pop	bp		        ; bp = stack (Y or Y/100)
		pop	si			; dummy pop

		lea	si, [bp-64]
		sar	si, 2                   ; bp-64 can be < 0
						; -64 is really a -16 :)
			
		jns	loopS			; Y/100 < 64 :)
						
		sub	si, bp			; si = K
		add	ax, si			
		xchg	bp, ax			; bp = S
sub3:
		inc	si
		sub	al, 3
		jnc	sub3			; si += Y/300+1

		xchg	bx, ax                  ; ax = Y

		mov	bl, 19                  ; bx = 19
		div	bl
		mov	al, 19	
		mul	ah

		sub	ax, si			; P = ax

	        mov     si, offset month  	; set offset for March
						; second byte in the string
						; won't be used in dump
						; so it points to a 30 value!

		div	byte ptr [si+1]		; /30, %30

		cmp	ax, 28*256+7		; this of course is Ruud's :)
		mov	cl, 7
												
		adc	bl, ah                  ; bl = adjusted PFM
		add	bp, bx
sub7:
		sub	bp, cx
		jnc	sub7		                		
		sub	bx, bp                  ; D = PFM - ((S+PFM)%7-7)
		xchg	bx, ax

		pop	bx			; bx = 0, sp = -2

		aam	31			; ah = D%31, al = D/31
		inc	ax
		sahf    			; CF = ah
loopmonth:
		movsb				; month name						
		sbb	si, sp		
		loop	loopmonth

                aam				; break digits
                xchg    al, ah			; swap 
                daa				; test for zero
                jnz     nolz
                mov     al, 10h                 ; pad with space
nolz:
                xor     ax, 3030h               ; make ASCII
                stosw

		push	di			; save 100h 
exit:
                mov     ah, 9                   ; write string
                int     21h
		ret				; 100h for read again
						; 0 for exit

month		db 	'-',30,'AMparriclh  '

end start

