;-----------------------------------------------------------------------;
;                                                                       ;
; Entry for HUGI size coding competition #20: Easter Date Compo         ;
; To compile with MASM: ml entry.asm                                    ;
;                                                                       ;
; By Jeff (USA)                                                         ;
;                                                                       ;
;-----------------------------------------------------------------------;
		.MODEL 	tiny
		.CODE
		.386
		.STARTUP

EOL		db	0dh, 0ah, '$'

; Initialize year
		pop	cx		; CX = 0, will be year

; Read a character
ReadChar:
		mov	ah, 7
Exit:		int	21h		; Read char
		cmp	al, 0dh
		jbe	PrintEaster	; if CY is set, PrintEaster jumps
		mov	ah, 2
		mov	dl, al
		int	21h		; Print char
		cbw
		sub	al, '0'
		jc	Exit
		imul	cx, 10
		add	cx, ax		; only zero if leading 0's
		push	cx
		push	cx		; push Y/1000, Y/100, Y/10, Y 
PrintEaster:	jnz	ReadChar


; Calculate Easter Date
		popa		; AX=CX=Y/1000, BX=DX=C, BP=Y/10, SI=DI=Y
		xchg	ax, si
		cwd
		mov	cl, 19
		div	cx
		xchg	ax, dx
		mul	cx	; AX = 19*N, DX = 0


		mov	cl, 30
NextSub:	dec	ax
		sub	bp, cx	; BP = Y/10, and   C/3 = (Y/10)/30
		jnc	NextSub	; AX -= C/3 + 1


		lea	bx, [ebx + 2*ebx + 3 + 64]
		shr	bx, 2		; bx = C - C/4 + 16 = (3C+3)/4 + 16
		add	ax, bx


		div	cl		; ah = I % 30, al = I/30

		cmp	ax, 28*256 + 6
		xchg	al, ah
		adc	al, 27 - 31	; AL = AL - (1 - CY) - 4
		cbw


		push	ax		; save I
		add	ax, di
		shr	di, 2
		add	ax, di
		sub	ax, bx
		mov	cl, 7
		div	cx		; dx = J % 7
		pop	ax		; ax = I
		sub	al, dl

; Print Date
		mov 	dx, OFFSET April
		jg	GotMonth
		sub	dx, cx		; cx = 7
		add	al, 31
GotMonth:
		std
		mov	di, OFFSET EOL-1
		aam
NextDigit:	add	al, 30h
		stosb
		shr	ax, 8
		jnz	NextDigit
		mov	ax, 0920h
		rep	stosb			; CX = 0
		int	21h
		mov	dx, OFFSET EOL-3
		int	21h
		jmp	ReadChar


March		db	'-March$'
April		db	'-April$'


                END