	page	240, 132
;ENTRY.ASM	15-Mar-2003		Boreal		loren_blaney@idcomm.com
;Hugi Compo 21: Tic-Tac-Toe
;
;The computer marks its moves with an "O" and the player uses an "X". The
; numeric keypad is used to make the player's move.
;
;                         7  8  9
;                        
;                         4  5  6
;                        
;                         1  2  3
;
;The player always goes first, but the 0 key is used to skip a move. Thus
; it can be used to let the computer play first.
;
;Assemble:
; tasm /m
; tlink /t

;Register usage:
; ax = scratch
; bx = OMoves
; cx = flashing cursor, bit shifter & loop counter, msg loop counter
; dx = 'try' value, 'showFld' X position
; si = best move from 'try', msg pointer, bit tester in 'showFld'
; di = screen pointer for msg and showFld, won index
; bp = XMoves
; es = screen base pointer
; fs = value returned by 'try'

	.model	tiny
	.code
	.486
	org	100h

start:	push	0B800h+50		;point es to text screen (50=Y0*80/16)
	pop	es

main:	xor	ax, ax			;set 40x25 screen and clear it
	int	10h			;(also erases any messages)

	mov	ax, 01FFh		;initialize player's bit arrays to empty
	mov	bp, ax			;XMoves; a set bit indicates empty
	mov	bx, ax			;OMoves
;(ah=01)
	mov	ch, 20h			;turn off the annoying flashing cursor
	int	10h
play:					;play one game
;#################### GET PLAYER'S MOVE (X) ####################
redo:	call	showFld
	je	quit			;quit if Esc

	sub	al, '0'			;skip move? (computer goes first?)
	je	skip
	cmp	al, 10			;legal keystroke (0..9)?
	jae	redo			;loop back if not (ignore illegal keys)

	dec	ax			;loop if square is already occupied
	mov	dx, bx
	and	dx, bp
	bt	dx, ax
	jnc	redo
	btr	bp, ax			;make move
skip:
;#################### GET COMPUTER'S MOVE (O) ####################
;	xor	si, si	si=200h		;default to no-move in case it's a cat's
	call	try			;get value
	xor	bx, si			;make best move (or no move) in OMoves
					;see if computer won
	mov	ax, bx			;get OMoves
	call	won			;Z flag set if player ax has won
	mov	cx, 7			;display 7-character message at si
	mov	si, offset msgOWin	;assume computer won
	je	sm05			;jump if so

	and	ax, bp			;XMoves
	jne	play			;jump if not cat's game

	sub	si, cx			;display "A draw!"
sm05:
	mov	di, (20*40+17)*2 - 50*16;set cursor to 17,20
sm10:	movsb				;es:[di++]:= ds:[si++]
	inc	di			;skip attribute byte on screen
	loop	sm10			;loop for 7 characters

	call	showFld			;display computer's winning move
	jne	main			;repeat games until Esc key
quit:					;(ah=0)
	mov	al, 03h			;clear screen & restore flashing cursor
	int	10h
;	ret				;return to DOS

;###############################################################################
;Return with Z flag set if player's array in ax is a win (3 in a row)

won:	mov	di, 7			;for 7 downto 0
won10:	test	ax, word ptr [di+Tbl]
	je	won90			;jump if won
	dec	di
	jns	won10
won90:	ret

;###############################################################################
;Recursive tree search. Returns the value of the best node for player bx.
;Inputs:
; bx = player's bit array (OMoves or XMoves)
; bp = other player's bit array
;Outputs:
; fs = value of best node
; si = best move: bit is set in corresponding position
;Other registers:
; cx = position and loop counter
; dx = value of node (-1, 0, or +1)

try:
;If terminal node (win or cat's) then evaluate it and return
;Check for a win by other player
	cwd				;dx:=0
	dec	dx			;dx:=-1; assume a win
	mov	ax, bp			;get other player's array (O or X)
	call	won			;Z flag set if player ax has won
	je	try90

;Else check for a cat's game
	inc	dx			;dx:= 0
	and	ax, bx			;if all positions are occupied (cat's)
	je	try90			;return a 0

;Else return the best value of a sub-node (recurse)
;Make tenative move for the player (bx)
	dec	dx			;assume the worst value for node (dx=-1)
	mov	cx, 100h		;for bit 8 down thru 0...
try20:	test	cx, bx			;skip if position is already occupied
	je	try30
	test	cx, bp
	je	try30

	pusha
	xor	bx, cx			;make tenative move
	xchg	bx, bp			;swap players
	call	try			;check opponent's replies
	popa				;undo tenative move & restore registers

	mov	ax, fs			;get value of reply
	neg	ax
	cmp	ax, dx
	jle	try30
	 xchg	dx, ax			;save value of best move
	 mov	si, cx			;save best move as a set bit position
try30:					;(should be done only for 1st level)
	shr	cx, 1			;next position
	jne	try20
try90:
	mov	fs, dx			;return value of best move
	ret				;best move is returned in si

;Table of winning patterns. The 9th bit is gotten from the LSB of the next entry
Tbl	db	01010100b
	db	10010010b
	db	00111000b
	db	00100100b
	db	00000111b
	db	11000000b
	db	00010001b
	db	01001001b		;next byte must have its LSB = 0

;###############################################################################
;Show the playfield including O's and X's
;Register usage:				 O |   |   
; al = Ch					---+---+---
; bx = OMoves					   | X |   
; cx = odd/even rows				---+---+---
; dx = horizontal X position			   |   | O 
; si = bit tester for OMoves and XMoves
; di = screen pointer
; bp = XMoves
; es = Screen base (segment) address

showFld:mov	si, 1			;set up bit tester
	xor	cx, cx
	mov	di, (14*40+15)*2 - 50*16;point to lower left corner of image
sg05:	mov	dx, 11			;for X:= 1 to 11 show chars on the row

sg07:	test	dl, 3			;test every 4th horizontal position
	jcxz	sg20			;jump on every other row

	mov	al, ''			;Ch:= if X & 3 then ^ else ^
	jne	sg10
	 inc	ax			;form '' for every 4th horiz position
sg10:	jmp	sg40			;go write character to the screen
sg20:
;Ch:= if X & 3 then (if X & 1 then ^  else Getch) else ^;
	mov	al, ''			;go write '' on every 4th horiz posn.
	je	sg40

;Ch:= if X & 1 then ^  else Getch
	mov	al, ' '			;every other horizontal char is a space
	test	dl, 1
	jne	sg40
	 test	bx, si			;test for computer's move in this posn.
	 jne	sg22
	  mov	al, 'O'
sg22:	 test	bp, si			;test for player's move in this posn.
	 jne	sg25
	  mov	al, 'X'
sg25:	 shl	si, 1			;next position
sg40:
	stosb				;write char to screen; es:[di++]:= al
	inc	di			;skip attribute byte

	dec	dx			;next horizontal X
	jne	sg07

	not	cx			;distinguish odd/even rows

	sub	di, (40+11)*2		;move to left side of image and up a row
	jns	sg05			;loop back for next row until done

	cbw				;ah:= 0 (last char output was a 20h)
	int	16h			;wait for keystroke
	dec	ah			;is it an Esc?
	ret

msgDraw	db	'A draw!'
msgOWin	db	'O wins!'		;(must follow msgDraw)
	end	start
