; HC21 entry by Bonz
;
; 270	first version
; 244	lots of small improvements (obvious things, encoding chars
;	directly in the opcodes table, merging the two evaluation
;	routines for blocking the opponent and picking an empty cell)
; 239	hide cursor with a black-on-black character

	org	100h

%define X0	15		;screen coordinates of character in upper-left position
%define Y0	10		;(used to position grid on screen)

; %define MODE3
%ifdef MODE3
%define LINE 160
%else
%define LINE 80
%endif

	push	word 0b800h		; Point ES into VRAM
	pop	es

push_loop:
	push	ax
	loop	push_loop
	
restart:
	popa
	pusha
%ifdef MODE3
	db	0b9h			; Turn into MOV CX
%endif

	int	10h			; 40x25 please
	stosw			; No cursor please (corner is black on black)
	
get_key:
	call	board
	jmp	short get_key_2	; Go to get_key with CX>0

	; Print final message after CALL and exit

print:
	pop	si			; pop address of message
	pop	bp			; Pop return address
	mov	di, 20*LINE+17*2
	mov	cl, 7			; length
do_print:
	movsb
	inc	di
	loop	do_print		; Go on with CX=0

get_key_2:
	int	16h			; Get key
	dec	ah			; ESC pressed?
	jnz	noquit
	mov	al, 3			; If so, exit (AH=0)
	int	10h
	ret

noquit:
	jcxz	restart		; If game finished and not ESC
	sub	al, 30h		; AL in range 0..9
	jz	think
	cmp	al, 9
	ja	get_key
	mov	cl, 1
	dec	ax
	aam	3
flip79:
	xor	al, 2
	cmp	al, 3
	je	flip79
	aad	3
	xchg	cx, ax
	shl	ax, cl

	test	bp, ax			; If filled, go back to the top
	jnz	get_key
	
	or	bx, ax		; Put cross in place
	call	board			; And draw board

think:
	mov	si, wins			; Load pointer to move table

next_move:
	lodsb				; Load winning combination or move
	dec	ax			; Set flags
	setp	ah

	or	ax, bx		; AX = BX | winning combination
	xor	ax, bx		; AX = ~BX & winning combination
	jz	next_move
	mov	cx, ax		; One bit set in it?
	dec	cx
	and	cx, ax
	jnz	next_move		; If so, that might be our move
	test	ax, dx
	jnz	next_move		; Unless we already made it

	or	dx, ax		; Place naught in best place
	jmp	short get_key	; Draw board and get key
	
	; Draw board, don't return and jump to PRINT label if game ended
	; Requires CH=0
	; Trashes SI/DI, sets BP=BX|DX, AH=0
	
board:
	mov	cl, 5			; Number of lines
	pusha			; Save registers while drawing
	mov	di, LINE*Y0+X0*2; Point ES:DI into VRAM
	mov	ah, 1			; Point AX into the program

; Define opcodes

%define HORIZ	196
%define VERT	179
%define CROSS	197
%define SPACE	255
%define CELL	(_cell - $$)
%define CR		(_cr - $$)
%define GOTO	(_goto - $$)
	
_goto:
	mov	si, opcodes		; Reset opcode table
dispatch:
	lodsb				; Load opcode
	cmp	al, 179		; Is it a character?
	jae	output		; Yes, write it
	jmp	ax			; No, do it

_cell:
	mov	al, 'X'
	shr	bh, 1			; Is it a cross?
	jc	plot			; Yes, go ahead
	shr	dh, 1			; Is it a naught?
	salc				; No, AL=0
	and	al, 'O'			; Yes, AL='O'
plot:
	shl	bx, 1			; Slide naughts to the left
	shl	dx, 1			; And crosses too
output:
	stosb				; Draw character
	inc	di			; Skip attribute
	jmp	short dispatch	; Do next opcode

_cr:
%ifdef MODE3
	add	di, LINE - 11*2	; Carriage return
%else
	add	di, byte LINE - 11*2	; Carriage return
%endif
	loop	dispatch		; When lines end, we're done
	popa
	
	mov	si, wins		; Load pointer to wins
next_win:
	lodsb				; Load a winning combination in AL
	cmp	al, 11h
	je	not_win		; AX=10h? Exit
	dec	ax			; Set flags
	setp	ah			; Extend into AX
	mov	di, ax			; DX & AX = AX?
	and	di, dx
	sub	ax, di
	jnz	next_win		; If so, we won (how lucky!)

	call	print			; then print the message
	db	'O wins!'

not_win:
	mov	bp, dx		; Combine DX and BX
	or	bp, bx		; into BP (used by AI)
	cmp	bp, 1ffh		; and check if it's a draw
	jz	draw
	ret

opcodes:
	db	SPACE, CELL, SPACE, VERT, SPACE, CELL, SPACE, VERT, SPACE, CELL, SPACE, CR
	db	HORIZ, HORIZ, HORIZ, CROSS, HORIZ, HORIZ, HORIZ, CROSS, HORIZ, HORIZ, HORIZ, CR
	db	GOTO

wins:
	db	0c0h+1, 38h+1, 7+1	; horiz.
	db	24h+1, 92h+1, 49h+1	; vert.
	db	11h+1, 54h+1		; \ /
	
	db	10h+1			; center
	db	80h+1, 20h+1, 8+1, 2+1	; side
	db	1, 40h+1, 4+1, 1+1	; angle
	
draw:
	call	print
	db	'A draw!'
