;-----------------------------------------------------------------------;
;                                                                       ;
; Entry for HUGI size coding competition #21: Tic-Tac-Toe               ;
; To compile with MASM: ml entry.asm                                    ;
;                                                                       ;
; By Jeff (USA)                                                         ;
;                                                                       ;
;-----------------------------------------------------------------------;
		.MODEL 	tiny
		.CODE
		.386
		.STARTUP

RowCol		MACRO	Row, Column
		mov	di, 2*(Column*40 + Row)
		ENDM	RowCol

		pusha
start:
		popa
		pusha
		int 	10h			; 40x25 screen, clear screen

		xchg	ax, si
		mov	ch, 20h
		int	10h			; turn off cursor

						; bx = all moves
		mov	bp, 0fe00h		; bp = X's moves

DrawHash:
		push	0b800h
		pop	es			; ES = screen
		RowCol	15, 13
		mov	ax, 07c4h
		mov	cx, 11
HlineLp:
		mov	es:[di-160], al
		stosw
		loop	HlineLp

		RowCol	18, 14
		mov	cl, 5
		mov	al, 0b3h
VlineLp:
		stosb
		mov	es:[di+7], al
		sub	di, 81
		xor	al, 76h
		loop	VlineLp


		xchg	ax, cx			; wait for keystroke
		cwd				; dx = 0 for later scores
		int	16h
		sub	al, '0'
		jbe	skip
		dec	ax

		mov	cl, 'X'			; Display X move
DrawMove:
		bts	bx, ax
DrawHashTmp:	jc	DrawHash		; bit already set
		push	ax
		db	0d4h, 3			; aam 3
		neg	ah
		db	0d5h, 20		; aad 20
		cbw
		shl	ax, 3
		add	ax, 480h		; Row 16, Column 14
		xchg	ax, di
		xchg	ax, cx
		stosb
		cmp	al, 'O'
		pop	ax
		je	tie
		bts	bp, ax			; mark X's move

skip:
		jb	quit

		mov	cx, 8
ScoreLoop:	bt	bx, cx			; is position empty?
		jc	ScoreDone
		push	cx


		mov	ax, 3bh			; O will win?
		mov	si, bp
		bts	si, cx
CheckWin:
		xor	si, bx
		pusha
		mov	bx, OFFSET Tbl1-1
		mov	cl, 8
WinLoop:	inc	bx
		mov	ax, [bx]
		and	ax, si
		cmp	ax, [bx]
		loopne	WinLoop
		popa
		jz	GotWeight
		sub	al, 10h			; 2bh = X will win, so block
		jpe	CheckWin


		cmp	cl, 4
		je	GotWeight		; center is weight 28 (27 + 1)
		shr	cl, 1
		jc	EdgeWeight		; edge is weight 14 (27/2 + 1)
		rol	ax, cl
		and	ax, bp
		jz	GotWeight
		mov	al, 10*2		; corner is either 11 or 1
EdgeWeight:
		shr	al, 1
GotWeight:
		pop	cx
		inc	ax
		cmp	al, dl
		jbe	ScoreDone
		xchg	ax, dx
		mov	di, cx

ScoreDone:
		dec	cx			;next position
		jns	ScoreLoop

		mov	cl, 'O'
		xchg	ax, di
		test	dx, dx
		jnz	DrawMove

tie:
		cmp	dl, 3ch			; winning move?
		mov	si, OFFSET MsgOWin
		mov	cx, 7
		je	winner
		cmp	bx, 01ffh
		jb	DrawHashTmp

		sub	si, cx
winner:
		RowCol	17, 20
MsgLp:		movsb
		inc	di
		loop	MsgLp
		xchg	ax, cx
		int	16h
		cmp	al, 1bh
		jne	start
quit:
		popa
		mov	al, 03h			;clear screen and restore cursor
		int     10h
		ret


;Table of winning patterns
;Tbl0		db	38h, 54h, 92h, 24h, 11h, 49h, 0c0h, 07h
Tbl1		db	11h, 49h, 0c0h, 07h, 38h, 54h, 92h, 24h

MsgCats		db	'A draw!'
MsgOWin		db	'O wins!'


                END