;	hcompo21 - 216 bytes - stewart
;
;	initial state:
;
;          EAX = xxxx****  EBX = xxxx0000	 ECX = xxxx00FF EDX = xxxxxxxx
;          ESI = xxxx0100	EDI = xxxxFFFE	 EBP = xxxx09xx ESP = xxxxFFFE
;          EIP = xxxx0100
;  DX  = CS = DS = ES = SS = xxxx, 0080 <= DX <=9000.
;
;  EFLAGS (binary) = xxxxxxxx xxxxxxxx xxxx0x1x xx0x0x1x
;
; assemble with nasm -o<outfile>.com <thisfile>
;
; the ai is a recursive implementation that's a slight variation on the example.asm by Boreal,

; NOTE - 
;
; this version allows '0' for the computer to start playing as the first move..
; from then on '0' has no effect. if that's against the rules (from the compo discussion group,
; it seems it's ok .. ) - then the entry is 218 bytes .. (swap the commented line inside the ;RULES??
; marked code)
;

	org	100h

start:

; just reset everything..

	push	word 0xb834	; segment of the top left hand corner of the board in vram
	pop	es				; for the [es:di] instructions

	xor	ax,ax			; ax=0
	int	0x10	  		; set video mode - ASSUMES ax=0 on return! 
	xchg	ax,si			; si=0x100 initially or 0x1xx for a message, so ah=0x1,si=0 
	mov	ch,0x20 		; cx=20xx  - option   - invisible
	int	0x10	  		; set cursor

;RULES??
;  mov	bx,0x01ff	; init the board, allow '0' to skip players move at every turn
	mov	bx,0x81ff 	; init the board, allow '0' to skip players move only at first turn
;RULES??

	mov	bp,bx			; initialise them

; the main loop for the mighty game:

game_loop:

; draw 2 horizontal lines

	mov	ax,0x07c4	; include attribute!
	mov	di,0xee		; offset for last line
redo:
	mov	cx,11	 		; length of line to draw		
	rep	stosw			; draw a line of 11 chars
	sub	di,0xb6		; up a bit
	jns	redo			; and repeat until -ve 
	
; draw 2 vertical lines..

	inc	ax		 		; ax=0x07c5
	mov	di,0x144  	; bottom right of right hand line
dango:
	xor	al,0xc5^0xb3  	; toggle char
	stosw	
	add	di,byte 6 
	stosw
	sub	di,byte 90
	jns	dango

; so, ax=0x7b3 
;
;	board locations are :
;  0   8   10
;  a0  a8  b0
;  140 148 150
;  
; have to have 0x140 in di at start for bit for '1'
; but before then do (ah*-20+al)<<3 - so 0x7b3 -> 0x138, which means:  
;

	inc	ax				; joy!

; does the trick :-)

next_pos:
	aad	0xec 	 		; (-20) 
	shl	ax,3			; *8
	xchg	di,ax			; di=ax
	mov	al,'O'		; set al
	bt		bx,cx			; test computer
	jnc 	draw_char	
	mov	al,'X'
	bt		bp,cx			; test player
	jc 	skip_char	
draw_char:
	stosb 				; save the byte
skip_char:
	inc	cx
	mov	ax,cx			
	aam	3				; ah=n/3 al=n%3
	sub	ah,2			; ah=ah-2
	jle	next_pos		; back for more if n<9

; 	now think about drawing the message:

	mov	cl,7			; cx=7 - length of message..and first winning line.

	or		si,si			; is there a message to draw?	
	je		skipmessage	

;	draw the message:

	mov	di,0x322  	; down 10 and right one
txt_loop:
	movsb	
	inc	di		  		; skip attribute byte
	loop	txt_loop	 	; so cx=0 iff we drew the message

skipmessage:

;	ax=0x0100 from the final sub ah,2 in the draw loop.. so ..

	cbw						; ah=0 

	int	0x16		  		; ax=<scan><ascii>
	cmp	al,0x1b			; ESC
	je	exit				; if ESC then exit
	jcxz 	start 			; :-) if we drew a message, then game over, and back to the start
	sub	al,0x30			; -'0'

;RULES??
;	jz		computer_move	;& ==0 means player skips this move, for every move 
								; nothing needed here
;RULES??

; removing the following two lines will allow non-numbers to be treated as moves
; but it's still never possible for the player to over-write a computer move..
; anyways, leave them in for now though...

        cmp     al,9                    ; compare with 9
        ja      game_loop               ; unsigned >9 is  out of range

; after leaving here and going to computer or player
; ax= xx00->xx09, 
; we have the bit for the players move...
;	check to see if player can move where they asked to:

	dec	ax					; painful sequence of instructions..
	bt		bx,ax				;& is bit in computer?
	jnc	game_loop		;& if bit wasn't set in computer array
	btr	bp,ax				; test-and-clear in player
	jnc	game_loop		; if wasn't previously set

;	now move the computer:
	
computer_move:
	push	game_loop		; set return address for final ret to be main loop

; only ever get here if we didn't draw a message, 
; in which case cx=7..

;	the recursive evaluation function:

eval_func:
	mul		si				; si=0 as it's only set near a ret, and the internal call is push/pop fenced, so ax=dx=0
	inc		dx				; dx=1
eval_loop:
	
	; check no-one is already here
 	
	test		bx,dx			
  	je			already_set
  	test	  	bp,dx
  	je			already_set			

	; if not, pretend we moved here

	xor		bx,dx	 		; flip bit

;	check for a win...

	pusha						; save state.

	mov		si,WinTable ; start of wintable
win_loop:
	test		cx,bx			; test cx&bx  - initially cx=7==first win pattern..
	jne		no_match		; if not all bits clear in the mask, then continue

	popa						; restore 
	mov		si,WinMsg	; set the win message..
win_exit:					; jump here if other player was moogled, but don't set win message..
	stc						; set carry flag to indicate a win
	ret				  		; return

no_match:		
	lodsb						; load byte from win_table
	cbw						; extend to word
	add		cx,ax			; add to cx
	jnc  		win_loop		; if carry set on overflow - done, else back for more
	popa						; reclaim state (so si=0,cx=7 etc etc)
	
	; didn't win, so recurse

	pusha						; push state for call
	xchg		bp,bx			; swap us and them
	call		eval_func	; recurse evaluation function
	popa						; pop all

	jc			bad_choice	; if carry set, then they did well,so it's a bad choice for us
	jl			win_exit		; if negative or overflow from dec 0x8000, they're moogled and can't find a good move - so take it

	mov		ax,dx			; save us as the best move so far

bad_choice:
	xor		bx,dx			; restore bit
already_set:
	shl		dx,1	  		; onto the next bit to test
	jne		eval_loop	; and back for more
 
	xor		bx,ax			; flip the best-bit (or do nothing if already a draw..)
	
	test 		bx,bp			; us&them==0 => a draw
	jz   		a_draw		;  
	
	dec		ax				; so S or O is set iff current player is moogled and couldn't find a move

	ret

DrawMsg:		db	"A draw!"		
WinMsg: 		db	"O wins!"	

; delta encoded win-table.. with one extra entry (a winline+extra) to avoid cbw overflow
; the initial win-value of 7 is in cx from the aborted draw-message, so no need to code it here.

WinTable:	db	0x31,0x11,0xb,0x3e,0x7f,0x13,0x40,0x5c	; needs to have >=0x80 after to end win_loop ok, aad is ok.

;	time to go back to dos..

exit:
	aad	0xe8				; (0xe8*1+0x1b)&0xff = 3 
	int	0x10
a_draw:
	mov 	si,DrawMsg		; set the game-is-drawn message
	ret

; the end. 


