	page	240, 132
;EXAMPLE.ASM	15-May-2003		Boreal		loren_blaney@idcomm.com
;Hugi Compo 22: Falling Tetromino Game (not to be confused with Tetris (tm))
;
;Assemble:
; tasm /m
; tlink /t

fieldHeight	equ	25-1		;play field dimensions including border
fieldWidth	equ	10+2		; (in character cells)
fieldX	equ	(40-FieldWidth)/2	;position to display Field on screen
fieldY	equ	(25-FieldHeight)/2 + 1	; (in character cells)

empty	equ	0			;No tile = black
border	equ	52			;Border tile color = light cyan

;Keyboard commands:
leftCh	equ	'j'			;move piece left
rotCh	equ	'k'			;rotate (counterclockwise)
rightCh	equ	'l'			;move right
dropCh	equ	' '			;drop piece (free fall to get points)
startCh	equ	' '			;start another game
quitCh	equ	1Bh			;quit game

	.model	tiny
	.code
	.486
	org	100h

start:
main10:	mov	ax, 0013h		;set 320x200x256 graphic mode
	int	10h			; and erase screen

	mov	score, 0		;initialize score

;Set up empty field with borders
	mov	dx, fieldHeight-1	;Y coord (char cells relative to fieldY)
main12:	mov	cx, fieldWidth-1	;X coord (char cells relative to fieldX)
main14:	imul	di, dx, fieldWidth	;si:= field + dx*fieldWidth+cx
	add	di, cx
	add	di, offset field

; if I=0 ! I=FieldWidth-1 ! J=FieldHeight-1 then Border else Empty
	mov	al, border
	cmp	cx, 0
	je	main16
	cmp	cx, fieldWidth-1
	je	main16
	cmp	dx, fieldHeight-1
	je	main16
	mov	al, empty
main16:
	stosb				;es:[di++]:= al
	dec	cx
	jns	main14
	dec	dx
	jns	main12

	call	showScore
	call	drawField

;-------------- Game playing loop ---------------
main20:	call	startPiece

	cmp	gameOver, 0		;if GameOver then quit
	jne	main80

	mov	al, pieceC		;display piece in starting position
	call	drawPiece

	mov	ax, score		;Speed:= 10 - Score/256
	shr	ax, 8
	neg	ax
	add	ax, 10
	mov	speed, ax

	mov	drop, 0			;Drop:= false

main27:	call	movePiece		;repeat MovePiece until Blocked
	cmp	blocked, 0
	je	main27

;Copy Piece into Field
	mov	bx, 3			;for N:= 0, 4-1 do
main34:	movsx	cx, [bx+pieceX]		; Field(PieceX(N), PieceY(N)):= PieceC
	movsx	dx, [bx+pieceY]
	imul	di, dx, fieldWidth	;si:= field + dx*fieldWidth+cx
	add	di, cx
	add	di, offset field
	mov	al, pieceC
	stosb				;es:[di++]:= al
	dec	bx
	jns	main34

	call	crunchRow
	jmp	main20

main80:	call	getKey			;wait for start key
	cmp	al, startCh
	jne	main80

	jmp	main10			;loop until quitCh

;-------------------------------------------------------------------------------
;Randomly select a piece to fall down the Field

startPiece:
	pusha

	call	random			;P:= random number 0..6
	mov	di, ax
	shl	di, 2			;* 4 to index groups of 4 bytes in tbls

	shl	al, 1			;Set tile's face color
	add	al, 32			;PieceC:= P*2 + 32
	mov	pieceC, al

	mov	gameOver, 0		;GameOver:= false

;Center the Piece at the top of the Field
	mov	bx, 3			;for N:= 0, 4-1 do
sp10:	mov	al, [bx+di+tblX]	;PieceX(N):= TblX(P, N) + FieldWidth/2
	add	al, fieldWidth/2
	mov	[bx+pieceX], al
	mov	al, [bx+di+tblY]	;PieceY(N):= TblY(P, N)
	mov	[bx+pieceY], al

;Will piece overlap already played pieces?
; if Field(PieceX(N), PieceY(N)) # Empty then GameOver:= true
	movsx	dx, [bx+pieceY]
	imul	si, dx, fieldWidth	;si:= field + dx*fieldWidth+cx
	mov	al, [bx+pieceX]
	cbw
	add	ax, offset field
	add	si, ax
	lodsb				;al:= ds:[si++]
	test	al, al
	je	sp30
	 mov	gameOver, -1
sp30:
	dec	bx
	jns	sp10

	popa
	ret

;   _ _        _ _      _ _ _      _ _        _ _ _ _       _ _ _      _ _ _
;  |_|_|     _|+|_|    |_|+|_|    |_|+|_     |_|_|+|_|     |_|+|_|    |_|+|_|
;  |_|_|    |_|_|          |_|      |_|_|                  |_|          |_|
;   blue    purple     violet      pink         red        orange     yellow
;    0        1          2          3            4           5          6
;
;All pieces (except the blue block) rotate about the tile marked [+], which is
; the first entry for each piece in the tables below.
;Relative tile coordinates:
tblX	db	0, -1, -1,  0		;0
	db	0,  1, -1,  0		;1
	db	0, -1,  1,  1		;2
	db	0, -1,  0,  1		;3
	db	0, -2, -1,  1		;4
	db	0, -1,  1, -1		;5
	db	0, -1,  1,  0		;6

tblY	db	0,  0,  1,  1		;0
	db	0,  0,  1,  1		;1
	db	0,  0,  0,  1		;2
	db	0,  0,  1,  1		;3
	db	0,  0,  0,  0		;4
	db	0,  0,  0,  1		;5
	db	0,  0,  0,  1		;6

;-------------------------------------------------------------------------------
;Make piece fall while handling keyboard commands
; Outputs: gameOver

movePiece:
	pusha
	mov	bp, speed		;Cnt:= Speed

mp10:	mov	ah, 1			;if KeyHit then
	int	16h
	je	mp60			;(jump if not)

	mov	bx, 3			;for N:= 0, 4-1 do
mp20:	mov	al, [bx+pieceY]		; PY(N):= PieceY(N)
	mov	[bx+pY], al
	dec	bx
	jns	mp20

	call	getKey			;case Getkey of

	cmp	al, leftCh		;move left?
	jne	mp30			;(jump if not)
	mov	bx, 3			;for N:= 0, 4-1 do
mp25:	mov	al, [bx+pieceX]		; PX(N):= PieceX(N) - 1
	dec	al
	mov	[bx+pX], al
	dec	bx
	jns	mp25

	call	doMove
	jmp	mp60
mp30:
	cmp	al, rightCh		;move right?
	jne	mp40			;(jump if not)
	mov	bx, 3			;for N:= 0, 4-1 do
mp35:	mov	al, [bx+pieceX]		; PX(N):= PieceX(N) + 1
	inc	al
	mov	[bx+pX], al
	dec	bx
	jns	mp35

	call	doMove
	jmp	mp60
mp40:
	cmp	al, rotCh		;rotate?
	jne	mp50			;(jump if not)
	mov	al, pieceC		;if PieceC # 32 (blue block) then
	cmp	al, 32
	je	mp60			;(jump if blue block)

	mov	bx, 3			;for N:= 0, 4-1 do
	xor	si, si
mp45:	mov	al, [bx+pieceX]		;PY(N):= -(PieceX(N)-PieceX(0))
	sub	al, [si+pieceX]
	neg	al
	add	al, [si+pieceY]		; + PieceY(0)
	mov	[bx+pY], al
	mov	al, [bx+pieceY]		;PX(N):= PieceY(N) - PieceY(0)
	sub	al, [si+pieceY]
	add	al, [si+pieceX]		; + PieceX(0)
	mov	[bx+pX], al
	dec	bx
	jns	mp45

	call	doMove
	jmp	mp60
mp50:
	cmp	al, dropCh 		;free fall?
	jne	mp60			;(jump if not)
	mov	drop, -1		;Drop:= true
	xor	bp, bp			;Cnt:= 0
mp60:
	mov	cx, 1			;Delay(1)
	call	delay

	cmp	drop, 0			;loop until Drop
	jne	mp75
	dec	bp			; or Cnt <= 0
	jg	mp10
mp75:
;Move piece down
	mov	bx, 3			;for N:= 0, 4-1 do...
mp80:	mov	al, [bx+pieceX]		; PX(N):= PieceX(N)
	mov	[bx+pX], al
	mov	al, [bx+pieceY]		; PY(N):= PieceY(N) + 1
	inc	al
	mov	[bx+pY], al
	dec	bx
	jns	mp80

	call	doMove

	cmp	drop, 0			;if Drop & not Blocked then
	je	mp90
	cmp	blocked, 0
	jne	mp90
	inc	score			; Score:= Score + 1
	call	showScore
mp90:
	popa
	ret

;-------------------------------------------------------------------------------
;If tenative move is legal (not blocked) then actually do it
; Outputs: blocked

doMove:	pusha

	xor	bp, bp			;Blocked:= false
	mov	bx, 3			;for N:= 0, 4-1 do...
dm10:	mov	al, [bx+pY]		; if PY(N) < 0
	test	al, al			;  or Field(PX(N), PY(N)) # Empty then..
	js	dm15
	cbw
	imul	si, ax, fieldWidth	;si:= field + dx*fieldWidth+cx
	mov	al, [bx+pX]
	cbw
	add	si, ax
	add	si, offset field
	lodsb				;al:= ds:[si++]
	test	al, al
	je	dm20
dm15:	 mov	bp, -1			;Blocked:= true
	 jmp	dm90
dm20:	dec	bx
	jns	dm10

;If not blocked then remove piece from screen
	mov	al, empty		; DrawTile(PieceX(N), PieceY(N), Empty)
	call	drawPiece

; get piece's new position
	mov	bx, 3			;for N:= 0, 4-1 do...
dm40:	mov	al, [bx+pX]		; PieceX(N):= PX(N)
	mov	[bx+pieceX], al
	mov	al, [bx+pY]		; PieceY(N):= PY(N)
	mov	[bx+pieceY], al
	dec	bx
	jns	dm40

; and draw piece at new position
	mov	al, pieceC		;DrawTile(PieceX(N), PieceY(N), PieceC)
	call	drawPiece

dm90:	mov	blocked, bp
	popa
	ret

;-------------------------------------------------------------------------------
;If a horizontal row is full then remove it, and move everything above it down

crunchRow:
	pusha
	mov	bp, 20			;Points:= 20; (pb = points)

	mov	bx, 1			;from the top row+1 to the bottom row...
cr00:					;for J:= 0, FieldHeight-2 do
	imul	si, bx, fieldWidth	;for I:= 1, FieldWidth-2 do
	add	si, offset field+1	; if Field(I, J) = Empty then forget it
	mov	cx, fieldWidth-2
cr05:	lodsb				;al:= ds:[si++]
	test	al, al			;= Empty?
	je	cr80			;jump if a position is empty--forget row
	loop	cr05			;cx--

;Move all tiles above row J down one row
	mov	dx, bx			;for J1:= J downto 1 do
cr10:	imul	di, dx, fieldWidth
	add	di, offset field+1	;(+1 skips left border)
	mov	si, di
	sub	si, fieldWidth		;point to row above
					;  for I:= 1, FieldWidth-2 do
	mov	cx, FieldWidth-2	;    Field(I, J1):= Field(I, J1-1)
	rep movsb			;es:[di++]:= ds:[si++]; cx--
	dec	dx
	jne	cr10

;Clear top row
	mov	al, empty		;for I:= 1, FieldWidth-2 do
	mov	cx, fieldWidth-2	; Field(I, 0):= Empty
	mov	di, offset field+1
	rep stosb			;es:[di++]:= al; cx--

	call	drawField		;show the result

	add	score, bp		;Score:= Score + Points
					;20 + 40 + 80 + 160 => 20, 60, 140, 300
	shl	bp, 1			;Points:= Points << 1
	call	showScore

	mov	cx, speed		;Delay(Speed)
	call	delay
cr80:
	inc	bx
	cmp	bx, fieldHeight-2
	jna	cr00

	popa
	ret

;-------------------------------------------------------------------------------
;Draw all the tiles in the field (which includes the borders)
; Register usage:
;  cx = X coordinate (in character cells) relative to fieldX, fieldY
;  dx = Y coordinate

drawField:
	pusha

	mov	dx, FieldHeight-1
df10:	mov	cx, FieldWidth-1
df20:	imul	si, dx, fieldWidth	;si:= field + dx*fieldWidth+cx
	add	si, cx
	add	si, offset field
	lodsb				;al:= ds:[si++]
	call	drawTile		;DrawTile(I, J, Field(I,J))
	dec	cx
	jns	df20
	dec	dx
	jns	df10

	popa
	ret

;-------------------------------------------------------------------------------
;Draw a piece
; Inputs: al = tile face color (pieceC or empty)

drawPiece:
	pusha

	mov	bx, 3			;for N:= 0, 4-1 do
dp10:	movsx	cx, [bx+pieceX]
	movsx	dx, [bx+pieceY]
	call	drawTile		; DrawTile(PieceX(N), PieceY(N), PieceC)
	dec	bx
	jns	dp10

	popa
	ret

;-------------------------------------------------------------------------------
;Draw a tile
; Inputs:
;  al = tile face color
;  cx = X coordinate (in character cells) relative to fieldX, fieldY
;  dx = Y coordinate

drawTile:
	pusha
;Get coordinates (in pixels) relative to upper-left corner of screen
	add	cx, fieldX		;X0:= (X+FieldX)*8
	shl	cx, 3
	add	dx, fieldY		;Y0:= (Y+FieldY)*8
	shl	dx, 3

	mov	bx, 8			;length of side of square
	test	al, al			;if C = Empty then
	jne	dt10
	 call	drawSquare		;DrawSquare(X0, Y0, Empty, 8); Erase
	 jmp	dt30
dt10:					;else
	add	al, 3*24		;dark shadow
	call	drawSquare		;DrawSquare(X0, Y0, C+3*24, 8)

	add	al, 2*24 - 3*24		;light highlight
	dec	bx
	call	drawSquare		;DrawSquare(X0, Y0, C+2*24, 7)

	add	al, -2*24		;regular face color
	dec	bx
	inc	cx
	inc	dx
	call	drawSquare		;DrawSquare(X0+1, Y0+1, C, 6)
dt30:
	popa
	ret

;-------------------------------------------------------------------------------
;Draw a filled square
; Inputs:
;  al = color
;  bx = length of side (in pixels)
;  cx = X coordinate of upper-left corner (in pixels)
;  dx = Y coord

drawSquare:
	pusha
	push	es
	push	0A000h			;provides access to graphic screen
	pop	es

	imul	di, dx, 320		;point to upper-left corner of square
	add	di, cx			;di:= Y*320 + X

	mov	dx, bx
ds10:	mov	cx, bx
	rep stosb			;es:[di++]:= al; cx--
	add	di, 320			;move to start of next scan line
	sub	di, bx
	dec	dx
	jne	ds10

	pop	es
	popa
	ret

;-------------------------------------------------------------------------------
;Show 4-digit 'score' with leading zeros centered above playfield

showScore:
	pusha

	mov	ax, score
	mov	bx, 10			;set up divisor
	mov	cx, 4			;for 4 digits...
ss10:	cwd				;dx:= 0
	idiv	bx			;ax:= dx:ax / 10;  dx:= remainder
	add	dx, 0730h		;Screen(di):= Rem(0) + '0' + White<<8
	push	dx
	loop	ss10			;cx--

	mov	ah, 02h			;set cursor position
	mov	bh, 0
	mov	dx, (fieldY-1)*100h + (fieldX+fieldWidth/2)-2
	int	10h

	mov	cl, 4			;for 4 digit characters...
ss20:	pop	ax
	mov	ah, 0Eh			;display character
	mov	bx, 0007h
	int	10h
	loop	ss20			;cx--

	popa
	ret

;-------------------------------------------------------------------------------
;Get a keystroke and return it in al

getKey:	mov	ah, 0
	int	16h
	cmp	al, quitCh		;quit program?
	jne	gk10			;jump if not
	mov	ax, 0003h		;restore standard text mode
	int	10h
	mov	ah, 4Ch			;return to DOS
	int	21h
gk10:	ret

;-------------------------------------------------------------------------------
;Delay cx 1/18ths of a second

delay:	pusha
	mov	si, cx

	mov	ah, 0			;get tick count
	int	1Ah
del10:	mov	bl, dl			;save LSB in bl
del20:	int	1Ah			;wait for tick count to change
	cmp	bl, dl
	je	del20
	dec	si
	jne	del10

	popa
	ret

;-------------------------------------------------------------------------------
;Return (predictable) random number 0..6 in ax.

random:	push	dx

	mov	ax, seed		;seed:= seed*9421 + 1
	mul	n9421			;ref: "Master Class Assembly Language"
	inc	ax			; page 840
	mov	seed, ax

	mov	dx, 0	  		;randomNum:= remainder(seed/7)
	div	n7
	mov	ax, dx

	pop	dx
	ret

;-------------------------------------------------------------------------------

seed	dw	12345		;initial seed for random number generator
n9421	dw	9421		;random multiplier
n7	dw	7		;divisor

blocked	dw	?		;flag: piece cannot move in current direction
drop	dw	?		;flag: piece is dropping
gameOver dw	?		;flag: the game is over
score	dw	?		;display accumulated points
speed	dw	?		;speed of play (1/18th of seconds)

field	db	fieldWidth*fieldHeight dup (?)	;playfield, includes the borders

;A piece is an array of 4 tiles, each with an X and Y coordinate
pieceX	db	4 dup (?)	;coordinates of tiles in falling piece
pieceY	db	4 dup (?)	; (in character cells relative to Field)
;Each tile has 3 colors: face, highlighted edge, and shaded edge
pieceC	db	?		;face color of piece
pX	db	4 dup (?)	;tenative new piece position
pY	db	4 dup (?)

	end	start
