;Hugi Compo 22 (www.hugi.de/compo)
;
;tasm /m entry.asm
;tlink /x /3 /t entry.obj
;
;keys: j - right, l - left, k - rotate, SPACE - drop/restart, ESC - exit
;
;Coded by G3 (tgm80@mail.ru)

fieldHeight	equ	25-1		;playfield dimensions including border
fieldWidth	equ	10+2		;(in character cells)
fieldX	equ	(40-FieldWidth)/2	;position to display Field on screen
fieldY	equ	(25-FieldHeight)/2 + 1	;(in character cells)
border	equ	52+3*24			;border tile color = light cyan
dropCh	equ	' '			;drop piece (free fall to get points)
quitCh	equ	1Bh			;quit game
field	equ	2000h			;playfield offset

	.model	tiny
	.code
	.486
	org	100h

start:
	push	12345			;initial seed for random number generator
	db	025h			;first time - and ax,0D3E8h; add [di-05],dh
main10:	
	call	getKey	
	jne	main10			;loop until restart or quit
	mov	di,field-(fieldHeight-1)*256	
	mov	cx,2*(fieldHeight-1)*256
	rep	stosb			;set up empty field and 23 rows above
	mov	al, 13h			;set 320x200x256 graphic mode
	int	10h			;and erase screen
	xchg	ax,cx
	xchg	ax,bp			;score(bp) = 0
	mov	al, border		
	rep	stosb			;set up bottom border

;-------------- Game playing loop ---------------

main30:
	cwd				;dx = 0
	pop	ax			;seed = seed*9421 + 1
	imul	ax, 9421		;ref: "Master Class Assembly Language"
	inc	ax			;page 840
	push	ax
	mov	cl,7	
	div	cx			
	shl	dx, 1			;piece = 2*remainder(seed/7)
	xchg	ax,dx			;
	xchg	ax,bx			;mov bx,dx and clear sign bit in al for cbw in getKey
	mov	dx,field+(fieldWidth/2)	;dx = piece position, last 2 bits (dh6,dh7) = angle 
	call	drawPiece		;draw piece at start position 
	jc	main10			;jump if blocked

	mov	cl,10
	mov	ax,bp
	sub	cl,ah			;speed(cx) = 10 - score(bp)/256
	push	cx
movePiece:
	inc	cx
	loop	mp10
	inc	bp			;if cx=0 (drop) then score = score + 1
mp10:
	mov	ah, 1			
	int	16h
	je	mp40			;jump if keyboard buffer is empty
	call	getKey			
	jne	mp20			;jump if not drop
	xchg	ax,cx			;count(cx) = 0
mp20:
	add	al,255+dropch-'l'
	add	al,3
	jnc	mp40			;jump if key<'j' or key >'l'
	dec	ax
	jne	mp30			;jump if key='j'(ax=0FFFFh) or key='l'(ax=00001h)
	mov	ah,0C0h			;rotate if key='k' (ax=0C000h)
mp30:
	call	doMove			;move piece
mp40:
;	mov	si,1
	call	drawField		;show the result (si=time to delay)
	jcxz	mp50			;jump if count(cx)=0 (drop)
	loop	mp10			;loop while count>0
	pop	cx			;count = speed
	push	cx			
mp50:
	mov	ax,100h
	call	doMove			;move piece down
	jc	movePiece		;jump if not blocked

crunchRow:				;if a horizontal row is full then remove it
	pop	si			;si = speed
	mov	bl,10			;points = 10
	mov	ah,high field
cr10:
	cmp	ah,(high field)+fieldHeight-2
	je	main30			;jump if dh = last row
	mov	cl, fieldWidth-1
	inc	ah			;next row
	mov	di,ax
	repne	scasb			;search for empty place
	je	cr10			;jump if row is not full

	push	si
	std				
	lea	si,[di-256]
	mov	ch,fieldHeight-1
	rep movsb			;move all tiles above current row down one row
	cld
	pop	si
	
	shl	bx, 1			;points = points * 2
	add	bp,bx			;score = score + points
	call	drawField		;show the result (si=time to delay)
	jmp	cr10


;-------------------------------------------------------------------------------
;If tenative move is legal (not blocked) then actually do it
;Input: si = current position 
;       ax = offset (left - 0FFFFh, right - 000001h, rotate - 0C000h, down - 00100h)
;Output: blocked (cf=0) or not blocked (cf=1)

doMove:	

	call	dm10			;move piece to new position
	cmc				
	jc	dp60			;exit if not blocked
	neg	ax			;return piece to old position
dm10:
	call	drawPiece		;erase piece (draw piece at last position with xor)
	add	dx,ax			;position = position + offset
drawPiece:				;draw piece
	xor	si,si
	inc	si			;cf=0 (not blocked)
	push	cx
	mov	cl,8			;cx = tiles*2
dp10:
	pusha
	pushf
	mov	ax,[bx+offset tableXY]	;ax = tableXY[bx]
	ror	ax,cl
	and	ax,0303h		
	sub	al,2			;ax = tile coordinates (ah = y, al = x)
dp20:
	test	bx,bx
	je	dp30			;jump if blue block
	neg	al			;rotate (counterclockwise)
	xchg	al,ah
dp30:
	add	dh,40h			;angle = angle + 1
	jnc	dp20			;rotate while angle<4
	add	ah,dh			
	add	al,dl			;add center position to tile coordinates
	xchg	ax,bx
	add	al,32+3*24		;al = tile color
	xor	[bx],al			;move or erase tile

	cmp	bh,high field
	jc	dp40			;jump if tile above field
	cmp	al,[bx]
	je	dp50			;jump if place free
dp40:
	popf
	push	si			;cf=1 (blocked)
dp50:
	popf
	popa
	dec	cx
	loop	dp10
	pop	cx
dp60:
	ret


;-------------------------------------------------------------------------------
;Get a keystroke and return it in al

getKey:	
	cbw				;ah=0
	int	16h			;get key in al
	cbw				;ah=0
	sub	al, quitCh
	jne	gk10			;jump if not quit
	push	ax			;push 00000h
	mov	al, 03h			;restore standard text mode
	int	10h
gk10:	
	sub	al,dropCh-quitCh	;key = dropCh ?
	ret				;return from procedure or exit from application


;-------------------------------------------------------------------------------
;Show score, draw field and delay si/18 seconds

drawField:	
	pusha
	xchg	ax,bp			;ax = score 
	mov	cl,4			;output 4 digits
	mov	bl,10
df10:	
	cwd				;dx = 0
	idiv	bx			;ax = dx:ax / 10;  dx = remainder
	pusha
	xchg	ax,cx			;ax = cx
	add	al,(fieldX+fieldWidth/2)-3
	xchg	ax,dx			;dx = cursor position
	add	ax,0230h		;ah = 02, al = symbol to output
	int	10h			;set cursor position
	int	29h			;output symbol
	popa
	loop	df10				

	mov	bh,(high field)+FieldHeight-1	;from top to bottom row
	mov	di,((fieldY+FieldHeight-1)*320+fieldX+FieldWidth-1)*8 ;position on screen 
	mov	cl,FieldHeight
df20:
	mov	bl, FieldWidth-1	;from right to left
	mov	al,border
	mov	[bx],al			;set up right border
	mov	[bx-11],al		;set up left border
df30:
	mov	dl,8			;length of side of square
	pusha
	mov	al,[bx]			;black or dark shadow
	call	drawSquare		;drawSquare(x0, y0, c+3*24, 8)
	sub	al,24			;light highlight
	jc	df40			;jump if color = black
	call	drawSquare		;drawSquare(x0, y0, c+2*24, 7)
	sub	al,2*24			;regular face color	
	add	di,321
	call	drawSquare		;drawSquare(x0+1, y0+1, c, 6)
df40:
	popa
	sub	di,dx			;di = di - 8
	dec	bx
	test	bl,bl
	jns	df30	
	sub	di,(320-FieldWidth)*8	;go to next row in screen
	loop	df20

	int	1Ah			;get tick count
	add	si,dx			;si = count to delay + current tick count
df50:	
	int	1Ah			
	cmp	si,dx
	jne	df50			;jump if tick count <> si
	popa
	ret


;-------------------------------------------------------------------------------
;Table of tile coordinates
;
;    0         1          2          3           4            5          6
;  [ ][ ]     [+][ ]  [ ][+][ ]  [ ][+]     [ ][ ][+][ ]  [ ][+][ ]  [ ][+][ ]
;  [ ][ ]  [ ][ ]           [ ]     [ ][ ]                [ ]           [ ]
;   blue    purple     violet      pink         red        orange     yellow
;
;All pieces (except the blue block) rotate about the tile marked [+]

tableXY	dw	0001001001011001b	;0
	dw	0000011011100101b	;1
	dw	0000001111011001b	;2
	dw	0100001110011001b	;3

drawSquare:				;draw a filled square

	dw	0000001101100000b	;4	pusha
	dw	0000010110110100b	;5	add 	si,[7805h+si] (not useful)
	dw	0000011001111000b	;6	push	es
	
;drawSquare:				
;	pusha
;	push	es
	push	0A000h			;provides access to graphic screen
	pop	es
	mov	cx, dx
ds10:	
	pusha
	rep stosb			;es:[di++] = al; cx--
	popa
	add	di, 320			;move to start of next scan line
	dec	dx
	jne	ds10
	pop	es
	popa
	dec	dx			;dx=dx-1 for next square
	ret

	end	start
	
;-------------------------------------------------------------------------------
;history
;
;start  899        example by Boreal
;05.18  868 -31
;05.19  757 -111
;05.20  740 -17   +some bugs fixed
;05.21  677 -63
;05.22  665 -12
;05.23  600 -65
;05.24  567 -33
;05.26  546 -21
;05.27  526 -20
;05.28  514 -12
;05.29  501 -13
;05.30  497 -4
;05.31  492 -5
;06.01  462 -30
;06.02  456 -6
;06.03  439 -17
;06.04  430 -9
;06.05  418 -12
;06.06  417 -1
;06.07  413 -4
;06.08  402 -11
;06.09  399 -3
;06.10  398 -1
;06.11  394 -4
;06.12  393 -1
;06.14  387 -6
;06.15  384 -3
;06.16  382 -2
;06.18  369 -13
;06.19  368 -1
;06.24  366 -2
;07.12  364 -2
;07.17  363 -1
;07.18  361 -2
;07.21  360 -1
;07.23  359 -1

;Thanks to Boreal for fine example and test suite.
;Respects to Beeblebrox and Broken Sword. Where your entries?

