.model tiny
.code
.486

INT_KEYBOARD	equ	16h
INT_TIME	equ	1Ah
;INT_KEYBOARD	equ	60h
;INT_TIME	equ	61h

FIELD_DATA	equ	8024h-1700h	;25 lines

	org	100h

;assume ax=0000, bx=0000, cx = 00FF, si = 0100, di=FFFE, bp=09xx

start:
	mov	al, 13h			;set 320x200x256 graphic mode
	int	10h			;and erase screen

	push	12345			;initial seed for random number generator
new_game:
;---------------------------------------------------
; clear field
;---------------------------------------------------
	mov	di,FIELD_DATA-100h
	mov	cx,di
	mov	al,124
	rep	stosb

	xor	ax,ax
	cwd				;dx=0
	xor	bx,bx
	xor	bp,bp			;score=0

main_loop:
;---------------------------------------------------
;remove full lines
;---------------------------------------------------
	mov	cx,10
	mov	si,FIELD_DATA+1
	mov	di,si
remove_lines_loop:
	pusha
	repne	scasb
	je	short skip_remove_line

move_all_loop:
	mov	al,[di-100h]
	mov	[di],al
	dec	di
	cmp	di,si
	jne	short move_all_loop

	popa
	add	bp,bx			;score+=20(60,140,300)
	add	bx,bx
	pusha

	mov	di,si
	rep	stosb

	xchg	ax,dx
	call	draw_and_delay

skip_remove_line:
	popa
	add	di,100h
	jns	short remove_lines_loop	;while(di!=FIELD_DATA+1+1700h)

;---------------------------------------------------
; make 'random' tetromino number
;---------------------------------------------------
	xchg	ax,dx		;ax=0
	pop	ax
	imul	ax,9421
	inc	ax
	push	ax

	div	word ptr number7
	mov	di,dx
	add	di,di

;---------------------------------------------------
; calculate falling speed
;---------------------------------------------------
	mov	dx,cx			;dx=cx=10
	mov	ax,bp
	sub	dl,ah			;speed=10-score/256
	
;---------------------------------------------------
	mov	bx,FIELD_DATA-200h+4	;start position
	dec	cx			;cx=9 start rotation
	call	check_tetromino
	jnc	short start_drop

check_key_loop:
	call	check_key
	jne	short check_key_loop
	jmp	short new_game

start_drop:
	xchg	ax,si			;ax=0 dropped=0
falling_loop:
	push	dx
	sub	bp,si			;score+=dropped
	call	draw_tetromino
	call	draw_and_delay
speed_loop:
	push	bx			;save position and rotation
	push	cx

	call	clear_tetromino

	mov	ah, 1			;if KeyHit then
	int	INT_KEYBOARD
	je	short skip_key		;(jump if not)

	call	check_key
	jne	short not_space
	mov	si,-1			;dropped=-1
	jmp	short skip_key

not_space:
	dec	bx
	cmp	al,'j'
	je	short move_tetromino

	inc	bx
	inc	bx
	cmp	al,'l'
	je	short move_tetromino

	dec	bx
	cmp	al,'k'
	jne	short end_move_tetromino

	inc	cx
move_tetromino:
	call	check_tetromino
	jnc	short end_move_tetromino

	pop	cx			;restore position and rotation
	pop	bx
	push	bx
	push	cx

end_move_tetromino:
skip_key:
	pop	ax
	pop	ax
	call	draw_tetromino

	inc	ax			;ax=0 after draw_tetromino 
	call	draw_and_delay
	or	dx,si
	jns	short speed_loop
	pop	dx

	call	clear_tetromino

	inc	bh
	call	check_tetromino
	jnc	short falling_loop

	dec	bh
	call	draw_tetromino		;ax=0 after call

	mov	bx,20
	jmp	main_loop
	
;---------------------------------------------------
check_key:
	mov	ah, 0
	int	INT_KEYBOARD
	dec	ah			;esc scan=1
	je	short exit
	cmp	al,20h
	retn
exit:
	mov	al, 03h			; ah=0, set 80x25 text mode
	int	10h			; and erase screen
	int	20h			; exit

;---------------------------------------------------
; bx - position (yyxx), cx = rotation, ax = function
; di = tetromino type*2
; for every tetromino tile call function
; return if function set flag cf=1, else cf=0
; ax=0
;---------------------------------------------------
clear_tetromino:
	mov	ax,0AAD6h		;clear_tetromino_tile (salc,stosb)
	jmp	short tetromino_work
draw_tetromino:
	mov	ax,0AA90h		;draw_tetromino_tile (nop,stosb)
	jmp	short tetromino_work
check_tetromino:
	mov	ax,0AED6h		;check_tetromino_tile (salc,scasb)
tetromino_work:
	mov	word ptr tetromino_command,ax
	mov	ax,word ptr tetromino_data[di]
tetromino_loop:
	pusha
	and	al,0Fh
	aam	4

rotation_loop:
	neg	al
	add	al,4
	xchg	al,ah
	or	di,di
	je	short no_rotation
	loop	rotation_loop
no_rotation:

	add	ax,bx
	xchg	di,ax
	add	al,104		;cf=0

tetromino_command:
	nop
	nop

	popa
	jc	short end_tetromino_loop
	shr	ax,4
	jne	short tetromino_loop
end_tetromino_loop:
end_delay_loop:
	retn

draw_and_delay:
	pusha

;---------------------------------------------------
; draw field
; after : dx=dx-1, ax=-1
;---------------------------------------------------
	push	es
	push	0A000h
	pop	es
	mov	si,FIELD_DATA+11-(-100h*24-1)
	mov	di,320*8+(14+11)*8
	mov	cx,12
loop_x:
	add	si,-100h*24-1
loop_y:
	mov	bx,0101h
draw_tile_loop_y:
	push	bx
draw_tile_loop_x:
	pusha
	lodsb
	or	al,al
	je	short draw_tile_pixel
	or	bl,bh
	js	short draw_tile_pixel	;shaded
	sub	al,24
	shr	bx,1
	jc	short draw_tile_pixel	;highlighted
	sub	al,48
draw_tile_pixel:
	stosb
	popa
	inc	di
	add	bh,bh
	jnc	short draw_tile_loop_x

	pop	bx
	add	di,320-8
	add	bl,bl
	jnc	short draw_tile_loop_y

	add	si,bx			;bx=100h
	jnl	short loop_y		;sf==of

	add	di,-320*8*24-8
	loop	short loop_x
	pop	es

;---------------------------------------------------
; draw score
;---------------------------------------------------
	xchg	ax,bp
	mov	bx,10
	push	si			;si=8124h
make_digits_loop:
	cwd
	idiv	bx
	push	dx
	mov	dx, 0012h
	sub	si,dx
	jp	make_digits_loop	;low byte = 12h,00h,EEh,DCh

	mov	ah, 02h			;set cursor position
print_score_loop:
	int	10h
	pop	ax

number7	equ	$+1
	mov	bx, 0007h
	add	ax, 0E30h		;print char
	jns	short print_score_loop

	popa

;---------------------------------------------------
; delay ax*1/18ths of a second
;---------------------------------------------------
	dec	dx
delay_loop:
	dec	ax
	js	short end_delay_loop
	pusha
	int	INT_TIME		;get tick count, ah=0
	mov	bl, dl			;save LSB in bl
delay_wait:
	int	INT_TIME		;wait for tick count to change
	cmp	bl, dl
	je	short delay_wait
	popa
	jmp	short delay_loop

	
;                            
;                            
;             highlighted -->
;                 edge       
;                            
;                            
;                            <-- shaded edge
;                            

;       _ _       _ _     _ _ _     _ _       _ _ _ _     _ _ _     _ _ _
;      |_|_|    _|+|_|   |_|+|_|   |_|+|_    |_|_|+|_|   |_|+|_|   |_|+|_|
;      |_|_|   |_|_|         |_|     |_|_|               |_|         |_|
;        32       34        36        38          40        42        44

;four tiles coordinates x+2,4-y packed at word (2 bits for coordinate)
tetromino_data:
	dw	0110101010010101b	;12 22 21 11
	dw	0101101011101001b	;11 22 32 21
	dw	0110101011101101b	;12 22 32 31
	dw	0110101010011101b	;12 22 21 31
	dw	0110101000101110b	;12 22 02 32
	dw	0110101001011110b	;12 22 11 32
	dw	0110101011101001b	;12 22 32 21

	end	start
